/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt9xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field12;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT973
extends AbstractMT
implements Serializable {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT973.class.getName());
    public static final String NAME = "973";

    public MT973(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT973(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT973 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT973(m);
    }

    public MT973() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT973(String sender, String receiver) {
        super(973, sender, receiver);
    }

    public MT973(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT973.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT973 object from FIN content with a Service Message. Check if the MT973 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT973 object from FIN content with message type " + param.getType());
        }
    }

    public static MT973 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT973(fin);
    }

    public MT973(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT973 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT973(stream);
    }

    public MT973(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT973 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT973(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT973 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT973 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT973 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT973 fromJson(String json) {
        return (MT973)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public List<Field12> getField12() {
        ArrayList<Field12> result = new ArrayList<Field12>();
        Tag[] tags = this.tags("12");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field12(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field25> getField25() {
        ArrayList<Field25> result = new ArrayList<Field25>();
        Tag[] tags = this.tags("25");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field25(tag.getValue()));
            }
        }
        return result;
    }

    public List<Loop1> getLoop1List() {
        return MT973.getLoop1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<Loop1> getLoop1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocksDelimitedWithOptionalTail(Loop1.START, Loop1.END, Loop1.TAIL)) != null && !blocks.isEmpty()) {
            ArrayList<Loop1> result = new ArrayList<Loop1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                result.add(new Loop1(b));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class Loop1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"12"};
        protected static final String[] END = new String[]{"25"};
        protected static final String[] TAIL = new String[0];

        private Loop1() {
            super(new ArrayList<Tag>());
        }

        private Loop1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static Loop1 newInstance(Tag ... tags) {
            return Loop1.newInstance(0, 0, tags);
        }

        public static Loop1 newInstance(int start, int end, Tag ... tags) {
            Loop1 result = new Loop1();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

