/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.ThreadModeSettings;
import com.puppycrawl.tools.checkstyle.XmlLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ConfigurationLoader {
    private static final String SAX_PARSE_EXCEPTION_FORMAT = "%s - %s:%s:%s";
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Check Configuration 1.0//EN";
    private static final String DTD_PUBLIC_CS_ID_1_0 = "-//Checkstyle//DTD Checkstyle Configuration 1.0//EN";
    private static final String DTD_CONFIGURATION_NAME_1_0 = "com/puppycrawl/tools/checkstyle/configuration_1_0.dtd";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Check Configuration 1.1//EN";
    private static final String DTD_PUBLIC_CS_ID_1_1 = "-//Checkstyle//DTD Checkstyle Configuration 1.1//EN";
    private static final String DTD_CONFIGURATION_NAME_1_1 = "com/puppycrawl/tools/checkstyle/configuration_1_1.dtd";
    private static final String DTD_PUBLIC_ID_1_2 = "-//Puppy Crawl//DTD Check Configuration 1.2//EN";
    private static final String DTD_PUBLIC_CS_ID_1_2 = "-//Checkstyle//DTD Checkstyle Configuration 1.2//EN";
    private static final String DTD_CONFIGURATION_NAME_1_2 = "com/puppycrawl/tools/checkstyle/configuration_1_2.dtd";
    private static final String DTD_PUBLIC_ID_1_3 = "-//Puppy Crawl//DTD Check Configuration 1.3//EN";
    private static final String DTD_PUBLIC_CS_ID_1_3 = "-//Checkstyle//DTD Checkstyle Configuration 1.3//EN";
    private static final String DTD_CONFIGURATION_NAME_1_3 = "com/puppycrawl/tools/checkstyle/configuration_1_3.dtd";
    private static final String UNABLE_TO_PARSE_EXCEPTION_PREFIX = "unable to parse configuration stream";
    private static final char DOLLAR_SIGN = '$';
    private final InternalLoader saxHandler;
    private final PropertyResolver overridePropsResolver;
    private final Deque<DefaultConfiguration> configStack = new ArrayDeque<DefaultConfiguration>();
    private final boolean omitIgnoredModules;
    private final ThreadModeSettings threadModeSettings;
    private Configuration configuration;

    private ConfigurationLoader(PropertyResolver overrideProps, boolean omitIgnoredModules, ThreadModeSettings threadModeSettings) throws ParserConfigurationException, SAXException {
        this.saxHandler = new InternalLoader();
        this.overridePropsResolver = overrideProps;
        this.omitIgnoredModules = omitIgnoredModules;
        this.threadModeSettings = threadModeSettings;
    }

    private static Map<String, String> createIdToResourceNameMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DTD_PUBLIC_ID_1_0, DTD_CONFIGURATION_NAME_1_0);
        map.put(DTD_PUBLIC_ID_1_1, DTD_CONFIGURATION_NAME_1_1);
        map.put(DTD_PUBLIC_ID_1_2, DTD_CONFIGURATION_NAME_1_2);
        map.put(DTD_PUBLIC_ID_1_3, DTD_CONFIGURATION_NAME_1_3);
        map.put(DTD_PUBLIC_CS_ID_1_0, DTD_CONFIGURATION_NAME_1_0);
        map.put(DTD_PUBLIC_CS_ID_1_1, DTD_CONFIGURATION_NAME_1_1);
        map.put(DTD_PUBLIC_CS_ID_1_2, DTD_CONFIGURATION_NAME_1_2);
        map.put(DTD_PUBLIC_CS_ID_1_3, DTD_CONFIGURATION_NAME_1_3);
        return map;
    }

    private void parseInputSource(InputSource source) throws IOException, SAXException {
        this.saxHandler.parseInputSource(source);
    }

    public static Configuration loadConfiguration(String config, PropertyResolver overridePropsResolver) throws CheckstyleException {
        return ConfigurationLoader.loadConfiguration(config, overridePropsResolver, IgnoredModulesOptions.EXECUTE);
    }

    public static Configuration loadConfiguration(String config, PropertyResolver overridePropsResolver, ThreadModeSettings threadModeSettings) throws CheckstyleException {
        return ConfigurationLoader.loadConfiguration(config, overridePropsResolver, IgnoredModulesOptions.EXECUTE, threadModeSettings);
    }

    public static Configuration loadConfiguration(String config, PropertyResolver overridePropsResolver, IgnoredModulesOptions ignoredModulesOptions) throws CheckstyleException {
        return ConfigurationLoader.loadConfiguration(config, overridePropsResolver, ignoredModulesOptions, ThreadModeSettings.SINGLE_THREAD_MODE_INSTANCE);
    }

    public static Configuration loadConfiguration(String config, PropertyResolver overridePropsResolver, IgnoredModulesOptions ignoredModulesOptions, ThreadModeSettings threadModeSettings) throws CheckstyleException {
        URI uri = CommonUtil.getUriByFilename(config);
        InputSource source = new InputSource(uri.toString());
        return ConfigurationLoader.loadConfiguration(source, overridePropsResolver, ignoredModulesOptions, threadModeSettings);
    }

    public static Configuration loadConfiguration(InputSource configSource, PropertyResolver overridePropsResolver, IgnoredModulesOptions ignoredModulesOptions) throws CheckstyleException {
        return ConfigurationLoader.loadConfiguration(configSource, overridePropsResolver, ignoredModulesOptions, ThreadModeSettings.SINGLE_THREAD_MODE_INSTANCE);
    }

    public static Configuration loadConfiguration(InputSource configSource, PropertyResolver overridePropsResolver, IgnoredModulesOptions ignoredModulesOptions, ThreadModeSettings threadModeSettings) throws CheckstyleException {
        try {
            boolean omitIgnoreModules = ignoredModulesOptions == IgnoredModulesOptions.OMIT;
            ConfigurationLoader loader = new ConfigurationLoader(overridePropsResolver, omitIgnoreModules, threadModeSettings);
            loader.parseInputSource(configSource);
            return loader.configuration;
        }
        catch (SAXParseException ex) {
            String message = String.format(Locale.ROOT, SAX_PARSE_EXCEPTION_FORMAT, UNABLE_TO_PARSE_EXCEPTION_PREFIX, ex.getMessage(), ex.getLineNumber(), ex.getColumnNumber());
            throw new CheckstyleException(message, ex);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new CheckstyleException(UNABLE_TO_PARSE_EXCEPTION_PREFIX, ex);
        }
    }

    private static String replaceProperties(String value, PropertyResolver props, String defaultValue) throws CheckstyleException {
        if (value == null) {
            return null;
        }
        ArrayList<String> fragments = new ArrayList<String>();
        ArrayList<String> propertyRefs = new ArrayList<String>();
        ConfigurationLoader.parsePropertyString(value, fragments, propertyRefs);
        StringBuilder sb = new StringBuilder(256);
        Iterator fragmentsIterator = fragments.iterator();
        Iterator propertyRefsIterator = propertyRefs.iterator();
        while (fragmentsIterator.hasNext()) {
            String propertyName;
            String fragment = (String)fragmentsIterator.next();
            if (fragment == null && (fragment = props.resolve(propertyName = (String)propertyRefsIterator.next())) == null) {
                if (defaultValue != null) {
                    sb.replace(0, sb.length(), defaultValue);
                    break;
                }
                throw new CheckstyleException("Property ${" + propertyName + "} has not been set");
            }
            sb.append(fragment);
        }
        return sb.toString();
    }

    private static void parsePropertyString(String value, List<String> fragments, List<String> propertyRefs) throws CheckstyleException {
        int prev = 0;
        int pos = value.indexOf(36, prev);
        while (pos >= 0) {
            if (pos > 0) {
                fragments.add(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                fragments.add(String.valueOf('$'));
                prev = pos + 1;
            } else if (value.charAt(pos + 1) == '{') {
                int endName = value.indexOf(125, pos);
                if (endName == -1) {
                    throw new CheckstyleException("Syntax error in property: " + value);
                }
                String propertyName = value.substring(pos + 2, endName);
                fragments.add(null);
                propertyRefs.add(propertyName);
                prev = endName + 1;
            } else {
                if (value.charAt(pos + 1) == '$') {
                    fragments.add(String.valueOf('$'));
                } else {
                    fragments.add(value.substring(pos, pos + 2));
                }
                prev = pos + 2;
            }
            pos = value.indexOf(36, prev);
        }
        if (prev < value.length()) {
            fragments.add(value.substring(prev));
        }
    }

    private final class InternalLoader
    extends XmlLoader {
        private static final String MODULE = "module";
        private static final String NAME = "name";
        private static final String PROPERTY = "property";
        private static final String VALUE = "value";
        private static final String DEFAULT = "default";
        private static final String SEVERITY = "severity";
        private static final String MESSAGE = "message";
        private static final String METADATA = "metadata";
        private static final String KEY = "key";

        InternalLoader() throws SAXException, ParserConfigurationException {
            super(ConfigurationLoader.createIdToResourceNameMap());
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (MODULE.equals(qName)) {
                String originalName = attributes.getValue(NAME);
                String name = ConfigurationLoader.this.threadModeSettings.resolveName(originalName);
                DefaultConfiguration conf = new DefaultConfiguration(name, ConfigurationLoader.this.threadModeSettings);
                if (ConfigurationLoader.this.configuration == null) {
                    ConfigurationLoader.this.configuration = conf;
                }
                if (!ConfigurationLoader.this.configStack.isEmpty()) {
                    DefaultConfiguration top = ConfigurationLoader.this.configStack.peek();
                    top.addChild(conf);
                }
                ConfigurationLoader.this.configStack.push(conf);
            } else if (PROPERTY.equals(qName)) {
                String value;
                try {
                    value = ConfigurationLoader.replaceProperties(attributes.getValue(VALUE), ConfigurationLoader.this.overridePropsResolver, attributes.getValue(DEFAULT));
                }
                catch (CheckstyleException ex) {
                    throw new SAXException(ex);
                }
                String name = attributes.getValue(NAME);
                DefaultConfiguration top = ConfigurationLoader.this.configStack.peek();
                top.addProperty(name, value);
            } else if (MESSAGE.equals(qName)) {
                String key = attributes.getValue(KEY);
                String value = attributes.getValue(VALUE);
                DefaultConfiguration top = ConfigurationLoader.this.configStack.peek();
                top.addMessage(key, value);
            } else if (!METADATA.equals(qName)) {
                throw new IllegalStateException("Unknown name:" + qName + ".");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (MODULE.equals(qName)) {
                boolean omitModule;
                Configuration recentModule = ConfigurationLoader.this.configStack.pop();
                SeverityLevel level = null;
                if (this.containsAttribute(recentModule, SEVERITY)) {
                    try {
                        String severity = recentModule.getProperty(SEVERITY);
                        level = SeverityLevel.getInstance(severity);
                    }
                    catch (CheckstyleException ex) {
                        throw new SAXException("Problem during accessing 'severity' attribute for " + recentModule.getName(), ex);
                    }
                }
                boolean bl = omitModule = ConfigurationLoader.this.omitIgnoredModules && level == SeverityLevel.IGNORE;
                if (omitModule && !ConfigurationLoader.this.configStack.isEmpty()) {
                    DefaultConfiguration parentModule = ConfigurationLoader.this.configStack.peek();
                    parentModule.removeChild(recentModule);
                }
            }
        }

        private boolean containsAttribute(Configuration module, String attributeName) {
            String[] names = module.getPropertyNames();
            Optional<String> result = Arrays.stream(names).filter(name -> name.equals(attributeName)).findFirst();
            return result.isPresent();
        }
    }

    public static enum IgnoredModulesOptions {
        OMIT,
        EXECUTE;

    }
}

