/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.ant;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.ThreadModeSettings;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.RootModule;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.SeverityLevelCounter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class CheckstyleAntTask
extends Task {
    private static final String E_XML = "xml";
    private static final String E_PLAIN = "plain";
    private static final String TIME_SUFFIX = " ms.";
    private final List<Path> paths = new ArrayList<Path>();
    private final List<FileSet> fileSets = new ArrayList<FileSet>();
    private final List<Formatter> formatters = new ArrayList<Formatter>();
    private final List<Property> overrideProps = new ArrayList<Property>();
    private Path classpath;
    private String fileName;
    private String config;
    private boolean failOnViolation = true;
    private String failureProperty;
    private File properties;
    private int maxErrors;
    private int maxWarnings = Integer.MAX_VALUE;
    private boolean executeIgnoredModules;

    public void setFailureProperty(String propertyName) {
        this.failureProperty = propertyName;
    }

    public void setFailOnViolation(boolean fail) {
        this.failOnViolation = fail;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public void setMaxWarnings(int maxWarnings) {
        this.maxWarnings = maxWarnings;
    }

    public void addPath(Path path) {
        this.paths.add(path);
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void addFormatter(Formatter formatter) {
        this.formatters.add(formatter);
    }

    public void addProperty(Property property) {
        this.overrideProps.add(property);
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public void setClasspathRef(Reference classpathRef) {
        this.createClasspath().setRefid(classpathRef);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setFile(File file) {
        this.fileName = file.getAbsolutePath();
    }

    public void setConfig(String configuration) {
        if (this.config != null) {
            throw new BuildException("Attribute 'config' has already been set");
        }
        this.config = configuration;
    }

    public void setExecuteIgnoredModules(boolean omit) {
        this.executeIgnoredModules = omit;
    }

    public void setProperties(File props) {
        this.properties = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        long startTime = System.currentTimeMillis();
        try {
            String version = CheckstyleAntTask.class.getPackage().getImplementationVersion();
            this.log("checkstyle version " + version, 3);
            if (this.fileName == null && this.fileSets.isEmpty() && this.paths.isEmpty()) {
                throw new BuildException("Must specify at least one of 'file' or nested 'fileset' or 'path'.", this.getLocation());
            }
            if (this.config == null) {
                throw new BuildException("Must specify 'config'.", this.getLocation());
            }
            this.realExecute(version);
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.log("Total execution took " + (endTime - startTime) + TIME_SUFFIX, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realExecute(String checkstyleVersion) {
        RootModule rootModule = null;
        try {
            AuditListener[] listeners;
            rootModule = this.createRootModule();
            for (AuditListener element : listeners = this.getListeners()) {
                rootModule.addListener(element);
            }
            SeverityLevelCounter warningCounter = new SeverityLevelCounter(SeverityLevel.WARNING);
            rootModule.addListener(warningCounter);
            this.processFiles(rootModule, warningCounter, checkstyleVersion);
        }
        finally {
            if (rootModule != null) {
                rootModule.destroy();
            }
        }
    }

    private void processFiles(RootModule rootModule, SeverityLevelCounter warningCounter, String checkstyleVersion) {
        boolean okStatus;
        int numErrs;
        long startTime = System.currentTimeMillis();
        List<File> files = this.getFilesToCheck();
        long endTime = System.currentTimeMillis();
        this.log("To locate the files took " + (endTime - startTime) + TIME_SUFFIX, 3);
        this.log("Running Checkstyle " + Objects.toString(checkstyleVersion, "") + " on " + files.size() + " files", 2);
        this.log("Using configuration " + this.config, 3);
        try {
            long processingStartTime = System.currentTimeMillis();
            numErrs = rootModule.process(files);
            long processingEndTime = System.currentTimeMillis();
            this.log("To process the files took " + (processingEndTime - processingStartTime) + TIME_SUFFIX, 3);
        }
        catch (CheckstyleException ex) {
            throw new BuildException("Unable to process files: " + files, (Throwable)ex);
        }
        int numWarnings = warningCounter.getCount();
        boolean bl = okStatus = numErrs <= this.maxErrors && numWarnings <= this.maxWarnings;
        if (!okStatus) {
            String failureMsg = "Got " + numErrs + " errors and " + numWarnings + " warnings.";
            if (this.failureProperty != null) {
                this.getProject().setProperty(this.failureProperty, failureMsg);
            }
            if (this.failOnViolation) {
                throw new BuildException(failureMsg, this.getLocation());
            }
        }
    }

    private RootModule createRootModule() {
        RootModule rootModule;
        try {
            Properties props = this.createOverridingProperties();
            ThreadModeSettings threadModeSettings = ThreadModeSettings.SINGLE_THREAD_MODE_INSTANCE;
            ConfigurationLoader.IgnoredModulesOptions ignoredModulesOptions = this.executeIgnoredModules ? ConfigurationLoader.IgnoredModulesOptions.EXECUTE : ConfigurationLoader.IgnoredModulesOptions.OMIT;
            Configuration configuration = ConfigurationLoader.loadConfiguration(this.config, (PropertyResolver)new PropertiesExpander(props), ignoredModulesOptions, threadModeSettings);
            ClassLoader moduleClassLoader = Checker.class.getClassLoader();
            PackageObjectFactory factory = new PackageObjectFactory(Checker.class.getPackage().getName() + ".", moduleClassLoader);
            rootModule = (RootModule)factory.createModule(configuration.getName());
            rootModule.setModuleClassLoader(moduleClassLoader);
            rootModule.configure(configuration);
        }
        catch (CheckstyleException ex) {
            throw new BuildException(String.format(Locale.ROOT, "Unable to create Root Module: config {%s}, classpath {%s}.", this.config, this.classpath), (Throwable)ex);
        }
        return rootModule;
    }

    private Properties createOverridingProperties() {
        Properties returnValue = new Properties();
        if (this.properties != null) {
            try (InputStream inStream = Files.newInputStream(this.properties.toPath(), new OpenOption[0]);){
                returnValue.load(inStream);
            }
            catch (IOException ex) {
                throw new BuildException("Error loading Properties file '" + this.properties + "'", (Throwable)ex, this.getLocation());
            }
        }
        Hashtable antProps = this.getProject().getProperties();
        for (Map.Entry entry : antProps.entrySet()) {
            String value = String.valueOf(entry.getValue());
            returnValue.setProperty((String)entry.getKey(), value);
        }
        for (Property p : this.overrideProps) {
            returnValue.setProperty(p.getKey(), p.getValue());
        }
        return returnValue;
    }

    private AuditListener[] getListeners() {
        int formatterCount = Math.max(1, this.formatters.size());
        AuditListener[] listeners = new AuditListener[formatterCount];
        try {
            if (this.formatters.isEmpty()) {
                LogOutputStream debug = new LogOutputStream((Task)this, 4);
                LogOutputStream err = new LogOutputStream((Task)this, 0);
                listeners[0] = new DefaultLogger((OutputStream)debug, AutomaticBean.OutputStreamOptions.CLOSE, (OutputStream)err, AutomaticBean.OutputStreamOptions.CLOSE);
            } else {
                for (int i = 0; i < formatterCount; ++i) {
                    Formatter formatter = this.formatters.get(i);
                    listeners[i] = formatter.createListener(this);
                }
            }
        }
        catch (IOException ex) {
            throw new BuildException(String.format(Locale.ROOT, "Unable to create listeners: formatters {%s}.", this.formatters), (Throwable)ex);
        }
        return listeners;
    }

    private List<File> getFilesToCheck() {
        ArrayList<File> allFiles = new ArrayList<File>();
        if (this.fileName != null) {
            this.log("Adding standalone file for audit", 3);
            allFiles.add(new File(this.fileName));
        }
        List<File> filesFromFileSets = this.scanFileSets();
        allFiles.addAll(filesFromFileSets);
        List<File> filesFromPaths = this.scanPaths();
        allFiles.addAll(filesFromPaths);
        return allFiles;
    }

    private List<File> scanPaths() {
        ArrayList<File> allFiles = new ArrayList<File>();
        for (int i = 0; i < this.paths.size(); ++i) {
            Path currentPath = this.paths.get(i);
            List<File> pathFiles = this.scanPath(currentPath, i + 1);
            allFiles.addAll(pathFiles);
        }
        return allFiles;
    }

    private List<File> scanPath(Path path, int pathIndex) {
        String[] resources = path.list();
        this.log(pathIndex + ") Scanning path " + path, 3);
        ArrayList<File> allFiles = new ArrayList<File>();
        int concreteFilesCount = 0;
        for (String resource : resources) {
            File file = new File(resource);
            if (file.isFile()) {
                ++concreteFilesCount;
                allFiles.add(file);
                continue;
            }
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(file);
            scanner.scan();
            List<File> scannedFiles = this.retrieveAllScannedFiles(scanner, pathIndex);
            allFiles.addAll(scannedFiles);
        }
        if (concreteFilesCount > 0) {
            this.log(String.format(Locale.ROOT, "%d) Adding %d files from path %s", pathIndex, concreteFilesCount, path), 3);
        }
        return allFiles;
    }

    protected List<File> scanFileSets() {
        ArrayList<File> allFiles = new ArrayList<File>();
        for (int i = 0; i < this.fileSets.size(); ++i) {
            FileSet fileSet = this.fileSets.get(i);
            DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
            List<File> scannedFiles = this.retrieveAllScannedFiles(scanner, i);
            allFiles.addAll(scannedFiles);
        }
        return allFiles;
    }

    private List<File> retrieveAllScannedFiles(DirectoryScanner scanner, int logIndex) {
        String[] fileNames = scanner.getIncludedFiles();
        this.log(String.format(Locale.ROOT, "%d) Adding %d files from directory %s", logIndex, fileNames.length, scanner.getBasedir()), 3);
        return Arrays.stream(fileNames).map(name -> scanner.getBasedir() + File.separator + name).map(File::new).collect(Collectors.toList());
    }

    public static class Property {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setFile(File file) {
            this.value = file.getAbsolutePath();
        }
    }

    public static class Formatter {
        private FormatterType type;
        private File toFile;
        private boolean useFile = true;

        public void setType(FormatterType type) {
            this.type = type;
        }

        public void setTofile(File destination) {
            this.toFile = destination;
        }

        public void setUseFile(boolean use) {
            this.useFile = use;
        }

        public AuditListener createListener(Task task) throws IOException {
            AuditListener listener = this.type != null && CheckstyleAntTask.E_XML.equals(this.type.getValue()) ? this.createXmlLogger(task) : this.createDefaultLogger(task);
            return listener;
        }

        private AuditListener createDefaultLogger(Task task) throws IOException {
            DefaultLogger defaultLogger;
            if (this.toFile == null || !this.useFile) {
                defaultLogger = new DefaultLogger((OutputStream)new LogOutputStream(task, 4), AutomaticBean.OutputStreamOptions.CLOSE, (OutputStream)new LogOutputStream(task, 0), AutomaticBean.OutputStreamOptions.CLOSE);
            } else {
                OutputStream infoStream = Files.newOutputStream(this.toFile.toPath(), new OpenOption[0]);
                defaultLogger = new DefaultLogger(infoStream, AutomaticBean.OutputStreamOptions.CLOSE, infoStream, AutomaticBean.OutputStreamOptions.NONE);
            }
            return defaultLogger;
        }

        private AuditListener createXmlLogger(Task task) throws IOException {
            XMLLogger xmlLogger = this.toFile == null || !this.useFile ? new XMLLogger((OutputStream)new LogOutputStream(task, 2), AutomaticBean.OutputStreamOptions.CLOSE) : new XMLLogger(Files.newOutputStream(this.toFile.toPath(), new OpenOption[0]), AutomaticBean.OutputStreamOptions.CLOSE);
            return xmlLogger;
        }
    }

    public static class FormatterType
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"xml", "plain"};

        public String[] getValues() {
            return (String[])VALUES.clone();
        }
    }
}

