/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AbstractAutomaticBean;
import com.puppycrawl.tools.checkstyle.AuditEventDefaultFormatter;
import com.puppycrawl.tools.checkstyle.AuditEventFormatter;
import com.puppycrawl.tools.checkstyle.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class DefaultLogger
extends AbstractAutomaticBean
implements AuditListener {
    public static final String ADD_EXCEPTION_MESSAGE = "DefaultLogger.addException";
    public static final String AUDIT_STARTED_MESSAGE = "DefaultLogger.auditStarted";
    public static final String AUDIT_FINISHED_MESSAGE = "DefaultLogger.auditFinished";
    private final PrintWriter infoWriter;
    private final boolean closeInfo;
    private final PrintWriter errorWriter;
    private final boolean closeError;
    private final AuditEventFormatter formatter;

    public DefaultLogger(OutputStream outputStream, AutomaticBean.OutputStreamOptions outputStreamOptions) {
        this(outputStream, AbstractAutomaticBean.OutputStreamOptions.valueOf(outputStreamOptions.name()));
    }

    public DefaultLogger(OutputStream outputStream, AbstractAutomaticBean.OutputStreamOptions outputStreamOptions) {
        this(outputStream, outputStreamOptions, outputStream, AbstractAutomaticBean.OutputStreamOptions.NONE);
    }

    public DefaultLogger(OutputStream infoStream, AbstractAutomaticBean.OutputStreamOptions infoStreamOptions, OutputStream errorStream, AbstractAutomaticBean.OutputStreamOptions errorStreamOptions) {
        this(infoStream, infoStreamOptions, errorStream, errorStreamOptions, new AuditEventDefaultFormatter());
    }

    public DefaultLogger(OutputStream infoStream, AbstractAutomaticBean.OutputStreamOptions infoStreamOptions, OutputStream errorStream, AbstractAutomaticBean.OutputStreamOptions errorStreamOptions, AuditEventFormatter messageFormatter) {
        if (infoStreamOptions == null) {
            throw new IllegalArgumentException("Parameter infoStreamOptions can not be null");
        }
        boolean bl = this.closeInfo = infoStreamOptions == AbstractAutomaticBean.OutputStreamOptions.CLOSE;
        if (errorStreamOptions == null) {
            throw new IllegalArgumentException("Parameter errorStreamOptions can not be null");
        }
        this.closeError = errorStreamOptions == AbstractAutomaticBean.OutputStreamOptions.CLOSE;
        OutputStreamWriter infoStreamWriter = new OutputStreamWriter(infoStream, StandardCharsets.UTF_8);
        this.infoWriter = new PrintWriter(infoStreamWriter);
        if (infoStream == errorStream) {
            this.errorWriter = this.infoWriter;
        } else {
            OutputStreamWriter errorStreamWriter = new OutputStreamWriter(errorStream, StandardCharsets.UTF_8);
            this.errorWriter = new PrintWriter(errorStreamWriter);
        }
        this.formatter = messageFormatter;
    }

    @Override
    protected void finishLocalSetup() {
    }

    @Override
    public void addError(AuditEvent event) {
        SeverityLevel severityLevel = event.getSeverityLevel();
        if (severityLevel != SeverityLevel.IGNORE) {
            String errorMessage = this.formatter.format(event);
            this.errorWriter.println(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        PrintWriter printWriter = this.errorWriter;
        synchronized (printWriter) {
            LocalizedMessage exceptionMessage = new LocalizedMessage("com.puppycrawl.tools.checkstyle.messages", DefaultLogger.class, ADD_EXCEPTION_MESSAGE, event.getFileName());
            this.errorWriter.println(exceptionMessage.getMessage());
            throwable.printStackTrace(this.errorWriter);
        }
    }

    @Override
    public void auditStarted(AuditEvent event) {
        LocalizedMessage auditStartMessage = new LocalizedMessage("com.puppycrawl.tools.checkstyle.messages", DefaultLogger.class, AUDIT_STARTED_MESSAGE, new Object[0]);
        this.infoWriter.println(auditStartMessage.getMessage());
        this.infoWriter.flush();
    }

    @Override
    public void auditFinished(AuditEvent event) {
        LocalizedMessage auditFinishMessage = new LocalizedMessage("com.puppycrawl.tools.checkstyle.messages", DefaultLogger.class, AUDIT_FINISHED_MESSAGE, new Object[0]);
        this.infoWriter.println(auditFinishMessage.getMessage());
        this.closeStreams();
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
        this.infoWriter.flush();
    }

    private void closeStreams() {
        this.infoWriter.flush();
        if (this.closeInfo) {
            this.infoWriter.close();
        }
        this.errorWriter.flush();
        if (this.closeError) {
            this.errorWriter.close();
        }
    }
}

