/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifierOption;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FileStatefulCheck
public class JavadocMethodCheck
extends AbstractCheck {
    public static final String MSG_CLASS_INFO = "javadoc.classInfo";
    public static final String MSG_UNUSED_TAG_GENERAL = "javadoc.unusedTagGeneral";
    public static final String MSG_INVALID_INHERIT_DOC = "javadoc.invalidInheritDoc";
    public static final String MSG_UNUSED_TAG = "javadoc.unusedTag";
    public static final String MSG_EXPECTED_TAG = "javadoc.expectedTag";
    public static final String MSG_RETURN_EXPECTED = "javadoc.return.expected";
    public static final String MSG_DUPLICATE_TAG = "javadoc.duplicateTag";
    private static final Pattern MATCH_JAVADOC_ARG = CommonUtil.createPattern("^\\s*(?>\\*|\\/\\*\\*)?\\s*@(throws|exception|param)\\s+(\\S+)\\s+\\S*");
    private static final Pattern MATCH_JAVADOC_ARG_MISSING_DESCRIPTION = CommonUtil.createPattern("^\\s*(?>\\*|\\/\\*\\*)?\\s*@(throws|exception|param)\\s+(\\S[^*]*)(?:(\\s+|\\*\\/))?");
    private static final Pattern MATCH_JAVADOC_MULTILINE_CONT = CommonUtil.createPattern("(\\*\\/|@|[^\\s\\*])");
    private static final String END_JAVADOC = "*/";
    private static final String NEXT_TAG = "@";
    private static final Pattern MATCH_JAVADOC_NOARG = CommonUtil.createPattern("^\\s*(?>\\*|\\/\\*\\*)?\\s*@(return|see)\\s+\\S");
    private static final Pattern MATCH_JAVADOC_NOARG_MULTILINE_START = CommonUtil.createPattern("^\\s*(?>\\*|\\/\\*\\*)?\\s*@(return|see)\\s*$");
    private static final Pattern MATCH_JAVADOC_NOARG_CURLY = CommonUtil.createPattern("\\{\\s*@(inheritDoc)\\s*\\}");
    private String currentClassName;
    private AccessModifierOption[] accessModifiers = new AccessModifierOption[]{AccessModifierOption.PUBLIC, AccessModifierOption.PROTECTED, AccessModifierOption.PACKAGE, AccessModifierOption.PRIVATE};
    private boolean validateThrows;
    private boolean allowMissingParamTags;
    private boolean allowMissingReturnTag;
    private Set<String> allowedAnnotations = Set.of("Override");

    public void setValidateThrows(boolean value) {
        this.validateThrows = value;
    }

    public void setAllowedAnnotations(String ... userAnnotations) {
        this.allowedAnnotations = Set.of(userAnnotations);
    }

    public void setAccessModifiers(AccessModifierOption ... accessModifiers) {
        this.accessModifiers = Arrays.copyOf(accessModifiers, accessModifiers.length);
    }

    public void setAllowMissingParamTags(boolean flag) {
        this.allowMissingParamTags = flag;
    }

    public void setAllowMissingReturnTag(boolean flag) {
        this.allowMissingReturnTag = flag;
    }

    @Override
    public final int[] getRequiredTokens() {
        return new int[]{14, 15, 154, 199};
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 154, 15, 9, 8, 161, 199, 203};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.currentClassName = "";
    }

    @Override
    public final void visitToken(DetailAST ast) {
        if (ast.getType() == 14 || ast.getType() == 15 || ast.getType() == 154 || ast.getType() == 199) {
            this.processClass(ast);
        } else {
            this.processAST(ast);
        }
    }

    @Override
    public final void leaveToken(DetailAST ast) {
        if (ast.getType() == 14 || ast.getType() == 15 || ast.getType() == 154 || ast.getType() == 199) {
            int dotIdx = this.currentClassName.lastIndexOf(36);
            this.currentClassName = this.currentClassName.substring(0, dotIdx);
        }
    }

    private void processAST(DetailAST ast) {
        FileContents contents;
        TextBlock textBlock;
        if (this.shouldCheck(ast) && (textBlock = (contents = this.getFileContents()).getJavadocBefore(ast.getLineNo())) != null) {
            this.checkComment(ast, textBlock);
        }
    }

    private boolean shouldCheck(DetailAST ast) {
        AccessModifierOption surroundingAccessModifier = CheckUtil.getSurroundingAccessModifier(ast);
        AccessModifierOption accessModifier = CheckUtil.getAccessModifierFromModifiersToken(ast);
        return surroundingAccessModifier != null && Arrays.stream(this.accessModifiers).anyMatch(modifier -> modifier == surroundingAccessModifier) && Arrays.stream(this.accessModifiers).anyMatch(modifier -> modifier == accessModifier);
    }

    private void checkComment(DetailAST ast, TextBlock comment) {
        List<JavadocTag> tags = JavadocMethodCheck.getMethodTags(comment);
        if (!this.hasShortCircuitTag(ast, tags)) {
            if (ast.getType() == 161) {
                this.checkReturnTag(tags, ast.getLineNo(), true);
            } else {
                boolean reportExpectedTags;
                Iterator<JavadocTag> it = tags.iterator();
                boolean hasInheritDocTag = false;
                while (!hasInheritDocTag && it.hasNext()) {
                    hasInheritDocTag = it.next().isInheritDocTag();
                }
                boolean bl = reportExpectedTags = !hasInheritDocTag && !AnnotationUtil.containsAnnotation(ast, this.allowedAnnotations);
                if (ast.getType() != 203) {
                    this.checkParamTags(tags, ast, reportExpectedTags);
                }
                List<ExceptionInfo> throwed = JavadocMethodCheck.combineExceptionInfo(JavadocMethodCheck.getThrows(ast), JavadocMethodCheck.getThrowed(ast));
                this.checkThrowsTags(tags, throwed, reportExpectedTags);
                if (CheckUtil.isNonVoidMethod(ast)) {
                    this.checkReturnTag(tags, ast.getLineNo(), reportExpectedTags);
                }
            }
            tags.stream().filter(javadocTag -> !javadocTag.isSeeOrInheritDocTag()).forEach(javadocTag -> this.log(javadocTag.getLineNo(), MSG_UNUSED_TAG_GENERAL, new Object[0]));
        }
    }

    private boolean hasShortCircuitTag(DetailAST ast, List<JavadocTag> tags) {
        boolean result = true;
        if (tags.size() == 1 && tags.get(0).isInheritDocTag()) {
            if (!JavadocTagInfo.INHERIT_DOC.isValidOn(ast)) {
                this.log(ast, MSG_INVALID_INHERIT_DOC, new Object[0]);
            }
        } else {
            result = false;
        }
        return result;
    }

    private static List<JavadocTag> getMethodTags(TextBlock comment) {
        String[] lines = comment.getText();
        ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>();
        int currentLine = comment.getStartLineNo() - 1;
        int startColumnNumber = comment.getStartColNo();
        for (int i = 0; i < lines.length; ++i) {
            int col;
            ++currentLine;
            Matcher javadocArgMatcher = MATCH_JAVADOC_ARG.matcher(lines[i]);
            Matcher javadocArgMissingDescriptionMatcher = MATCH_JAVADOC_ARG_MISSING_DESCRIPTION.matcher(lines[i]);
            Matcher javadocNoargMatcher = MATCH_JAVADOC_NOARG.matcher(lines[i]);
            Matcher noargCurlyMatcher = MATCH_JAVADOC_NOARG_CURLY.matcher(lines[i]);
            Matcher noargMultilineStart = MATCH_JAVADOC_NOARG_MULTILINE_START.matcher(lines[i]);
            if (javadocArgMatcher.find()) {
                col = JavadocMethodCheck.calculateTagColumn(javadocArgMatcher, i, startColumnNumber);
                tags.add(new JavadocTag(currentLine, col, javadocArgMatcher.group(1), javadocArgMatcher.group(2)));
                continue;
            }
            if (javadocArgMissingDescriptionMatcher.find()) {
                col = JavadocMethodCheck.calculateTagColumn(javadocArgMissingDescriptionMatcher, i, startColumnNumber);
                tags.add(new JavadocTag(currentLine, col, javadocArgMissingDescriptionMatcher.group(1), javadocArgMissingDescriptionMatcher.group(2)));
                continue;
            }
            if (javadocNoargMatcher.find()) {
                col = JavadocMethodCheck.calculateTagColumn(javadocNoargMatcher, i, startColumnNumber);
                tags.add(new JavadocTag(currentLine, col, javadocNoargMatcher.group(1)));
                continue;
            }
            if (noargCurlyMatcher.find()) {
                col = JavadocMethodCheck.calculateTagColumn(noargCurlyMatcher, i, startColumnNumber);
                tags.add(new JavadocTag(currentLine, col, noargCurlyMatcher.group(1)));
                continue;
            }
            if (!noargMultilineStart.find()) continue;
            tags.addAll(JavadocMethodCheck.getMultilineNoArgTags(noargMultilineStart, lines, i, currentLine));
        }
        return tags;
    }

    private static int calculateTagColumn(Matcher javadocTagMatcher, int lineNumber, int startColumnNumber) {
        int col = javadocTagMatcher.start(1) - 1;
        if (lineNumber == 0) {
            col += startColumnNumber;
        }
        return col;
    }

    private static List<JavadocTag> getMultilineNoArgTags(Matcher noargMultilineStart, String[] lines, int lineIndex, int tagLine) {
        Matcher multilineCont;
        int remIndex = lineIndex;
        while (!(multilineCont = MATCH_JAVADOC_MULTILINE_CONT.matcher(lines[++remIndex])).find()) {
        }
        ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>();
        String lFin = multilineCont.group(1);
        if (!NEXT_TAG.equals(lFin) && !END_JAVADOC.equals(lFin)) {
            String param1 = noargMultilineStart.group(1);
            int col = noargMultilineStart.start(1) - 1;
            tags.add(new JavadocTag(tagLine, col, param1));
        }
        return tags;
    }

    private static List<DetailAST> getParameters(DetailAST ast) {
        DetailAST params = ast.findFirstToken(20);
        ArrayList<DetailAST> returnValue = new ArrayList<DetailAST>();
        for (DetailAST child = params.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST ident;
            if (child.getType() != 21 || (ident = child.findFirstToken(58)) == null) continue;
            returnValue.add(ident);
        }
        return returnValue;
    }

    private static List<ExceptionInfo> getThrows(DetailAST ast) {
        ArrayList<ExceptionInfo> returnValue = new ArrayList<ExceptionInfo>();
        DetailAST throwsAST = ast.findFirstToken(81);
        if (throwsAST != null) {
            for (DetailAST child = throwsAST.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 58 && child.getType() != 59) continue;
                returnValue.add(JavadocMethodCheck.getExceptionInfo(child));
            }
        }
        return returnValue;
    }

    private static List<ExceptionInfo> getThrowed(DetailAST methodAst) {
        ArrayList<ExceptionInfo> returnValue = new ArrayList<ExceptionInfo>();
        DetailAST blockAst = methodAst.findFirstToken(7);
        if (blockAst != null) {
            List<DetailAST> throwLiterals = JavadocMethodCheck.findTokensInAstByType(blockAst, 90);
            for (DetailAST throwAst : throwLiterals) {
                DetailAST newAst;
                if (JavadocMethodCheck.isInIgnoreBlock(blockAst, throwAst) || (newAst = throwAst.getFirstChild().getFirstChild()).getType() != 136) continue;
                DetailAST child = newAst.getFirstChild();
                returnValue.add(JavadocMethodCheck.getExceptionInfo(child));
            }
        }
        return returnValue;
    }

    private static ExceptionInfo getExceptionInfo(DetailAST ast) {
        FullIdent ident = FullIdent.createFullIdent(ast);
        DetailAST firstClassNameNode = JavadocMethodCheck.getFirstClassNameNode(ast);
        return new ExceptionInfo(firstClassNameNode, new ClassInfo(new Token(ident)));
    }

    private static DetailAST getFirstClassNameNode(DetailAST ast) {
        DetailAST startNode = ast;
        while (startNode.getType() == 59) {
            startNode = startNode.getFirstChild();
        }
        return startNode;
    }

    private static boolean isInIgnoreBlock(DetailAST methodBodyAst, DetailAST throwAst) {
        DetailAST ancestor;
        for (ancestor = throwAst.getParent(); ancestor != methodBodyAst && (ancestor.getType() != 95 || ancestor.findFirstToken(96) == null) && ancestor.getType() != 181 && ancestor.getType() != 6; ancestor = ancestor.getParent()) {
            if (ancestor.getType() != 96 && ancestor.getType() != 97) continue;
            ancestor = ancestor.getParent();
        }
        return ancestor != methodBodyAst;
    }

    private static List<ExceptionInfo> combineExceptionInfo(List<ExceptionInfo> list1, List<ExceptionInfo> list2) {
        ArrayList<ExceptionInfo> result = new ArrayList<ExceptionInfo>(list1);
        for (ExceptionInfo exceptionInfo : list2) {
            if (!result.stream().noneMatch(item -> JavadocMethodCheck.isExceptionInfoSame(item, exceptionInfo))) continue;
            result.add(exceptionInfo);
        }
        return result;
    }

    public static List<DetailAST> findTokensInAstByType(DetailAST root, int astType) {
        ArrayList<DetailAST> result = new ArrayList<DetailAST>();
        DetailAST curNode = root;
        do {
            if (curNode.getType() == astType) {
                result.add(curNode);
            }
            if (curNode.hasChildren()) {
                curNode = curNode.getFirstChild();
                continue;
            }
            while (curNode != root && curNode.getNextSibling() == null) {
                curNode = curNode.getParent();
            }
            if (curNode == root) continue;
            curNode = curNode.getNextSibling();
        } while (curNode != root);
        return result;
    }

    private void checkParamTags(List<JavadocTag> tags, DetailAST parent, boolean reportExpectedTags) {
        List<DetailAST> params = JavadocMethodCheck.getParameters(parent);
        List<DetailAST> typeParams = CheckUtil.getTypeParameters(parent);
        ListIterator<JavadocTag> tagIt = tags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = tagIt.next();
            if (!tag.isParamTag()) continue;
            tagIt.remove();
            String arg1 = tag.getFirstArg();
            boolean found = JavadocMethodCheck.removeMatchingParam(params, arg1);
            if (CommonUtil.startsWithChar(arg1, '<') && CommonUtil.endsWithChar(arg1, '>')) {
                found = JavadocMethodCheck.searchMatchingTypeParameter(typeParams, arg1.substring(1, arg1.length() - 1));
            }
            if (found) continue;
            this.log(tag.getLineNo(), tag.getColumnNo(), MSG_UNUSED_TAG, "@param", arg1);
        }
        if (!this.allowMissingParamTags && reportExpectedTags) {
            for (DetailAST param : params) {
                this.log(param, MSG_EXPECTED_TAG, JavadocTagInfo.PARAM.getText(), param.getText());
            }
            for (DetailAST typeParam : typeParams) {
                this.log(typeParam, MSG_EXPECTED_TAG, JavadocTagInfo.PARAM.getText(), "<" + typeParam.findFirstToken(58).getText() + ">");
            }
        }
    }

    private static boolean searchMatchingTypeParameter(List<DetailAST> typeParams, String requiredTypeName) {
        Iterator<DetailAST> typeParamsIt = typeParams.iterator();
        boolean found = false;
        while (typeParamsIt.hasNext()) {
            DetailAST typeParam = typeParamsIt.next();
            if (!typeParam.findFirstToken(58).getText().equals(requiredTypeName)) continue;
            found = true;
            typeParamsIt.remove();
            break;
        }
        return found;
    }

    private static boolean removeMatchingParam(List<DetailAST> params, String paramName) {
        boolean found = false;
        Iterator<DetailAST> paramIt = params.iterator();
        while (paramIt.hasNext()) {
            DetailAST param = paramIt.next();
            if (!param.getText().equals(paramName)) continue;
            found = true;
            paramIt.remove();
            break;
        }
        return found;
    }

    private void checkReturnTag(List<JavadocTag> tags, int lineNo, boolean reportExpectedTags) {
        boolean found = false;
        ListIterator<JavadocTag> it = tags.listIterator();
        while (it.hasNext()) {
            JavadocTag javadocTag = it.next();
            if (!javadocTag.isReturnTag()) continue;
            if (found) {
                this.log(javadocTag.getLineNo(), javadocTag.getColumnNo(), MSG_DUPLICATE_TAG, JavadocTagInfo.RETURN.getText());
            }
            found = true;
            it.remove();
        }
        if (!found && !this.allowMissingReturnTag && reportExpectedTags) {
            this.log(lineNo, MSG_RETURN_EXPECTED, new Object[0]);
        }
    }

    private void checkThrowsTags(List<JavadocTag> tags, List<ExceptionInfo> throwsList, boolean reportExpectedTags) {
        HashSet<String> foundThrows = new HashSet<String>();
        ListIterator<JavadocTag> tagIt = tags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = tagIt.next();
            if (!tag.isThrowsTag()) continue;
            tagIt.remove();
            Token token = new Token(tag.getFirstArg(), tag.getLineNo(), tag.getColumnNo());
            ClassInfo documentedClassInfo = new ClassInfo(token);
            JavadocMethodCheck.processThrows(throwsList, documentedClassInfo, foundThrows);
        }
        if (this.validateThrows && reportExpectedTags) {
            throwsList.stream().filter(exceptionInfo -> !exceptionInfo.isFound()).forEach(exceptionInfo -> {
                Token token = exceptionInfo.getName();
                this.log(exceptionInfo.getAst(), MSG_EXPECTED_TAG, JavadocTagInfo.THROWS.getText(), token.getText());
            });
        }
    }

    private static void processThrows(List<ExceptionInfo> throwsList, ClassInfo documentedClassInfo, Set<String> foundThrows) {
        ExceptionInfo foundException = null;
        for (ExceptionInfo exceptionInfo : throwsList) {
            if (!JavadocMethodCheck.isClassNamesSame(exceptionInfo.getName().getText(), documentedClassInfo.getName().getText())) continue;
            foundException = exceptionInfo;
            break;
        }
        if (foundException != null) {
            foundException.setFound();
            foundThrows.add(documentedClassInfo.getName().getText());
        }
    }

    private static boolean isExceptionInfoSame(ExceptionInfo info1, ExceptionInfo info2) {
        return JavadocMethodCheck.isClassNamesSame(info1.getName().getText(), info2.getName().getText());
    }

    private static boolean isClassNamesSame(String class1, String class2) {
        boolean result = false;
        if (class1.equals(class2)) {
            result = true;
        } else {
            String separator = ".";
            if (class1.contains(".") || class2.contains(".")) {
                String class1ShortName = class1.substring(class1.lastIndexOf(46) + 1);
                String class2ShortName = class2.substring(class2.lastIndexOf(46) + 1);
                result = class1ShortName.equals(class2ShortName);
            }
        }
        return result;
    }

    private void processClass(DetailAST ast) {
        DetailAST ident = ast.findFirstToken(58);
        Object innerClass = ident.getText();
        innerClass = "$" + (String)innerClass;
        this.currentClassName = this.currentClassName + (String)innerClass;
    }

    private static class ExceptionInfo {
        private final DetailAST ast;
        private final ClassInfo classInfo;
        private boolean found;

        ExceptionInfo(DetailAST ast, ClassInfo classInfo) {
            this.ast = ast;
            this.classInfo = classInfo;
        }

        private DetailAST getAst() {
            return this.ast;
        }

        private void setFound() {
            this.found = true;
        }

        private boolean isFound() {
            return this.found;
        }

        private Token getName() {
            return this.classInfo.getName();
        }
    }

    private static class Token {
        private final int columnNo;
        private final int lineNo;
        private final String text;

        Token(String text, int lineNo, int columnNo) {
            this.text = text;
            this.lineNo = lineNo;
            this.columnNo = columnNo;
        }

        Token(FullIdent fullIdent) {
            this.text = fullIdent.getText();
            this.lineNo = fullIdent.getLineNo();
            this.columnNo = fullIdent.getColumnNo();
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "Token[" + this.text + "(" + this.lineNo + "x" + this.columnNo + ")]";
        }
    }

    private static class ClassInfo {
        private final Token name;

        protected ClassInfo(Token className) {
            this.name = className;
        }

        public final Token getName() {
            return this.name;
        }
    }
}

