/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.utils.UnmodifiableCollectionUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Violation
implements Comparable<Violation> {
    private static final SeverityLevel DEFAULT_SEVERITY = SeverityLevel.ERROR;
    private final int lineNo;
    private final int columnNo;
    private final int columnCharIndex;
    private final int tokenType;
    private final SeverityLevel severityLevel;
    private final String moduleId;
    private final String key;
    private final Object[] args;
    private final String bundle;
    private final Class<?> sourceClass;
    @Nullable
    private final String customMessage;

    public Violation(int lineNo, int columnNo, int columnCharIndex, int tokenType, String bundle, String key, Object[] args, SeverityLevel severityLevel, String moduleId, Class<?> sourceClass, @Nullable String customMessage) {
        this.lineNo = lineNo;
        this.columnNo = columnNo;
        this.columnCharIndex = columnCharIndex;
        this.tokenType = tokenType;
        this.key = key;
        this.args = args == null ? null : UnmodifiableCollectionUtil.copyOfArray(args, args.length);
        this.bundle = bundle;
        this.severityLevel = severityLevel;
        this.moduleId = moduleId;
        this.sourceClass = sourceClass;
        this.customMessage = customMessage;
    }

    public Violation(int lineNo, int columnNo, int tokenType, String bundle, String key, Object[] args, SeverityLevel severityLevel, String moduleId, Class<?> sourceClass, @Nullable String customMessage) {
        this(lineNo, columnNo, columnNo, tokenType, bundle, key, args, severityLevel, moduleId, sourceClass, customMessage);
    }

    public Violation(int lineNo, int columnNo, String bundle, String key, Object[] args, SeverityLevel severityLevel, String moduleId, Class<?> sourceClass, @Nullable String customMessage) {
        this(lineNo, columnNo, 0, bundle, key, args, severityLevel, moduleId, sourceClass, customMessage);
    }

    public Violation(int lineNo, int columnNo, String bundle, String key, Object[] args, String moduleId, Class<?> sourceClass, @Nullable String customMessage) {
        this(lineNo, columnNo, bundle, key, args, DEFAULT_SEVERITY, moduleId, sourceClass, customMessage);
    }

    public Violation(int lineNo, String bundle, String key, Object[] args, SeverityLevel severityLevel, String moduleId, Class<?> sourceClass, @Nullable String customMessage) {
        this(lineNo, 0, bundle, key, args, severityLevel, moduleId, sourceClass, customMessage);
    }

    public Violation(int lineNo, String bundle, String key, Object[] args, String moduleId, Class<?> sourceClass, @Nullable String customMessage) {
        this(lineNo, 0, bundle, key, args, DEFAULT_SEVERITY, moduleId, sourceClass, customMessage);
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public int getColumnCharIndex() {
        return this.columnCharIndex;
    }

    public int getTokenType() {
        return this.tokenType;
    }

    public SeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getKey() {
        return this.key;
    }

    public String getSourceName() {
        return this.sourceClass.getName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Violation violation = (Violation)object;
        return Objects.equals(this.lineNo, violation.lineNo) && Objects.equals(this.columnNo, violation.columnNo) && Objects.equals(this.columnCharIndex, violation.columnCharIndex) && Objects.equals(this.tokenType, violation.tokenType) && Objects.equals((Object)this.severityLevel, (Object)violation.severityLevel) && Objects.equals(this.moduleId, violation.moduleId) && Objects.equals(this.key, violation.key) && Objects.equals(this.bundle, violation.bundle) && Objects.equals(this.sourceClass, violation.sourceClass) && Objects.equals(this.customMessage, violation.customMessage) && Arrays.equals(this.args, violation.args);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lineNo, this.columnNo, this.columnCharIndex, this.tokenType, this.severityLevel, this.moduleId, this.key, this.bundle, this.sourceClass, this.customMessage, Arrays.hashCode(this.args)});
    }

    @Override
    public int compareTo(Violation other) {
        int result = this.lineNo == other.lineNo ? (this.columnNo == other.columnNo ? (Objects.equals(this.moduleId, other.moduleId) ? (Objects.equals(this.sourceClass, other.sourceClass) ? this.getViolation().compareTo(other.getViolation()) : (this.sourceClass == null ? -1 : (other.sourceClass == null ? 1 : this.sourceClass.getName().compareTo(other.sourceClass.getName())))) : (this.moduleId == null ? -1 : (other.moduleId == null ? 1 : this.moduleId.compareTo(other.moduleId)))) : Integer.compare(this.columnNo, other.columnNo)) : Integer.compare(this.lineNo, other.lineNo);
        return result;
    }

    public String getViolation() {
        String violation = this.customMessage != null ? new MessageFormat(this.customMessage, Locale.ROOT).format(this.args) : new LocalizedMessage(this.bundle, this.sourceClass, this.key, this.args).getMessage();
        return violation;
    }
}

