/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocTypeCheck
extends Check {
    private Scope mScope = Scope.PRIVATE;
    private Scope mExcludeScope;
    private Pattern mAuthorFormatPattern;
    private Pattern mVersionFormatPattern;
    private String mAuthorFormat;
    private String mVersionFormat;
    private boolean mAllowMissingParamTags;
    private boolean mAllowUnknownTags;

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    public void setExcludeScope(String aScope) {
        this.mExcludeScope = Scope.getInstance(aScope);
    }

    public void setAuthorFormat(String aFormat) throws ConversionException {
        try {
            this.mAuthorFormat = aFormat;
            this.mAuthorFormatPattern = Utils.getPattern(aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }

    public void setVersionFormat(String aFormat) throws ConversionException {
        try {
            this.mVersionFormat = aFormat;
            this.mVersionFormatPattern = Utils.getPattern(aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }

    public void setAllowMissingParamTags(boolean aFlag) {
        this.mAllowMissingParamTags = aFlag;
    }

    public void setAllowUnknownTags(boolean aFlag) {
        this.mAllowUnknownTags = aFlag;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{15, 14, 154, 157};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        if (this.shouldCheck(aAST)) {
            int lineNo;
            FileContents contents = this.getFileContents();
            TextBlock cmt = contents.getJavadocBefore(lineNo = aAST.getLineNo());
            if (cmt == null) {
                this.log(lineNo, "javadoc.missing", new Object[0]);
            } else if (ScopeUtils.isOuterMostType(aAST)) {
                List<JavadocTag> tags = this.getJavadocTags(cmt);
                this.checkTag(lineNo, tags, JavadocTagInfo.AUTHOR.getName(), this.mAuthorFormatPattern, this.mAuthorFormat);
                this.checkTag(lineNo, tags, JavadocTagInfo.VERSION.getName(), this.mVersionFormatPattern, this.mVersionFormat);
                List<String> typeParamNames = CheckUtils.getTypeParameterNames(aAST);
                if (!this.mAllowMissingParamTags) {
                    for (String string : typeParamNames) {
                        this.checkTypeParamTag(lineNo, tags, string);
                    }
                }
                this.checkUnusedTypeParamTags(tags, typeParamNames);
            }
        }
    }

    private boolean shouldCheck(DetailAST aAST) {
        DetailAST mods = aAST.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
        Scope scope = ScopeUtils.inInterfaceOrAnnotationBlock(aAST) ? Scope.PUBLIC : declaredScope;
        Scope surroundingScope = ScopeUtils.getSurroundingScope(aAST);
        return scope.isIn(this.mScope) && (surroundingScope == null || surroundingScope.isIn(this.mScope)) && (this.mExcludeScope == null || !scope.isIn(this.mExcludeScope) || surroundingScope != null && !surroundingScope.isIn(this.mExcludeScope));
    }

    private List<JavadocTag> getJavadocTags(TextBlock aCmt) {
        JavadocTags tags = JavadocUtils.getJavadocTags(aCmt, JavadocUtils.JavadocTagType.BLOCK);
        if (!this.mAllowUnknownTags) {
            for (InvalidJavadocTag tag : tags.getInvalidTags()) {
                this.log(tag.getLine(), tag.getCol(), "javadoc.unknownTag", tag.getName());
            }
        }
        return tags.getValidTags();
    }

    private void checkTag(int aLineNo, List<JavadocTag> aTags, String aTag, Pattern aFormatPattern, String aFormat) {
        if (aFormatPattern == null) {
            return;
        }
        int tagCount = 0;
        for (int i = aTags.size() - 1; i >= 0; --i) {
            JavadocTag tag = aTags.get(i);
            if (!tag.getTagName().equals(aTag)) continue;
            ++tagCount;
            if (aFormatPattern.matcher(tag.getArg1()).find()) continue;
            this.log(aLineNo, "type.tagFormat", "@" + aTag, aFormat);
        }
        if (tagCount == 0) {
            this.log(aLineNo, "type.missingTag", "@" + aTag);
        }
    }

    private void checkTypeParamTag(int aLineNo, List<JavadocTag> aTags, String aTypeParamName) {
        boolean found = false;
        for (int i = aTags.size() - 1; i >= 0; --i) {
            JavadocTag tag = aTags.get(i);
            if (!tag.isParamTag() || tag.getArg1() == null || tag.getArg1().indexOf("<" + aTypeParamName + ">") != 0) continue;
            found = true;
        }
        if (!found) {
            this.log(aLineNo, "type.missingTag", JavadocTagInfo.PARAM.getText() + " <" + aTypeParamName + ">");
        }
    }

    private void checkUnusedTypeParamTags(List<JavadocTag> aTags, List<String> aTypeParamNames) {
        Pattern pattern = Utils.getPattern("\\s*<([^>]+)>.*");
        for (int i = aTags.size() - 1; i >= 0; --i) {
            JavadocTag tag = aTags.get(i);
            if (!tag.isParamTag()) continue;
            if (tag.getArg1() != null) {
                Matcher matcher = pattern.matcher(tag.getArg1());
                String typeParamName = null;
                if (matcher.matches()) {
                    typeParamName = matcher.group(1).trim();
                    if (aTypeParamNames.contains(typeParamName)) continue;
                    this.log(tag.getLineNo(), tag.getColumnNo(), "javadoc.unusedTag", JavadocTagInfo.PARAM.getText(), "<" + typeParamName + ">");
                    continue;
                }
                this.log(tag.getLineNo(), tag.getColumnNo(), "javadoc.unusedTagGeneral", new Object[0]);
                continue;
            }
            this.log(tag.getLineNo(), tag.getColumnNo(), "javadoc.unusedTagGeneral", new Object[0]);
        }
    }
}

