/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.Set;

public final class IllegalTypeCheck
extends AbstractFormatCheck {
    private static final String DEFAULT_FORMAT = "^(.*[\\.])?Abstract.*$";
    private static final String[] DEFAULT_LEGAL_ABSTRACT_NAMES = new String[0];
    private static final String[] DEFAULT_ILLEGAL_TYPES = new String[]{"GregorianCalendar", "Hashtable", "HashSet", "HashMap", "ArrayList", "LinkedList", "LinkedHashMap", "LinkedHashSet", "TreeSet", "TreeMap", "Vector", "java.util.GregorianCalendar", "java.util.Hashtable", "java.util.HashSet", "java.util.HashMap", "java.util.ArrayList", "java.util.LinkedList", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.TreeSet", "java.util.TreeMap", "java.util.Vector"};
    private static final String[] DEFAULT_IGNORED_METHOD_NAMES = new String[]{"getInitialContext", "getEnvironment"};
    private final Set<String> mIllegalClassNames = Sets.newHashSet();
    private final Set<String> mLegalAbstractClassNames = Sets.newHashSet();
    private final Set<String> mIgnoredMethodNames = Sets.newHashSet();

    public IllegalTypeCheck() {
        super(DEFAULT_FORMAT);
        this.setIllegalClassNames(DEFAULT_ILLEGAL_TYPES);
        this.setLegalAbstractClassNames(DEFAULT_LEGAL_ABSTRACT_NAMES);
        this.setIgnoredMethodNames(DEFAULT_IGNORED_METHOD_NAMES);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{10, 21, 9};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 9: {
                this.visitMethodDef(aAST);
                break;
            }
            case 10: {
                this.visitVariableDef(aAST);
                break;
            }
            case 21: {
                this.visitParameterDef(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    private void visitMethodDef(DetailAST aAST) {
        if (this.isCheckedMethod(aAST)) {
            this.checkClassName(aAST);
        }
    }

    private void visitParameterDef(DetailAST aAST) {
        DetailAST grandParentAST = aAST.getParent().getParent();
        if (grandParentAST.getType() == 9 && this.isCheckedMethod(grandParentAST)) {
            this.checkClassName(aAST);
        }
    }

    private void visitVariableDef(DetailAST aAST) {
        this.checkClassName(aAST);
    }

    private void checkClassName(DetailAST aAST) {
        DetailAST type = aAST.findFirstToken(13);
        FullIdent ident = CheckUtils.createFullType(type);
        if (this.isMatchingClassName(ident.getText())) {
            this.log(ident.getLineNo(), ident.getColumnNo(), "illegal.type", ident.getText());
        }
    }

    private boolean isMatchingClassName(String aClassName) {
        return this.mIllegalClassNames.contains(aClassName) || !this.mLegalAbstractClassNames.contains(aClassName) && this.getRegexp().matcher(aClassName).find();
    }

    private boolean isCheckedMethod(DetailAST aAST) {
        String methodName = aAST.findFirstToken(59).getText();
        return !this.mIgnoredMethodNames.contains(methodName);
    }

    public void setIllegalClassNames(String[] aClassNames) {
        this.mIllegalClassNames.clear();
        for (String name : aClassNames) {
            this.mIllegalClassNames.add(name);
            int lastDot = name.lastIndexOf(".");
            if (lastDot <= 0 || lastDot >= name.length() - 1) continue;
            String shortName = name.substring(name.lastIndexOf(".") + 1);
            this.mIllegalClassNames.add(shortName);
        }
    }

    public String[] getIllegalClassNames() {
        return this.mIllegalClassNames.toArray(new String[this.mIllegalClassNames.size()]);
    }

    public void setIgnoredMethodNames(String[] aMethodNames) {
        this.mIgnoredMethodNames.clear();
        for (String element : aMethodNames) {
            this.mIgnoredMethodNames.add(element);
        }
    }

    public String[] getIgnoredMethodNames() {
        return this.mIgnoredMethodNames.toArray(new String[this.mIgnoredMethodNames.size()]);
    }

    public void setLegalAbstractClassNames(String[] aClassNames) {
        this.mLegalAbstractClassNames.clear();
        for (String element : aClassNames) {
            this.mLegalAbstractClassNames.add(element);
        }
    }

    public String[] getLegalAbstractClassNames() {
        return this.mLegalAbstractClassNames.toArray(new String[this.mLegalAbstractClassNames.size()]);
    }
}

