/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import java.util.ArrayList;
import java.util.List;

public class SingleLineJavadocCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "singleline.javadoc";
    private List<String> ignoredTags = new ArrayList<String>();
    private boolean ignoreInlineTags = true;

    public void setIgnoredTags(String ... tags) {
        this.ignoredTags = Lists.newArrayList((Object[])tags);
    }

    public void setIgnoreInlineTags(boolean ignoreInlineTags) {
        this.ignoreInlineTags = ignoreInlineTags;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{145};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (SingleLineJavadocCheck.isSingleLineJavadoc(this.getBlockCommentAst()) && (this.hasJavadocTags(ast) || !this.ignoreInlineTags && this.hasJavadocInlineTags(ast))) {
            this.log(ast.getLineNumber(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean isSingleLineJavadoc(DetailAST blockCommentStart) {
        DetailAST blockCommentEnd = blockCommentStart.getLastChild();
        return blockCommentStart.getLineNo() == blockCommentEnd.getLineNo();
    }

    private boolean hasJavadocTags(DetailNode javadocRoot) {
        DetailNode javadocTagSection = JavadocUtils.findFirstToken(javadocRoot, 10071);
        return javadocTagSection != null && !this.isTagIgnored(javadocTagSection);
    }

    private boolean hasJavadocInlineTags(DetailNode javadocRoot) {
        DetailNode javadocTagSection = JavadocUtils.findFirstToken(javadocRoot, 10072);
        boolean foundTag = false;
        while (javadocTagSection != null) {
            if (!this.isTagIgnored(javadocTagSection)) {
                foundTag = true;
                break;
            }
            javadocTagSection = JavadocUtils.getNextSibling(javadocTagSection, 10072);
        }
        return foundTag;
    }

    private boolean isTagIgnored(DetailNode javadocTagSection) {
        return this.ignoredTags.contains(JavadocUtils.getTagName(javadocTagSection));
    }
}

