/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.ClassResolver;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FileStatefulCheck
public class JavadocMethodCheck
extends AbstractCheck {
    public static final String MSG_CLASS_INFO = "javadoc.classInfo";
    public static final String MSG_UNUSED_TAG_GENERAL = "javadoc.unusedTagGeneral";
    public static final String MSG_INVALID_INHERIT_DOC = "javadoc.invalidInheritDoc";
    public static final String MSG_UNUSED_TAG = "javadoc.unusedTag";
    public static final String MSG_EXPECTED_TAG = "javadoc.expectedTag";
    public static final String MSG_RETURN_EXPECTED = "javadoc.return.expected";
    public static final String MSG_DUPLICATE_TAG = "javadoc.duplicateTag";
    private static final Pattern MATCH_JAVADOC_ARG = CommonUtil.createPattern("^\\s*(?>\\*|\\/\\*\\*)?\\s*@(throws|exception|param)\\s+(\\S+)\\s+\\S*");
    private static final Pattern MATCH_JAVADOC_ARG_MISSING_DESCRIPTION = CommonUtil.createPattern("^\\s*(?>\\*|\\/\\*\\*)?\\s*@(throws|exception|param)\\s+(\\S[^*]*)(?:(\\s+|\\*\\/))?");
    private static final Pattern MATCH_JAVADOC_MULTILINE_CONT = CommonUtil.createPattern("(\\*\\/|@|[^\\s\\*])");
    private static final String END_JAVADOC = "*/";
    private static final String NEXT_TAG = "@";
    private static final Pattern MATCH_JAVADOC_NOARG = CommonUtil.createPattern("^\\s*(?>\\*|\\/\\*\\*)?\\s*@(return|see)\\s+\\S");
    private static final Pattern MATCH_JAVADOC_NOARG_MULTILINE_START = CommonUtil.createPattern("^\\s*(?>\\*|\\/\\*\\*)?\\s*@(return|see)\\s*$");
    private static final Pattern MATCH_JAVADOC_NOARG_CURLY = CommonUtil.createPattern("\\{\\s*@(inheritDoc)\\s*\\}");
    private final Deque<Map<String, AbstractClassInfo>> currentTypeParams = new ArrayDeque<Map<String, AbstractClassInfo>>();
    private final Set<String> imports = new HashSet<String>();
    private FullIdent packageFullIdent;
    private String currentClassName;
    private ClassResolver classResolver;
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private boolean allowUndeclaredRTE;
    private boolean validateThrows;
    private boolean allowThrowsTagsForSubclasses;
    private boolean allowMissingParamTags;
    private boolean allowMissingThrowsTags;
    private boolean allowMissingReturnTag;
    private List<String> allowedAnnotations = Collections.singletonList("Override");

    public void setValidateThrows(boolean value) {
        this.validateThrows = value;
    }

    public void setAllowedAnnotations(String ... userAnnotations) {
        this.allowedAnnotations = Arrays.asList(userAnnotations);
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setExcludeScope(Scope excludeScope) {
        this.excludeScope = excludeScope;
    }

    public void setAllowUndeclaredRTE(boolean flag) {
        this.allowUndeclaredRTE = flag;
    }

    public void setAllowThrowsTagsForSubclasses(boolean flag) {
        this.allowThrowsTagsForSubclasses = flag;
    }

    public void setAllowMissingParamTags(boolean flag) {
        this.allowMissingParamTags = flag;
    }

    public void setAllowMissingThrowsTags(boolean flag) {
        this.allowMissingThrowsTags = flag;
    }

    public void setAllowMissingReturnTag(boolean flag) {
        this.allowMissingReturnTag = flag;
    }

    @Deprecated
    public final void setLogLoadErrors(boolean logLoadErrors) {
    }

    @Deprecated
    public final void setSuppressLoadErrors(boolean suppressLoadErrors) {
    }

    @Override
    public final int[] getRequiredTokens() {
        return new int[]{16, 30, 14, 15, 154};
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{16, 30, 14, 154, 15, 9, 8, 161};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.packageFullIdent = FullIdent.createFullIdent(null);
        this.imports.clear();
        this.imports.add("java.lang.*");
        this.classResolver = null;
        this.currentClassName = "";
        this.currentTypeParams.clear();
    }

    @Override
    public final void visitToken(DetailAST ast) {
        if (ast.getType() == 16) {
            this.processPackage(ast);
        } else if (ast.getType() == 30) {
            this.processImport(ast);
        } else if (ast.getType() == 14 || ast.getType() == 15 || ast.getType() == 154) {
            this.processClass(ast);
        } else {
            if (ast.getType() == 9) {
                this.processTypeParams(ast);
            }
            this.processAST(ast);
        }
    }

    @Override
    public final void leaveToken(DetailAST ast) {
        if (ast.getType() == 14 || ast.getType() == 15 || ast.getType() == 154) {
            int dotIdx = this.currentClassName.lastIndexOf(36);
            if (dotIdx == -1) {
                dotIdx = this.currentClassName.lastIndexOf(46);
            }
            this.currentClassName = dotIdx == -1 ? "" : this.currentClassName.substring(0, dotIdx);
            this.currentTypeParams.pop();
        } else if (ast.getType() == 9) {
            this.currentTypeParams.pop();
        }
    }

    private void processAST(DetailAST ast) {
        FileContents contents;
        TextBlock textBlock;
        Scope theScope = JavadocMethodCheck.calculateScope(ast);
        if (this.shouldCheck(ast, theScope) && (textBlock = (contents = this.getFileContents()).getJavadocBefore(ast.getLineNo())) != null) {
            this.checkComment(ast, textBlock);
        }
    }

    private boolean shouldCheck(DetailAST ast, Scope nodeScope) {
        Scope surroundingScope = ScopeUtil.getSurroundingScope(ast);
        return (this.excludeScope == null || nodeScope != this.excludeScope && surroundingScope != this.excludeScope) && nodeScope.isIn(this.scope) && surroundingScope.isIn(this.scope);
    }

    private void checkComment(DetailAST ast, TextBlock comment) {
        List<JavadocTag> tags = JavadocMethodCheck.getMethodTags(comment);
        if (!this.hasShortCircuitTag(ast, tags)) {
            if (ast.getType() == 161) {
                this.checkReturnTag(tags, ast.getLineNo(), true);
            } else {
                Iterator<JavadocTag> it = tags.iterator();
                boolean hasInheritDocTag = false;
                while (!hasInheritDocTag && it.hasNext()) {
                    hasInheritDocTag = it.next().isInheritDocTag();
                }
                boolean reportExpectedTags = !hasInheritDocTag && !AnnotationUtil.containsAnnotation(ast, this.allowedAnnotations);
                this.checkParamTags(tags, ast, reportExpectedTags);
                this.checkThrowsTags(tags, this.getThrows(ast), reportExpectedTags);
                if (CheckUtil.isNonVoidMethod(ast)) {
                    this.checkReturnTag(tags, ast.getLineNo(), reportExpectedTags);
                }
            }
            tags.stream().filter(javadocTag -> !javadocTag.isSeeOrInheritDocTag()).forEach(javadocTag -> this.log(javadocTag.getLineNo(), MSG_UNUSED_TAG_GENERAL, new Object[0]));
        }
    }

    private boolean hasShortCircuitTag(DetailAST ast, List<JavadocTag> tags) {
        boolean result = true;
        if (tags.size() == 1 && tags.get(0).isInheritDocTag()) {
            if (!JavadocTagInfo.INHERIT_DOC.isValidOn(ast)) {
                this.log(ast, MSG_INVALID_INHERIT_DOC, new Object[0]);
            }
        } else {
            result = false;
        }
        return result;
    }

    private static Scope calculateScope(DetailAST ast) {
        Scope scope;
        if (ScopeUtil.isInInterfaceOrAnnotationBlock(ast)) {
            scope = Scope.PUBLIC;
        } else {
            DetailAST mods = ast.findFirstToken(5);
            scope = ScopeUtil.getScopeFromMods(mods);
        }
        return scope;
    }

    private static List<JavadocTag> getMethodTags(TextBlock comment) {
        String[] lines = comment.getText();
        ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>();
        int currentLine = comment.getStartLineNo() - 1;
        int startColumnNumber = comment.getStartColNo();
        for (int i = 0; i < lines.length; ++i) {
            int col;
            ++currentLine;
            Matcher javadocArgMatcher = MATCH_JAVADOC_ARG.matcher(lines[i]);
            Matcher javadocArgMissingDescriptionMatcher = MATCH_JAVADOC_ARG_MISSING_DESCRIPTION.matcher(lines[i]);
            Matcher javadocNoargMatcher = MATCH_JAVADOC_NOARG.matcher(lines[i]);
            Matcher noargCurlyMatcher = MATCH_JAVADOC_NOARG_CURLY.matcher(lines[i]);
            Matcher noargMultilineStart = MATCH_JAVADOC_NOARG_MULTILINE_START.matcher(lines[i]);
            if (javadocArgMatcher.find()) {
                col = JavadocMethodCheck.calculateTagColumn(javadocArgMatcher, i, startColumnNumber);
                tags.add(new JavadocTag(currentLine, col, javadocArgMatcher.group(1), javadocArgMatcher.group(2)));
                continue;
            }
            if (javadocArgMissingDescriptionMatcher.find()) {
                col = JavadocMethodCheck.calculateTagColumn(javadocArgMissingDescriptionMatcher, i, startColumnNumber);
                tags.add(new JavadocTag(currentLine, col, javadocArgMissingDescriptionMatcher.group(1), javadocArgMissingDescriptionMatcher.group(2)));
                continue;
            }
            if (javadocNoargMatcher.find()) {
                col = JavadocMethodCheck.calculateTagColumn(javadocNoargMatcher, i, startColumnNumber);
                tags.add(new JavadocTag(currentLine, col, javadocNoargMatcher.group(1)));
                continue;
            }
            if (noargCurlyMatcher.find()) {
                col = JavadocMethodCheck.calculateTagColumn(noargCurlyMatcher, i, startColumnNumber);
                tags.add(new JavadocTag(currentLine, col, noargCurlyMatcher.group(1)));
                continue;
            }
            if (!noargMultilineStart.find()) continue;
            tags.addAll(JavadocMethodCheck.getMultilineNoArgTags(noargMultilineStart, lines, i, currentLine));
        }
        return tags;
    }

    private static int calculateTagColumn(Matcher javadocTagMatcher, int lineNumber, int startColumnNumber) {
        int col = javadocTagMatcher.start(1) - 1;
        if (lineNumber == 0) {
            col += startColumnNumber;
        }
        return col;
    }

    private static List<JavadocTag> getMultilineNoArgTags(Matcher noargMultilineStart, String[] lines, int lineIndex, int tagLine) {
        Matcher multilineCont;
        int remIndex = lineIndex;
        while (!(multilineCont = MATCH_JAVADOC_MULTILINE_CONT.matcher(lines[++remIndex])).find()) {
        }
        ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>();
        String lFin = multilineCont.group(1);
        if (!lFin.equals(NEXT_TAG) && !lFin.equals(END_JAVADOC)) {
            String param1 = noargMultilineStart.group(1);
            int col = noargMultilineStart.start(1) - 1;
            tags.add(new JavadocTag(tagLine, col, param1));
        }
        return tags;
    }

    private static List<DetailAST> getParameters(DetailAST ast) {
        DetailAST params = ast.findFirstToken(20);
        ArrayList<DetailAST> returnValue = new ArrayList<DetailAST>();
        for (DetailAST child = params.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST ident;
            if (child.getType() != 21 || (ident = child.findFirstToken(58)) == null) continue;
            returnValue.add(ident);
        }
        return returnValue;
    }

    private List<ExceptionInfo> getThrows(DetailAST ast) {
        ArrayList<ExceptionInfo> returnValue = new ArrayList<ExceptionInfo>();
        DetailAST throwsAST = ast.findFirstToken(81);
        if (throwsAST != null) {
            for (DetailAST child = throwsAST.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 58 && child.getType() != 59) continue;
                FullIdent ident = FullIdent.createFullIdent(child);
                ExceptionInfo exceptionInfo = new ExceptionInfo(this.createClassInfo(new Token(ident), this.currentClassName));
                returnValue.add(exceptionInfo);
            }
        }
        return returnValue;
    }

    private void checkParamTags(List<JavadocTag> tags, DetailAST parent, boolean reportExpectedTags) {
        List<DetailAST> params = JavadocMethodCheck.getParameters(parent);
        List<DetailAST> typeParams = CheckUtil.getTypeParameters(parent);
        ListIterator<JavadocTag> tagIt = tags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = tagIt.next();
            if (!tag.isParamTag()) continue;
            tagIt.remove();
            String arg1 = tag.getFirstArg();
            boolean found = JavadocMethodCheck.removeMatchingParam(params, arg1);
            if (CommonUtil.startsWithChar(arg1, '<') && CommonUtil.endsWithChar(arg1, '>')) {
                found = JavadocMethodCheck.searchMatchingTypeParameter(typeParams, arg1.substring(1, arg1.length() - 1));
            }
            if (found) continue;
            this.log(tag.getLineNo(), tag.getColumnNo(), MSG_UNUSED_TAG, "@param", arg1);
        }
        if (!this.allowMissingParamTags && reportExpectedTags) {
            for (DetailAST param : params) {
                this.log(param, MSG_EXPECTED_TAG, JavadocTagInfo.PARAM.getText(), param.getText());
            }
            for (DetailAST typeParam : typeParams) {
                this.log(typeParam, MSG_EXPECTED_TAG, JavadocTagInfo.PARAM.getText(), "<" + typeParam.findFirstToken(58).getText() + ">");
            }
        }
    }

    private static boolean searchMatchingTypeParameter(List<DetailAST> typeParams, String requiredTypeName) {
        Iterator<DetailAST> typeParamsIt = typeParams.iterator();
        boolean found = false;
        while (typeParamsIt.hasNext()) {
            DetailAST typeParam = typeParamsIt.next();
            if (!typeParam.findFirstToken(58).getText().equals(requiredTypeName)) continue;
            found = true;
            typeParamsIt.remove();
            break;
        }
        return found;
    }

    private static boolean removeMatchingParam(List<DetailAST> params, String paramName) {
        boolean found = false;
        Iterator<DetailAST> paramIt = params.iterator();
        while (paramIt.hasNext()) {
            DetailAST param = paramIt.next();
            if (!param.getText().equals(paramName)) continue;
            found = true;
            paramIt.remove();
            break;
        }
        return found;
    }

    private void checkReturnTag(List<JavadocTag> tags, int lineNo, boolean reportExpectedTags) {
        boolean found = false;
        ListIterator<JavadocTag> it = tags.listIterator();
        while (it.hasNext()) {
            JavadocTag javadocTag = it.next();
            if (!javadocTag.isReturnTag()) continue;
            if (found) {
                this.log(javadocTag.getLineNo(), javadocTag.getColumnNo(), MSG_DUPLICATE_TAG, JavadocTagInfo.RETURN.getText());
            }
            found = true;
            it.remove();
        }
        if (!found && !this.allowMissingReturnTag && reportExpectedTags) {
            this.log(lineNo, MSG_RETURN_EXPECTED, new Object[0]);
        }
    }

    private void checkThrowsTags(List<JavadocTag> tags, List<ExceptionInfo> throwsList, boolean reportExpectedTags) {
        HashSet<String> foundThrows = new HashSet<String>();
        ListIterator<JavadocTag> tagIt = tags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = tagIt.next();
            if (!tag.isThrowsTag()) continue;
            tagIt.remove();
            String documentedEx = tag.getFirstArg();
            Token token = new Token(tag.getFirstArg(), tag.getLineNo(), tag.getColumnNo());
            AbstractClassInfo documentedClassInfo = this.createClassInfo(token, this.currentClassName);
            boolean found = foundThrows.contains(documentedEx) || this.isInThrows(throwsList, documentedClassInfo, foundThrows);
            if (found) continue;
            boolean reqd = true;
            if (this.allowUndeclaredRTE) {
                boolean bl = reqd = !JavadocMethodCheck.isUnchecked(documentedClassInfo.getClazz());
            }
            if (!reqd || !this.validateThrows) continue;
            this.log(tag.getLineNo(), tag.getColumnNo(), MSG_UNUSED_TAG, JavadocTagInfo.THROWS.getText(), tag.getFirstArg());
        }
        if (!this.allowMissingThrowsTags && reportExpectedTags) {
            throwsList.stream().filter(exceptionInfo -> !((ExceptionInfo)exceptionInfo).isFound()).forEach(exceptionInfo -> {
                Token token = ((ExceptionInfo)exceptionInfo).getName();
                this.log(token.getLineNo(), token.getColumnNo(), MSG_EXPECTED_TAG, JavadocTagInfo.THROWS.getText(), token.getText());
            });
        }
    }

    private boolean isInThrows(List<ExceptionInfo> throwsList, AbstractClassInfo documentedClassInfo, Set<String> foundThrows) {
        boolean found = false;
        ExceptionInfo foundException = null;
        for (ExceptionInfo exceptionInfo : throwsList) {
            if (!exceptionInfo.getName().getText().equals(documentedClassInfo.getName().getText())) continue;
            found = true;
            foundException = exceptionInfo;
            break;
        }
        ListIterator<ExceptionInfo> exceptionInfoIt = throwsList.listIterator();
        while (!found && exceptionInfoIt.hasNext()) {
            ExceptionInfo exceptionInfo;
            exceptionInfo = exceptionInfoIt.next();
            if (documentedClassInfo.getClazz() == exceptionInfo.getClazz()) {
                found = true;
                foundException = exceptionInfo;
                continue;
            }
            if (!this.allowThrowsTagsForSubclasses) continue;
            found = JavadocMethodCheck.isSubclass(documentedClassInfo.getClazz(), exceptionInfo.getClazz());
        }
        if (foundException != null) {
            foundException.setFound();
            foundThrows.add(documentedClassInfo.getName().getText());
        }
        return found;
    }

    private static boolean isUnchecked(Class<?> exception) {
        return JavadocMethodCheck.isSubclass(exception, RuntimeException.class) || JavadocMethodCheck.isSubclass(exception, Error.class);
    }

    private static boolean isSubclass(Class<?> child, Class<?> parent) {
        return parent != null && child != null && parent.isAssignableFrom(child);
    }

    private ClassResolver getClassResolver() {
        if (this.classResolver == null) {
            this.classResolver = new ClassResolver(this.getClass().getClassLoader(), this.packageFullIdent.getText(), this.imports);
        }
        return this.classResolver;
    }

    private Class<?> resolveClass(String resolvableClassName, String className) {
        Class<?> clazz;
        try {
            clazz = this.getClassResolver().resolve(resolvableClassName, className);
        }
        catch (Exception ignored) {
            clazz = null;
        }
        return clazz;
    }

    private Class<?> tryLoadClass(Token ident, String className) {
        return this.resolveClass(ident.getText(), className);
    }

    private void processPackage(DetailAST ast) {
        DetailAST nameAST = ast.getLastChild().getPreviousSibling();
        this.packageFullIdent = FullIdent.createFullIdent(nameAST);
    }

    private void processImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdentBelow(ast);
        this.imports.add(name.getText());
    }

    private void processTypeParams(DetailAST ast) {
        DetailAST params = ast.findFirstToken(165);
        HashMap<String, AbstractClassInfo> paramsMap = new HashMap<String, AbstractClassInfo>();
        this.currentTypeParams.push(paramsMap);
        if (params != null) {
            for (DetailAST child = params.getFirstChild(); child != null; child = child.getNextSibling()) {
                DetailAST bounds;
                if (child.getType() != 166 || (bounds = child.findFirstToken(168)) == null) continue;
                FullIdent name = FullIdent.createFullIdentBelow(bounds);
                AbstractClassInfo classInfo = this.createClassInfo(new Token(name), this.currentClassName);
                String alias = child.findFirstToken(58).getText();
                paramsMap.put(alias, classInfo);
            }
        }
    }

    private void processClass(DetailAST ast) {
        DetailAST ident = ast.findFirstToken(58);
        String innerClass = ident.getText();
        if (!this.currentClassName.isEmpty()) {
            innerClass = "$" + innerClass;
        }
        this.currentClassName = this.currentClassName + innerClass;
        this.processTypeParams(ast);
    }

    private AbstractClassInfo createClassInfo(Token name, String surroundingClass) {
        AbstractClassInfo classInfo = this.findClassAlias(name.getText());
        AbstractClassInfo result = classInfo == null ? new RegularClass(name, surroundingClass, this) : new ClassAlias(name, classInfo);
        return result;
    }

    private AbstractClassInfo findClassAlias(String name) {
        Map<String, AbstractClassInfo> paramMap;
        AbstractClassInfo classInfo = null;
        Iterator<Map<String, AbstractClassInfo>> iterator = this.currentTypeParams.descendingIterator();
        while (iterator.hasNext() && (classInfo = (paramMap = iterator.next()).get(name)) == null) {
        }
        return classInfo;
    }

    private static class ExceptionInfo {
        private final AbstractClassInfo classInfo;
        private boolean found;

        ExceptionInfo(AbstractClassInfo classInfo) {
            this.classInfo = classInfo;
        }

        private void setFound() {
            this.found = true;
        }

        private boolean isFound() {
            return this.found;
        }

        private Token getName() {
            return this.classInfo.getName();
        }

        private Class<?> getClazz() {
            return this.classInfo.getClazz();
        }
    }

    private static class Token {
        private final int columnNo;
        private final int lineNo;
        private final String text;

        Token(String text, int lineNo, int columnNo) {
            this.text = text;
            this.lineNo = lineNo;
            this.columnNo = columnNo;
        }

        Token(FullIdent fullIdent) {
            this.text = fullIdent.getText();
            this.lineNo = fullIdent.getLineNo();
            this.columnNo = fullIdent.getColumnNo();
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public int getColumnNo() {
            return this.columnNo;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "Token[" + this.text + "(" + this.lineNo + "x" + this.columnNo + ")]";
        }
    }

    private static class ClassAlias
    extends AbstractClassInfo {
        private final AbstractClassInfo classInfo;

        ClassAlias(Token name, AbstractClassInfo classInfo) {
            super(name);
            this.classInfo = classInfo;
        }

        @Override
        public final Class<?> getClazz() {
            return this.classInfo.getClazz();
        }

        public String toString() {
            return "ClassAlias[alias " + this.getName() + " for " + this.classInfo.getName() + "]";
        }
    }

    private static final class RegularClass
    extends AbstractClassInfo {
        private final String surroundingClass;
        private final JavadocMethodCheck check;
        private boolean loadable = true;
        private Class<?> classObj;

        RegularClass(Token name, String surroundingClass, JavadocMethodCheck check) {
            super(name);
            this.surroundingClass = surroundingClass;
            this.check = check;
        }

        @Override
        public Class<?> getClazz() {
            if (this.loadable && this.classObj == null) {
                this.setClazz(this.check.tryLoadClass(this.getName(), this.surroundingClass));
            }
            return this.classObj;
        }

        private void setClazz(Class<?> clazz) {
            this.classObj = clazz;
            this.loadable = clazz != null;
        }

        public String toString() {
            return "RegularClass[name=" + this.getName() + ", in class='" + this.surroundingClass + '\'' + ", check=" + this.check.hashCode() + ", loadable=" + this.loadable + ", class=" + this.classObj + ']';
        }
    }

    private static abstract class AbstractClassInfo {
        private final Token name;

        protected AbstractClassInfo(Token className) {
            if (className == null) {
                throw new IllegalArgumentException("ClassInfo's name should be non-null");
            }
            this.name = className;
        }

        public abstract Class<?> getClazz();

        public final Token getName() {
            return this.name;
        }
    }
}

