/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.utils.ModuleReflectionUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PackageObjectFactory
implements ModuleFactory {
    public static final String BASE_PACKAGE = "com.puppycrawl.tools.checkstyle";
    public static final String UNABLE_TO_INSTANTIATE_EXCEPTION_MESSAGE = "PackageObjectFactory.unableToInstantiateExceptionMessage";
    public static final String AMBIGUOUS_MODULE_NAME_EXCEPTION_MESSAGE = "PackageObjectFactory.ambiguousModuleNameExceptionMessage";
    public static final String CHECK_SUFFIX = "Check";
    public static final String PACKAGE_SEPARATOR = ".";
    public static final String NULL_LOADER_MESSAGE = "moduleClassLoader must not be null";
    public static final String NULL_PACKAGE_MESSAGE = "package name must not be null";
    public static final String STRING_SEPARATOR = ", ";
    private static final Map<String, String> NAME_TO_FULL_MODULE_NAME = new HashMap<String, String>();
    private final Set<String> packages;
    private final ClassLoader moduleClassLoader;
    private Map<String, Set<String>> thirdPartyNameToFullModuleNames;
    private ModuleLoadOption moduleLoadOption;

    public PackageObjectFactory(Set<String> packageNames, ClassLoader moduleClassLoader) {
        this(packageNames, moduleClassLoader, ModuleLoadOption.SEARCH_REGISTERED_PACKAGES);
    }

    public PackageObjectFactory(Set<String> packageNames, ClassLoader moduleClassLoader, ModuleLoadOption moduleLoadOption) {
        if (moduleClassLoader == null) {
            throw new IllegalArgumentException(NULL_LOADER_MESSAGE);
        }
        if (packageNames.contains(null)) {
            throw new IllegalArgumentException(NULL_PACKAGE_MESSAGE);
        }
        this.packages = new LinkedHashSet<String>(packageNames);
        this.moduleClassLoader = moduleClassLoader;
        this.moduleLoadOption = moduleLoadOption;
    }

    public PackageObjectFactory(String packageName, ClassLoader moduleClassLoader) {
        if (moduleClassLoader == null) {
            throw new IllegalArgumentException(NULL_LOADER_MESSAGE);
        }
        if (packageName == null) {
            throw new IllegalArgumentException(NULL_PACKAGE_MESSAGE);
        }
        this.packages = Collections.singleton(packageName);
        this.moduleClassLoader = moduleClassLoader;
    }

    @Override
    public Object createModule(String name) throws CheckstyleException {
        Object instance = null;
        if (!name.contains(PACKAGE_SEPARATOR) && (instance = this.createFromStandardCheckSet(name)) == null) {
            if (this.thirdPartyNameToFullModuleNames == null) {
                this.thirdPartyNameToFullModuleNames = this.generateThirdPartyNameToFullModuleName(this.moduleClassLoader);
            }
            instance = this.createObjectFromMap(name, this.thirdPartyNameToFullModuleNames);
        }
        if (instance == null) {
            instance = this.createObject(name);
        }
        if (instance == null && this.moduleLoadOption == ModuleLoadOption.TRY_IN_ALL_REGISTERED_PACKAGES) {
            instance = this.createModuleByTryInEachPackage(name);
        }
        if (instance == null) {
            String attemptedNames = null;
            if (!name.contains(PACKAGE_SEPARATOR)) {
                String nameCheck = name + CHECK_SUFFIX;
                attemptedNames = PackageObjectFactory.joinPackageNamesWithClassName(name, this.packages) + STRING_SEPARATOR + nameCheck + STRING_SEPARATOR + PackageObjectFactory.joinPackageNamesWithClassName(nameCheck, this.packages);
            }
            LocalizedMessage exceptionMessage = new LocalizedMessage(1, "com.puppycrawl.tools.checkstyle.messages", UNABLE_TO_INSTANTIATE_EXCEPTION_MESSAGE, new String[]{name, attemptedNames}, null, this.getClass(), null);
            throw new CheckstyleException(exceptionMessage.getMessage());
        }
        return instance;
    }

    private Object createFromStandardCheckSet(String name) throws CheckstyleException {
        String fullModuleName = NAME_TO_FULL_MODULE_NAME.get(name);
        Object instance = null;
        if (fullModuleName == null) {
            String fullCheckModuleName = NAME_TO_FULL_MODULE_NAME.get(name + CHECK_SUFFIX);
            if (fullCheckModuleName != null) {
                instance = this.createObject(fullCheckModuleName);
            }
        } else {
            instance = this.createObject(fullModuleName);
        }
        return instance;
    }

    private Object createObjectFromMap(String name, Map<String, Set<String>> map) throws CheckstyleException {
        Set<String> fullModuleNames = map.get(name);
        Object instance = null;
        if (fullModuleNames == null) {
            Set<String> fullCheckModuleNames = map.get(name + CHECK_SUFFIX);
            if (fullCheckModuleNames != null) {
                instance = this.createObjectFromFullModuleNames(name, fullCheckModuleNames);
            }
        } else {
            instance = this.createObjectFromFullModuleNames(name, fullModuleNames);
        }
        return instance;
    }

    private Object createObjectFromFullModuleNames(String name, Set<String> fullModuleNames) throws CheckstyleException {
        if (fullModuleNames.size() != 1) {
            String optionalNames = fullModuleNames.stream().sorted().collect(Collectors.joining(STRING_SEPARATOR));
            LocalizedMessage exceptionMessage = new LocalizedMessage(1, "com.puppycrawl.tools.checkstyle.messages", AMBIGUOUS_MODULE_NAME_EXCEPTION_MESSAGE, new String[]{name, optionalNames}, null, this.getClass(), null);
            throw new CheckstyleException(exceptionMessage.getMessage());
        }
        Object returnValue = this.createObject(fullModuleNames.iterator().next());
        return returnValue;
    }

    private Map<String, Set<String>> generateThirdPartyNameToFullModuleName(ClassLoader loader) {
        Map<String, Set<String>> returnValue;
        try {
            returnValue = ModuleReflectionUtil.getCheckstyleModules(this.packages, loader).stream().collect(Collectors.groupingBy(Class::getSimpleName, Collectors.mapping(Class::getCanonicalName, Collectors.toSet())));
        }
        catch (IOException ignore) {
            returnValue = Collections.emptyMap();
        }
        return returnValue;
    }

    public static String getShortFromFullModuleNames(String fullName) {
        return NAME_TO_FULL_MODULE_NAME.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(fullName)).map(Map.Entry::getKey).findFirst().orElse(fullName);
    }

    private static String joinPackageNamesWithClassName(String className, Set<String> packages) {
        return packages.stream().collect(Collectors.joining(PACKAGE_SEPARATOR + className + STRING_SEPARATOR, "", PACKAGE_SEPARATOR + className));
    }

    private Object createObject(String className) throws CheckstyleException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, this.moduleClassLoader);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException throwable) {
            // empty catch block
        }
        Object instance = null;
        if (clazz != null) {
            try {
                instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new CheckstyleException("Unable to instantiate " + className, ex);
            }
        }
        return instance;
    }

    private Object createModuleByTryInEachPackage(String name) throws CheckstyleException {
        String possibleName;
        List possibleNames = this.packages.stream().map(packageName -> packageName + PACKAGE_SEPARATOR + name).flatMap(className -> Stream.of(className, className + CHECK_SUFFIX)).collect(Collectors.toList());
        Object instance = null;
        Iterator iterator = possibleNames.iterator();
        while (iterator.hasNext() && (instance = this.createObject(possibleName = (String)iterator.next())) == null) {
        }
        return instance;
    }

    private static void fillShortToFullModuleNamesMap() {
        PackageObjectFactory.fillChecksFromAnnotationPackage();
        PackageObjectFactory.fillChecksFromBlocksPackage();
        PackageObjectFactory.fillChecksFromCodingPackage();
        PackageObjectFactory.fillChecksFromDesignPackage();
        PackageObjectFactory.fillChecksFromHeaderPackage();
        PackageObjectFactory.fillChecksFromImportsPackage();
        PackageObjectFactory.fillChecksFromIndentationPackage();
        PackageObjectFactory.fillChecksFromJavadocPackage();
        PackageObjectFactory.fillChecksFromMetricsPackage();
        PackageObjectFactory.fillChecksFromModifierPackage();
        PackageObjectFactory.fillChecksFromNamingPackage();
        PackageObjectFactory.fillChecksFromRegexpPackage();
        PackageObjectFactory.fillChecksFromSizesPackage();
        PackageObjectFactory.fillChecksFromWhitespacePackage();
        PackageObjectFactory.fillModulesFromChecksPackage();
        PackageObjectFactory.fillModulesFromFilefiltersPackage();
        PackageObjectFactory.fillModulesFromFiltersPackage();
        PackageObjectFactory.fillModulesFromCheckstylePackage();
    }

    private static void fillChecksFromAnnotationPackage() {
        NAME_TO_FULL_MODULE_NAME.put("AnnotationLocationCheck", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationLocationCheck");
        NAME_TO_FULL_MODULE_NAME.put("AnnotationOnSameLineCheck", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationOnSameLineCheck");
        NAME_TO_FULL_MODULE_NAME.put("AnnotationUseStyleCheck", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingDeprecatedCheck", "com.puppycrawl.tools.checkstyle.checks.annotation.MissingDeprecatedCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingOverrideCheck", "com.puppycrawl.tools.checkstyle.checks.annotation.MissingOverrideCheck");
        NAME_TO_FULL_MODULE_NAME.put("PackageAnnotationCheck", "com.puppycrawl.tools.checkstyle.checks.annotation.PackageAnnotationCheck");
        NAME_TO_FULL_MODULE_NAME.put("SuppressWarningsCheck", "com.puppycrawl.tools.checkstyle.checks.annotation.SuppressWarningsCheck");
    }

    private static void fillChecksFromBlocksPackage() {
        NAME_TO_FULL_MODULE_NAME.put("AvoidNestedBlocksCheck", "com.puppycrawl.tools.checkstyle.checks.blocks.AvoidNestedBlocksCheck");
        NAME_TO_FULL_MODULE_NAME.put("EmptyBlockCheck", "com.puppycrawl.tools.checkstyle.checks.blocks.EmptyBlockCheck");
        NAME_TO_FULL_MODULE_NAME.put("EmptyCatchBlockCheck", "com.puppycrawl.tools.checkstyle.checks.blocks.EmptyCatchBlockCheck");
        NAME_TO_FULL_MODULE_NAME.put("LeftCurlyCheck", "com.puppycrawl.tools.checkstyle.checks.blocks.LeftCurlyCheck");
        NAME_TO_FULL_MODULE_NAME.put("NeedBracesCheck", "com.puppycrawl.tools.checkstyle.checks.blocks.NeedBracesCheck");
        NAME_TO_FULL_MODULE_NAME.put("RightCurlyCheck", "com.puppycrawl.tools.checkstyle.checks.blocks.RightCurlyCheck");
    }

    private static void fillChecksFromCodingPackage() {
        NAME_TO_FULL_MODULE_NAME.put("ArrayTrailingCommaCheck", "com.puppycrawl.tools.checkstyle.checks.coding.ArrayTrailingCommaCheck");
        NAME_TO_FULL_MODULE_NAME.put("AvoidDoubleBraceInitializationCheck", "com.puppycrawl.tools.checkstyle.checks.coding.AvoidDoubleBraceInitializationCheck");
        NAME_TO_FULL_MODULE_NAME.put("AvoidInlineConditionalsCheck", "com.puppycrawl.tools.checkstyle.checks.coding.AvoidInlineConditionalsCheck");
        NAME_TO_FULL_MODULE_NAME.put("AvoidNoArgumentSuperConstructorCallCheck", "com.puppycrawl.tools.checkstyle.checks.coding.AvoidNoArgumentSuperConstructorCallCheck");
        NAME_TO_FULL_MODULE_NAME.put("CovariantEqualsCheck", "com.puppycrawl.tools.checkstyle.checks.coding.CovariantEqualsCheck");
        NAME_TO_FULL_MODULE_NAME.put("DeclarationOrderCheck", "com.puppycrawl.tools.checkstyle.checks.coding.DeclarationOrderCheck");
        NAME_TO_FULL_MODULE_NAME.put("DefaultComesLastCheck", "com.puppycrawl.tools.checkstyle.checks.coding.DefaultComesLastCheck");
        NAME_TO_FULL_MODULE_NAME.put("EmptyStatementCheck", "com.puppycrawl.tools.checkstyle.checks.coding.EmptyStatementCheck");
        NAME_TO_FULL_MODULE_NAME.put("EqualsAvoidNullCheck", "com.puppycrawl.tools.checkstyle.checks.coding.EqualsAvoidNullCheck");
        NAME_TO_FULL_MODULE_NAME.put("EqualsHashCodeCheck", "com.puppycrawl.tools.checkstyle.checks.coding.EqualsHashCodeCheck");
        NAME_TO_FULL_MODULE_NAME.put("ExplicitInitializationCheck", "com.puppycrawl.tools.checkstyle.checks.coding.ExplicitInitializationCheck");
        NAME_TO_FULL_MODULE_NAME.put("FallThroughCheck", "com.puppycrawl.tools.checkstyle.checks.coding.FallThroughCheck");
        NAME_TO_FULL_MODULE_NAME.put("FinalLocalVariableCheck", "com.puppycrawl.tools.checkstyle.checks.coding.FinalLocalVariableCheck");
        NAME_TO_FULL_MODULE_NAME.put("HiddenFieldCheck", "com.puppycrawl.tools.checkstyle.checks.coding.HiddenFieldCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalCatchCheck", "com.puppycrawl.tools.checkstyle.checks.coding.IllegalCatchCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalInstantiationCheck", "com.puppycrawl.tools.checkstyle.checks.coding.IllegalInstantiationCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalThrowsCheck", "com.puppycrawl.tools.checkstyle.checks.coding.IllegalThrowsCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalTokenCheck", "com.puppycrawl.tools.checkstyle.checks.coding.IllegalTokenCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalTokenTextCheck", "com.puppycrawl.tools.checkstyle.checks.coding.IllegalTokenTextCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalTypeCheck", "com.puppycrawl.tools.checkstyle.checks.coding.IllegalTypeCheck");
        NAME_TO_FULL_MODULE_NAME.put("InnerAssignmentCheck", "com.puppycrawl.tools.checkstyle.checks.coding.InnerAssignmentCheck");
        NAME_TO_FULL_MODULE_NAME.put("MagicNumberCheck", "com.puppycrawl.tools.checkstyle.checks.coding.MagicNumberCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingCtorCheck", "com.puppycrawl.tools.checkstyle.checks.coding.MissingCtorCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingSwitchDefaultCheck", "com.puppycrawl.tools.checkstyle.checks.coding.MissingSwitchDefaultCheck");
        NAME_TO_FULL_MODULE_NAME.put("ModifiedControlVariableCheck", "com.puppycrawl.tools.checkstyle.checks.coding.ModifiedControlVariableCheck");
        NAME_TO_FULL_MODULE_NAME.put("MultipleStringLiteralsCheck", "com.puppycrawl.tools.checkstyle.checks.coding.MultipleStringLiteralsCheck");
        NAME_TO_FULL_MODULE_NAME.put("MultipleVariableDeclarationsCheck", "com.puppycrawl.tools.checkstyle.checks.coding.MultipleVariableDeclarationsCheck");
        NAME_TO_FULL_MODULE_NAME.put("NestedForDepthCheck", "com.puppycrawl.tools.checkstyle.checks.coding.NestedForDepthCheck");
        NAME_TO_FULL_MODULE_NAME.put("NestedIfDepthCheck", "com.puppycrawl.tools.checkstyle.checks.coding.NestedIfDepthCheck");
        NAME_TO_FULL_MODULE_NAME.put("NestedTryDepthCheck", "com.puppycrawl.tools.checkstyle.checks.coding.NestedTryDepthCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoCloneCheck", "com.puppycrawl.tools.checkstyle.checks.coding.NoCloneCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoEnumTrailingCommaCheck", "com.puppycrawl.tools.checkstyle.checks.coding.NoEnumTrailingCommaCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoFinalizerCheck", "com.puppycrawl.tools.checkstyle.checks.coding.NoFinalizerCheck");
        NAME_TO_FULL_MODULE_NAME.put("OneStatementPerLineCheck", "com.puppycrawl.tools.checkstyle.checks.coding.OneStatementPerLineCheck");
        NAME_TO_FULL_MODULE_NAME.put("OverloadMethodsDeclarationOrderCheck", "com.puppycrawl.tools.checkstyle.checks.coding.OverloadMethodsDeclarationOrderCheck");
        NAME_TO_FULL_MODULE_NAME.put("PackageDeclarationCheck", "com.puppycrawl.tools.checkstyle.checks.coding.PackageDeclarationCheck");
        NAME_TO_FULL_MODULE_NAME.put("ParameterAssignmentCheck", "com.puppycrawl.tools.checkstyle.checks.coding.ParameterAssignmentCheck");
        NAME_TO_FULL_MODULE_NAME.put("RequireThisCheck", "com.puppycrawl.tools.checkstyle.checks.coding.RequireThisCheck");
        NAME_TO_FULL_MODULE_NAME.put("ReturnCountCheck", "com.puppycrawl.tools.checkstyle.checks.coding.ReturnCountCheck");
        NAME_TO_FULL_MODULE_NAME.put("SimplifyBooleanExpressionCheck", "com.puppycrawl.tools.checkstyle.checks.coding.SimplifyBooleanExpressionCheck");
        NAME_TO_FULL_MODULE_NAME.put("SimplifyBooleanReturnCheck", "com.puppycrawl.tools.checkstyle.checks.coding.SimplifyBooleanReturnCheck");
        NAME_TO_FULL_MODULE_NAME.put("StringLiteralEqualityCheck", "com.puppycrawl.tools.checkstyle.checks.coding.StringLiteralEqualityCheck");
        NAME_TO_FULL_MODULE_NAME.put("SuperCloneCheck", "com.puppycrawl.tools.checkstyle.checks.coding.SuperCloneCheck");
        NAME_TO_FULL_MODULE_NAME.put("SuperFinalizeCheck", "com.puppycrawl.tools.checkstyle.checks.coding.SuperFinalizeCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnnecessaryParenthesesCheck", "com.puppycrawl.tools.checkstyle.checks.coding.UnnecessaryParenthesesCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnnecessarySemicolonAfterOuterTypeDeclarationCheck", "com.puppycrawl.tools.checkstyle.checks.coding.UnnecessarySemicolonAfterOuterTypeDeclarationCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnnecessarySemicolonAfterTypeMemberDeclarationCheck", "com.puppycrawl.tools.checkstyle.checks.coding.UnnecessarySemicolonAfterTypeMemberDeclarationCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnnecessarySemicolonInEnumerationCheck", "com.puppycrawl.tools.checkstyle.checks.coding.UnnecessarySemicolonInEnumerationCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnnecessarySemicolonInTryWithResourcesCheck", "com.puppycrawl.tools.checkstyle.checks.coding.UnnecessarySemicolonInTryWithResourcesCheck");
        NAME_TO_FULL_MODULE_NAME.put("VariableDeclarationUsageDistanceCheck", "com.puppycrawl.tools.checkstyle.checks.coding.VariableDeclarationUsageDistanceCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoArrayTrailingCommaCheck", "com.puppycrawl.tools.checkstyle.checks.coding.NoArrayTrailingCommaCheck");
    }

    private static void fillChecksFromDesignPackage() {
        NAME_TO_FULL_MODULE_NAME.put("DesignForExtensionCheck", "com.puppycrawl.tools.checkstyle.checks.design.DesignForExtensionCheck");
        NAME_TO_FULL_MODULE_NAME.put("FinalClassCheck", "com.puppycrawl.tools.checkstyle.checks.design.FinalClassCheck");
        NAME_TO_FULL_MODULE_NAME.put("HideUtilityClassConstructorCheck", "com.puppycrawl.tools.checkstyle.checks.design.HideUtilityClassConstructorCheck");
        NAME_TO_FULL_MODULE_NAME.put("InnerTypeLastCheck", "com.puppycrawl.tools.checkstyle.checks.design.InnerTypeLastCheck");
        NAME_TO_FULL_MODULE_NAME.put("InterfaceIsTypeCheck", "com.puppycrawl.tools.checkstyle.checks.design.InterfaceIsTypeCheck");
        NAME_TO_FULL_MODULE_NAME.put("MutableExceptionCheck", "com.puppycrawl.tools.checkstyle.checks.design.MutableExceptionCheck");
        NAME_TO_FULL_MODULE_NAME.put("OneTopLevelClassCheck", "com.puppycrawl.tools.checkstyle.checks.design.OneTopLevelClassCheck");
        NAME_TO_FULL_MODULE_NAME.put("ThrowsCountCheck", "com.puppycrawl.tools.checkstyle.checks.design.ThrowsCountCheck");
        NAME_TO_FULL_MODULE_NAME.put("VisibilityModifierCheck", "com.puppycrawl.tools.checkstyle.checks.design.VisibilityModifierCheck");
    }

    private static void fillChecksFromHeaderPackage() {
        NAME_TO_FULL_MODULE_NAME.put("HeaderCheck", "com.puppycrawl.tools.checkstyle.checks.header.HeaderCheck");
        NAME_TO_FULL_MODULE_NAME.put("RegexpHeaderCheck", "com.puppycrawl.tools.checkstyle.checks.header.RegexpHeaderCheck");
    }

    private static void fillChecksFromImportsPackage() {
        NAME_TO_FULL_MODULE_NAME.put("AvoidStarImportCheck", "com.puppycrawl.tools.checkstyle.checks.imports.AvoidStarImportCheck");
        NAME_TO_FULL_MODULE_NAME.put("AvoidStaticImportCheck", "com.puppycrawl.tools.checkstyle.checks.imports.AvoidStaticImportCheck");
        NAME_TO_FULL_MODULE_NAME.put("CustomImportOrderCheck", "com.puppycrawl.tools.checkstyle.checks.imports.CustomImportOrderCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalImportCheck", "com.puppycrawl.tools.checkstyle.checks.imports.IllegalImportCheck");
        NAME_TO_FULL_MODULE_NAME.put("ImportControlCheck", "com.puppycrawl.tools.checkstyle.checks.imports.ImportControlCheck");
        NAME_TO_FULL_MODULE_NAME.put("ImportOrderCheck", "com.puppycrawl.tools.checkstyle.checks.imports.ImportOrderCheck");
        NAME_TO_FULL_MODULE_NAME.put("RedundantImportCheck", "com.puppycrawl.tools.checkstyle.checks.imports.RedundantImportCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnusedImportsCheck", "com.puppycrawl.tools.checkstyle.checks.imports.UnusedImportsCheck");
    }

    private static void fillChecksFromIndentationPackage() {
        NAME_TO_FULL_MODULE_NAME.put("CommentsIndentationCheck", "com.puppycrawl.tools.checkstyle.checks.indentation.CommentsIndentationCheck");
        NAME_TO_FULL_MODULE_NAME.put("IndentationCheck", "com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck");
    }

    private static void fillChecksFromJavadocPackage() {
        NAME_TO_FULL_MODULE_NAME.put("AtclauseOrderCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.AtclauseOrderCheck");
        NAME_TO_FULL_MODULE_NAME.put("InvalidJavadocPositionCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocPositionCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocBlockTagLocationCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocBlockTagLocationCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocContentLocationCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocContentLocationCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocMethodCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocMethodCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocMissingWhitespaceAfterAsteriskCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocMissingWhitespaceAfterAsteriskCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocPackageCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocPackageCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocParagraphCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocParagraphCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocStyleCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocStyleCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocTagContinuationIndentationCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagContinuationIndentationCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocTypeCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTypeCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocVariableCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocVariableCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingJavadocMethodCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.MissingJavadocMethodCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingJavadocPackageCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.MissingJavadocPackageCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingJavadocTypeCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.MissingJavadocTypeCheck");
        NAME_TO_FULL_MODULE_NAME.put("NonEmptyAtclauseDescriptionCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.NonEmptyAtclauseDescriptionCheck");
        NAME_TO_FULL_MODULE_NAME.put("SingleLineJavadocCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.SingleLineJavadocCheck");
        NAME_TO_FULL_MODULE_NAME.put("SummaryJavadocCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.SummaryJavadocCheck");
        NAME_TO_FULL_MODULE_NAME.put("WriteTagCheck", "com.puppycrawl.tools.checkstyle.checks.javadoc.WriteTagCheck");
    }

    private static void fillChecksFromMetricsPackage() {
        NAME_TO_FULL_MODULE_NAME.put("BooleanExpressionComplexityCheck", "com.puppycrawl.tools.checkstyle.checks.metrics.BooleanExpressionComplexityCheck");
        NAME_TO_FULL_MODULE_NAME.put("ClassDataAbstractionCouplingCheck", "com.puppycrawl.tools.checkstyle.checks.metrics.ClassDataAbstractionCouplingCheck");
        NAME_TO_FULL_MODULE_NAME.put("ClassFanOutComplexityCheck", "com.puppycrawl.tools.checkstyle.checks.metrics.ClassFanOutComplexityCheck");
        NAME_TO_FULL_MODULE_NAME.put("CyclomaticComplexityCheck", "com.puppycrawl.tools.checkstyle.checks.metrics.CyclomaticComplexityCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavaNCSSCheck", "com.puppycrawl.tools.checkstyle.checks.metrics.JavaNCSSCheck");
        NAME_TO_FULL_MODULE_NAME.put("NPathComplexityCheck", "com.puppycrawl.tools.checkstyle.checks.metrics.NPathComplexityCheck");
    }

    private static void fillChecksFromModifierPackage() {
        NAME_TO_FULL_MODULE_NAME.put("ClassMemberImpliedModifierCheck", "com.puppycrawl.tools.checkstyle.checks.modifier.ClassMemberImpliedModifierCheck");
        NAME_TO_FULL_MODULE_NAME.put("InterfaceMemberImpliedModifierCheck", "com.puppycrawl.tools.checkstyle.checks.modifier.InterfaceMemberImpliedModifierCheck");
        NAME_TO_FULL_MODULE_NAME.put("ModifierOrderCheck", "com.puppycrawl.tools.checkstyle.checks.modifier.ModifierOrderCheck");
        NAME_TO_FULL_MODULE_NAME.put("RedundantModifierCheck", "com.puppycrawl.tools.checkstyle.checks.modifier.RedundantModifierCheck");
    }

    private static void fillChecksFromNamingPackage() {
        NAME_TO_FULL_MODULE_NAME.put("AbbreviationAsWordInNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.AbbreviationAsWordInNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("AbstractClassNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.AbstractClassNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("CatchParameterNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.CatchParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("ClassTypeParameterNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.ClassTypeParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("ConstantNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.ConstantNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("InterfaceTypeParameterNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.InterfaceTypeParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("LambdaParameterNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.LambdaParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("LocalFinalVariableNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.LocalFinalVariableNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("LocalVariableNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.LocalVariableNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("MemberNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.MemberNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("MethodNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.MethodNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("MethodTypeParameterNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.MethodTypeParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("PackageNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.PackageNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("ParameterNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.ParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("StaticVariableNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.StaticVariableNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("TypeNameCheck", "com.puppycrawl.tools.checkstyle.checks.naming.TypeNameCheck");
    }

    private static void fillChecksFromRegexpPackage() {
        NAME_TO_FULL_MODULE_NAME.put("RegexpCheck", "com.puppycrawl.tools.checkstyle.checks.regexp.RegexpCheck");
        NAME_TO_FULL_MODULE_NAME.put("RegexpMultilineCheck", "com.puppycrawl.tools.checkstyle.checks.regexp.RegexpMultilineCheck");
        NAME_TO_FULL_MODULE_NAME.put("RegexpOnFilenameCheck", "com.puppycrawl.tools.checkstyle.checks.regexp.RegexpOnFilenameCheck");
        NAME_TO_FULL_MODULE_NAME.put("RegexpSinglelineCheck", "com.puppycrawl.tools.checkstyle.checks.regexp.RegexpSinglelineCheck");
        NAME_TO_FULL_MODULE_NAME.put("RegexpSinglelineJavaCheck", "com.puppycrawl.tools.checkstyle.checks.regexp.RegexpSinglelineJavaCheck");
    }

    private static void fillChecksFromSizesPackage() {
        NAME_TO_FULL_MODULE_NAME.put("AnonInnerLengthCheck", "com.puppycrawl.tools.checkstyle.checks.sizes.AnonInnerLengthCheck");
        NAME_TO_FULL_MODULE_NAME.put("ExecutableStatementCountCheck", "com.puppycrawl.tools.checkstyle.checks.sizes.ExecutableStatementCountCheck");
        NAME_TO_FULL_MODULE_NAME.put("FileLengthCheck", "com.puppycrawl.tools.checkstyle.checks.sizes.FileLengthCheck");
        NAME_TO_FULL_MODULE_NAME.put("LineLengthCheck", "com.puppycrawl.tools.checkstyle.checks.sizes.LineLengthCheck");
        NAME_TO_FULL_MODULE_NAME.put("MethodCountCheck", "com.puppycrawl.tools.checkstyle.checks.sizes.MethodCountCheck");
        NAME_TO_FULL_MODULE_NAME.put("MethodLengthCheck", "com.puppycrawl.tools.checkstyle.checks.sizes.MethodLengthCheck");
        NAME_TO_FULL_MODULE_NAME.put("OuterTypeNumberCheck", "com.puppycrawl.tools.checkstyle.checks.sizes.OuterTypeNumberCheck");
        NAME_TO_FULL_MODULE_NAME.put("ParameterNumberCheck", "com.puppycrawl.tools.checkstyle.checks.sizes.ParameterNumberCheck");
    }

    private static void fillChecksFromWhitespacePackage() {
        NAME_TO_FULL_MODULE_NAME.put("EmptyForInitializerPadCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.EmptyForInitializerPadCheck");
        NAME_TO_FULL_MODULE_NAME.put("EmptyForIteratorPadCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.EmptyForIteratorPadCheck");
        NAME_TO_FULL_MODULE_NAME.put("EmptyLineSeparatorCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.EmptyLineSeparatorCheck");
        NAME_TO_FULL_MODULE_NAME.put("FileTabCharacterCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.FileTabCharacterCheck");
        NAME_TO_FULL_MODULE_NAME.put("GenericWhitespaceCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.GenericWhitespaceCheck");
        NAME_TO_FULL_MODULE_NAME.put("MethodParamPadCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.MethodParamPadCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoLineWrapCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.NoLineWrapCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoWhitespaceAfterCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.NoWhitespaceAfterCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoWhitespaceBeforeCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.NoWhitespaceBeforeCheck");
        NAME_TO_FULL_MODULE_NAME.put("OperatorWrapCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.OperatorWrapCheck");
        NAME_TO_FULL_MODULE_NAME.put("ParenPadCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.ParenPadCheck");
        NAME_TO_FULL_MODULE_NAME.put("SeparatorWrapCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.SeparatorWrapCheck");
        NAME_TO_FULL_MODULE_NAME.put("SingleSpaceSeparatorCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.SingleSpaceSeparatorCheck");
        NAME_TO_FULL_MODULE_NAME.put("TypecastParenPadCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.TypecastParenPadCheck");
        NAME_TO_FULL_MODULE_NAME.put("WhitespaceAfterCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.WhitespaceAfterCheck");
        NAME_TO_FULL_MODULE_NAME.put("WhitespaceAroundCheck", "com.puppycrawl.tools.checkstyle.checks.whitespace.WhitespaceAroundCheck");
    }

    private static void fillModulesFromChecksPackage() {
        NAME_TO_FULL_MODULE_NAME.put("ArrayTypeStyleCheck", "com.puppycrawl.tools.checkstyle.checks.ArrayTypeStyleCheck");
        NAME_TO_FULL_MODULE_NAME.put("AvoidEscapedUnicodeCharactersCheck", "com.puppycrawl.tools.checkstyle.checks.AvoidEscapedUnicodeCharactersCheck");
        NAME_TO_FULL_MODULE_NAME.put("DescendantTokenCheck", "com.puppycrawl.tools.checkstyle.checks.DescendantTokenCheck");
        NAME_TO_FULL_MODULE_NAME.put("FinalParametersCheck", "com.puppycrawl.tools.checkstyle.checks.FinalParametersCheck");
        NAME_TO_FULL_MODULE_NAME.put("NewlineAtEndOfFileCheck", "com.puppycrawl.tools.checkstyle.checks.NewlineAtEndOfFileCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoCodeInFileCheck", "com.puppycrawl.tools.checkstyle.checks.NoCodeInFileCheck");
        NAME_TO_FULL_MODULE_NAME.put("OuterTypeFilenameCheck", "com.puppycrawl.tools.checkstyle.checks.OuterTypeFilenameCheck");
        NAME_TO_FULL_MODULE_NAME.put("OrderedPropertiesCheck", "com.puppycrawl.tools.checkstyle.checks.OrderedPropertiesCheck");
        NAME_TO_FULL_MODULE_NAME.put("SuppressWarningsHolder", "com.puppycrawl.tools.checkstyle.checks.SuppressWarningsHolder");
        NAME_TO_FULL_MODULE_NAME.put("TodoCommentCheck", "com.puppycrawl.tools.checkstyle.checks.TodoCommentCheck");
        NAME_TO_FULL_MODULE_NAME.put("TrailingCommentCheck", "com.puppycrawl.tools.checkstyle.checks.TrailingCommentCheck");
        NAME_TO_FULL_MODULE_NAME.put("TranslationCheck", "com.puppycrawl.tools.checkstyle.checks.TranslationCheck");
        NAME_TO_FULL_MODULE_NAME.put("UncommentedMainCheck", "com.puppycrawl.tools.checkstyle.checks.UncommentedMainCheck");
        NAME_TO_FULL_MODULE_NAME.put("UniquePropertiesCheck", "com.puppycrawl.tools.checkstyle.checks.UniquePropertiesCheck");
        NAME_TO_FULL_MODULE_NAME.put("UpperEllCheck", "com.puppycrawl.tools.checkstyle.checks.UpperEllCheck");
    }

    private static void fillModulesFromFilefiltersPackage() {
        NAME_TO_FULL_MODULE_NAME.put("BeforeExecutionExclusionFileFilter", "com.puppycrawl.tools.checkstyle.filefilters.BeforeExecutionExclusionFileFilter");
    }

    private static void fillModulesFromFiltersPackage() {
        NAME_TO_FULL_MODULE_NAME.put("SeverityMatchFilter", "com.puppycrawl.tools.checkstyle.filters.SeverityMatchFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressWithPlainTextCommentFilter", "com.puppycrawl.tools.checkstyle.filters.SuppressWithPlainTextCommentFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressionCommentFilter", "com.puppycrawl.tools.checkstyle.filters.SuppressionCommentFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressionFilter", "com.puppycrawl.tools.checkstyle.filters.SuppressionFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressionSingleFilter", "com.puppycrawl.tools.checkstyle.filters.SuppressionSingleFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressionXpathFilter", "com.puppycrawl.tools.checkstyle.filters.SuppressionXpathFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressionXpathSingleFilter", "com.puppycrawl.tools.checkstyle.filters.SuppressionXpathSingleFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressWarningsFilter", "com.puppycrawl.tools.checkstyle.filters.SuppressWarningsFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressWithNearbyCommentFilter", "com.puppycrawl.tools.checkstyle.filters.SuppressWithNearbyCommentFilter");
    }

    private static void fillModulesFromCheckstylePackage() {
        NAME_TO_FULL_MODULE_NAME.put("Checker", "com.puppycrawl.tools.checkstyle.Checker");
        NAME_TO_FULL_MODULE_NAME.put("TreeWalker", "com.puppycrawl.tools.checkstyle.TreeWalker");
    }

    static {
        PackageObjectFactory.fillShortToFullModuleNamesMap();
    }

    public static enum ModuleLoadOption {
        SEARCH_REGISTERED_PACKAGES,
        TRY_IN_ALL_REGISTERED_PACKAGES;

    }
}

