/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.group;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.Pair;
import com.querydsl.core.ResultTransformer;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.AbstractGroupByTest;
import com.querydsl.core.group.GOne;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.group.GroupByProjection;
import com.querydsl.core.group.GroupExpression;
import com.querydsl.core.group.Post;
import com.querydsl.core.group.User;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public class GroupByMapTest
extends AbstractGroupByTest {
    @Test
    public void compile() {
        StringPath str = Expressions.stringPath((String)"str");
        GOne strGroup = new GOne((Expression)str);
        GroupBy.sortedMap((GroupExpression)strGroup, (Expression)str, null);
        GroupBy.sortedMap((Expression)str, (GroupExpression)strGroup, null);
    }

    @Override
    @Test
    public void group_order() {
        Map results = (Map)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.set((Expression)commentId)}));
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void set_by_sorted() {
        Map results = (Map)BASIC_RESULTS_UNORDERED.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.sortedSet((Expression)commentId)}));
        Group group = (Group)results.get(1);
        Iterator it = group.getSet((Expression)commentId).iterator();
        Assert.assertEquals((long)1L, (long)((Integer)it.next()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)it.next()).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)it.next()).intValue());
    }

    @Test
    public void set_by_sorted_reverse() {
        Map results = (Map)BASIC_RESULTS_UNORDERED.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.sortedSet((Expression)commentId, Comparator.reverseOrder())}));
        Group group = (Group)results.get(1);
        Iterator it = group.getSet((Expression)commentId).iterator();
        Assert.assertEquals((long)3L, (long)((Integer)it.next()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)it.next()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)it.next()).intValue());
    }

    @Override
    @Test
    public void first_set_and_list() {
        Map results = (Map)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Group group = (Group)results.get(1);
        Assert.assertEquals((Object)this.toInt(1), (Object)group.getOne((Expression)postId));
        Assert.assertEquals((Object)"post 1", (Object)group.getOne((Expression)postName));
        Assert.assertEquals(this.toSet(1, 2, 3), (Object)group.getSet((Expression)commentId));
        Assert.assertEquals(Arrays.asList("comment 1", "comment 2", "comment 3"), (Object)group.getList((Expression)commentText));
    }

    @Override
    @Test
    public void group_by_null() {
        Map results = (Map)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Group group = (Group)results.get(null);
        Assert.assertNull((Object)group.getOne((Expression)postId));
        Assert.assertEquals((Object)"null post", (Object)group.getOne((Expression)postName));
        Assert.assertEquals(this.toSet(7, 8), (Object)group.getSet((Expression)commentId));
        Assert.assertEquals(Arrays.asList("comment 7", "comment 8"), (Object)group.getList((Expression)commentText));
    }

    @Override
    @Test(expected=NoSuchElementException.class)
    public void noSuchElementException() {
        Map results = (Map)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Group group = (Group)results.get(1);
        group.getSet((Expression)qComment);
    }

    @Override
    @Test(expected=ClassCastException.class)
    public void classCastException() {
        Map results = (Map)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Group group = (Group)results.get(1);
        group.getList((Expression)commentId);
    }

    @Override
    @Test
    public void map1() {
        Map results = (Map)MAP_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.map((Expression)commentId, (Expression)commentText)}));
        Group group = (Group)results.get(1);
        Map comments = group.getMap((Expression)commentId, (Expression)commentText);
        Assert.assertEquals((long)3L, (long)comments.size());
        Assert.assertEquals((Object)"comment 2", comments.get(2));
    }

    @Test
    public void map_sorted() {
        Map results = (Map)MAP_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.sortedMap((Expression)commentId, (Expression)commentText)}));
        Group group = (Group)results.get(1);
        Iterator it = group.getMap((Expression)commentId, (Expression)commentText).entrySet().iterator();
        Assert.assertEquals((long)1L, (long)((Integer)it.next().getKey()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)it.next().getKey()).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)it.next().getKey()).intValue());
    }

    @Test
    public void map_sorted_reverse() {
        Map results = (Map)MAP_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.sortedMap((Expression)commentId, (Expression)commentText, Comparator.reverseOrder())}));
        Group group = (Group)results.get(1);
        Iterator it = group.getMap((Expression)commentId, (Expression)commentText).entrySet().iterator();
        Assert.assertEquals((long)3L, (long)((Integer)it.next().getKey()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)it.next().getKey()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)it.next().getKey()).intValue());
    }

    @Override
    @Test
    public void map2() {
        Map results = (Map)MAP2_RESULTS.transform(GroupBy.groupBy((Expression)postId).as((Expression)GroupBy.map((Expression)commentId, (Expression)commentText)));
        Map comments = (Map)results.get(1);
        Assert.assertEquals((long)3L, (long)comments.size());
        Assert.assertEquals((Object)"comment 2", comments.get(2));
    }

    @Override
    @Test
    public void map3() {
        Map actual = (Map)MAP3_RESULTS.transform(GroupBy.groupBy((Expression)postId).as((Expression)GroupBy.map((Expression)postId, (GroupExpression)GroupBy.map((Expression)commentId, (Expression)commentText))));
        LinkedHashMap expected = new LinkedHashMap();
        CloseableIterator iterator = MAP3_RESULTS.iterate();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            Object[] array = tuple.toArray();
            LinkedHashMap<Integer, Map> posts = (LinkedHashMap<Integer, Map>)expected.get(array[0]);
            if (posts == null) {
                posts = new LinkedHashMap<Integer, Map>();
                expected.put((Integer)array[0], posts);
            }
            Pair pair = (Pair)array[1];
            Integer first = (Integer)pair.getFirst();
            Map comments = posts.computeIfAbsent(first, k -> new LinkedHashMap());
            Pair second = (Pair)pair.getSecond();
            comments.put(second.getFirst(), second.getSecond());
        }
        Assert.assertEquals((Object)((Object)expected).toString(), (Object)actual.toString());
    }

    @Override
    @Test
    public void map4() {
        Map actual = (Map)MAP4_RESULTS.transform(GroupBy.groupBy((Expression)postId).as((Expression)GroupBy.map((GroupExpression)GroupBy.map((Expression)postId, (Expression)commentText), (Expression)postName)));
        LinkedHashMap expected = new LinkedHashMap();
        CloseableIterator iterator = MAP4_RESULTS.iterate();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            Object[] array = tuple.toArray();
            LinkedHashMap<Map<Object, Object>, Object> comments = (LinkedHashMap<Map<Object, Object>, Object>)expected.get(array[0]);
            if (comments == null) {
                comments = new LinkedHashMap<Map<Object, Object>, Object>();
                expected.put((Integer)array[0], comments);
            }
            Pair pair = (Pair)array[1];
            Pair first = (Pair)pair.getFirst();
            Map<Object, Object> posts = Collections.singletonMap(first.getFirst(), first.getSecond());
            comments.put(posts, pair.getSecond());
        }
        Assert.assertEquals((Object)((Object)expected).toString(), (Object)actual.toString());
    }

    @Override
    @Test
    public void array_access() {
        Map results = (Map)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Group group = (Group)results.get(1);
        Object[] array = group.toArray();
        Assert.assertEquals((Object)this.toInt(1), (Object)array[0]);
        Assert.assertEquals((Object)"post 1", (Object)array[1]);
        Assert.assertEquals(this.toSet(1, 2, 3), (Object)array[2]);
        Assert.assertEquals(Arrays.asList("comment 1", "comment 2", "comment 3"), (Object)array[3]);
    }

    @Override
    @Test
    public void transform_results() {
        Map results = (Map)POST_W_COMMENTS.transform(GroupBy.groupBy((Expression)postId).as((FactoryExpression)Projections.constructor(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment)})));
        Post post = (Post)results.get(1);
        Assert.assertNotNull((Object)post);
        Assert.assertEquals((Object)this.toInt(1), (Object)post.getId());
        Assert.assertEquals((Object)"post 1", (Object)post.getName());
        Assert.assertEquals(this.toSet(GroupByMapTest.comment(1), GroupByMapTest.comment(2), GroupByMapTest.comment(3)), post.getComments());
    }

    @Test
    public void transform_via_groupByProjection() {
        Map results = (Map)POST_W_COMMENTS2.transform(new GroupByProjection<Integer, Post>((Expression)postId, new Expression[]{postName, GroupBy.set((Expression)qComment)}){

            protected Post transform(Group group) {
                return new Post((Integer)group.getOne(AbstractGroupByTest.postId), (String)group.getOne((Expression)AbstractGroupByTest.postName), group.getSet(AbstractGroupByTest.qComment));
            }
        });
        Post post = (Post)results.get(1);
        Assert.assertNotNull((Object)post);
        Assert.assertEquals((Object)this.toInt(1), (Object)post.getId());
        Assert.assertEquals((Object)"post 1", (Object)post.getName());
        Assert.assertEquals(this.toSet(GroupByMapTest.comment(1), GroupByMapTest.comment(2), GroupByMapTest.comment(3)), post.getComments());
    }

    @Override
    @Test
    public void transform_as_bean() {
        Map results = (Map)POST_W_COMMENTS.transform(GroupBy.groupBy((Expression)postId).as((FactoryExpression)Projections.bean(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment).as("comments")})));
        Post post = (Post)results.get(1);
        Assert.assertNotNull((Object)post);
        Assert.assertEquals((Object)this.toInt(1), (Object)post.getId());
        Assert.assertEquals((Object)"post 1", (Object)post.getName());
        Assert.assertEquals(this.toSet(GroupByMapTest.comment(1), GroupByMapTest.comment(2), GroupByMapTest.comment(3)), post.getComments());
    }

    @Override
    @Test
    public void oneToOneToMany_projection() {
        Map results = (Map)USERS_W_LATEST_POST_AND_COMMENTS.transform(GroupBy.groupBy((Expression)userName).as((FactoryExpression)Projections.constructor(User.class, (Expression[])new Expression[]{userName, Projections.constructor(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment)})})));
        Assert.assertEquals((long)2L, (long)results.size());
        User user = (User)results.get("Jane");
        Post post = user.getLatestPost();
        Assert.assertEquals((Object)this.toInt(2), (Object)post.getId());
        Assert.assertEquals((Object)"post 2", (Object)post.getName());
        Assert.assertEquals(this.toSet(GroupByMapTest.comment(4), GroupByMapTest.comment(5)), post.getComments());
    }

    @Override
    @Test
    public void oneToOneToMany_projection_as_bean() {
        Map results = (Map)USERS_W_LATEST_POST_AND_COMMENTS.transform(GroupBy.groupBy((Expression)userName).as((FactoryExpression)Projections.bean(User.class, (Expression[])new Expression[]{userName, Projections.bean(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment).as("comments")}).as("latestPost")})));
        Assert.assertEquals((long)2L, (long)results.size());
        User user = (User)results.get("Jane");
        Post post = user.getLatestPost();
        Assert.assertEquals((Object)this.toInt(2), (Object)post.getId());
        Assert.assertEquals((Object)"post 2", (Object)post.getName());
        Assert.assertEquals(this.toSet(GroupByMapTest.comment(4), GroupByMapTest.comment(5)), post.getComments());
    }

    @Override
    @Test
    public void oneToOneToMany_projection_as_bean_and_constructor() {
        Map results = (Map)USERS_W_LATEST_POST_AND_COMMENTS.transform(GroupBy.groupBy((Expression)userName).as((FactoryExpression)Projections.bean(User.class, (Expression[])new Expression[]{userName, Projections.constructor(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment)}).as("latestPost")})));
        Assert.assertEquals((long)2L, (long)results.size());
        User user = (User)results.get("Jane");
        Post post = user.getLatestPost();
        Assert.assertEquals((Object)this.toInt(2), (Object)post.getId());
        Assert.assertEquals((Object)"post 2", (Object)post.getName());
        Assert.assertEquals(this.toSet(GroupByMapTest.comment(4), GroupByMapTest.comment(5)), post.getComments());
    }

    @Test
    public void signature() {
        StringPath str = Expressions.stringPath((String)"str");
        NumberPath bigd = Expressions.numberPath(BigDecimal.class, (String)"bigd");
        ResultTransformer resultTransformer = GroupBy.groupBy((Expression)str).as((Expression)GroupBy.sortedMap((Expression)bigd, (GroupExpression)GroupBy.sortedMap((Expression)bigd, (GroupExpression)GroupBy.map((Expression)str, (Expression)str), Comparator.nullsLast(Comparator.naturalOrder())), Comparator.nullsFirst(Comparator.naturalOrder())));
        Assert.assertNotNull((Object)resultTransformer);
    }

    @Test
    public void average_with_default_math_context() {
        Map results = (Map)POSTS_W_COMMENTS_SCORE.transform(GroupBy.groupBy((Expression)postId).as((Expression)GroupBy.avg((Expression)score)));
        Assert.assertEquals((double)1.5, (double)((Double)results.get(null)), (double)0.0);
        Assert.assertEquals((double)1.3333333333333333, (double)((Double)results.get(1)), (double)0.0);
        Assert.assertEquals((double)1.5, (double)((Double)results.get(2)), (double)0.0);
    }

    @Test
    public void average_with_user_provided_math_context() {
        MathContext oneDigitMathContext = new MathContext(2, RoundingMode.HALF_EVEN);
        Map results = (Map)POSTS_W_COMMENTS_SCORE.transform(GroupBy.groupBy((Expression)postId).as((Expression)GroupBy.avg((Expression)score, (MathContext)oneDigitMathContext)));
        Assert.assertEquals((double)1.5, (double)((Double)results.get(null)), (double)0.0);
        Assert.assertEquals((double)1.3, (double)((Double)results.get(1)), (double)0.0);
        Assert.assertEquals((double)1.5, (double)((Double)results.get(2)), (double)0.0);
    }
}

