/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.NumberConstant;
import com.querydsl.core.QuerydslModule;
import com.querydsl.core.StringConstant;
import com.querydsl.core.Target;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MapExpression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.ArrayExpression;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.CollectionExpressionBase;
import com.querydsl.core.types.dsl.DateExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.ListExpression;
import com.querydsl.core.types.dsl.ListPath;
import com.querydsl.core.types.dsl.MapExpressionBase;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.TimeExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class ProjectionsFactory {
    private final QuerydslModule module;
    private final Target target;

    public ProjectionsFactory(QuerydslModule module, Target target) {
        this.module = module;
        this.target = target;
    }

    public <A> Collection<Expression<?>> array(ArrayExpression<A[], A> expr, ArrayExpression<A[], A> other, A knownElement) {
        HashSet<NumberExpression> rv = new HashSet<NumberExpression>();
        if (!this.module.equals((Object)QuerydslModule.RDFBEAN)) {
            rv.add(expr.size());
        }
        return Collections.unmodifiableSet(rv);
    }

    public <A> Collection<Expression<?>> collection(CollectionExpressionBase<?, A> expr, CollectionExpression<?, A> other, A knownElement) {
        HashSet<NumberExpression> rv = new HashSet<NumberExpression>();
        if (!this.module.equals((Object)QuerydslModule.RDFBEAN)) {
            rv.add(expr.size());
        }
        return Collections.unmodifiableSet(rv);
    }

    public <A extends Comparable> Collection<Expression<?>> date(DateExpression<A> expr, DateExpression<A> other, A knownValue) {
        HashSet<Object> rv = new HashSet<Object>();
        rv.add(expr.dayOfMonth());
        rv.add(expr.month());
        rv.add(expr.year());
        rv.add(expr.yearMonth());
        if (this.module != QuerydslModule.COLLECTIONS && this.module != QuerydslModule.RDFBEAN) {
            rv.add(expr.min());
            rv.add(expr.max());
        }
        return Collections.unmodifiableSet(rv);
    }

    public <A extends Comparable> Collection<Expression<?>> dateTime(DateTimeExpression<A> expr, DateTimeExpression<A> other, A knownValue) {
        HashSet<Object> rv = new HashSet<Object>();
        rv.add(expr.dayOfMonth());
        rv.add(expr.month());
        rv.add(expr.year());
        rv.add(expr.yearMonth());
        rv.add(expr.hour());
        rv.add(expr.minute());
        rv.add(expr.second());
        if (this.module != QuerydslModule.COLLECTIONS && this.module != QuerydslModule.RDFBEAN) {
            rv.add(expr.min());
            rv.add(expr.max());
        }
        return Collections.unmodifiableSet(rv);
    }

    public <A, Q extends SimpleExpression<A>> Collection<Expression<?>> list(ListPath<A, Q> expr, ListExpression<A, Q> other, A knownElement) {
        HashSet<Object> rv = new HashSet<Object>();
        rv.add(expr.get(0));
        if (!this.module.equals((Object)QuerydslModule.RDFBEAN)) {
            rv.add(expr.size());
        }
        return Collections.unmodifiableSet(rv);
    }

    public <K, V> Collection<Expression<?>> map(MapExpressionBase<K, V, ?> expr, MapExpression<K, V> other, K knownKey, V knownValue) {
        HashSet<Object> rv = new HashSet<Object>();
        rv.add(expr.get(knownKey));
        if (!this.module.equals((Object)QuerydslModule.RDFBEAN)) {
            rv.add(expr.size());
        }
        return Collections.unmodifiableSet(rv);
    }

    public <A extends Number> Collection<NumberExpression<?>> numeric(NumberExpression<A> expr, NumberExpression<A> other, A knownValue, boolean forFilter) {
        HashSet<NumberExpression<A>> rv = new HashSet<NumberExpression<A>>();
        rv.addAll(this.numeric(expr, other, forFilter));
        rv.addAll(this.numeric(expr, NumberConstant.create(knownValue), forFilter));
        return Collections.unmodifiableSet(rv);
    }

    private <A extends Number> Collection<NumberExpression<?>> numeric(NumberExpression<A> expr, NumberExpression<?> other, boolean forFilter) {
        HashSet<NumberExpression> rv = new HashSet<NumberExpression>();
        rv.add(expr.abs());
        rv.add(expr.add(other));
        rv.add(expr.divide(other));
        if (this.target != Target.HSQLDB) {
            rv.add(expr.negate());
        }
        rv.add(expr.multiply(other));
        rv.add(expr.sqrt());
        rv.add(expr.subtract(other));
        if (!forFilter && this.module != QuerydslModule.COLLECTIONS && this.module != QuerydslModule.RDFBEAN) {
            rv.add(expr.min());
            rv.add(expr.max());
            rv.add(expr.avg());
            rv.add(expr.count());
            rv.add(expr.countDistinct());
        }
        if (!(other instanceof Constant) && this.module != QuerydslModule.JDO && this.module != QuerydslModule.RDFBEAN) {
            CaseBuilder cases = new CaseBuilder();
            rv.add(NumberConstant.create(1).add(cases.when((Predicate)expr.gt((Number)10)).then(expr).when((Predicate)expr.between((Number)0, (Number)10)).then(other).otherwise(other)));
            rv.add((NumberExpression)expr.when(other).then(expr).otherwise(other));
        }
        return Collections.unmodifiableSet(rv);
    }

    public <A extends Number> Collection<NumberExpression<?>> numericCasts(NumberExpression<A> expr, NumberExpression<A> other, A knownValue) {
        if (!this.target.equals((Object)Target.MYSQL)) {
            HashSet<NumberExpression> rv = new HashSet<NumberExpression>();
            rv.add(expr.byteValue());
            rv.add(expr.doubleValue());
            rv.add(expr.floatValue());
            rv.add(expr.intValue());
            rv.add(expr.longValue());
            rv.add(expr.shortValue());
            return Collections.unmodifiableSet(rv);
        }
        return Collections.emptySet();
    }

    public Collection<SimpleExpression<String>> string(StringExpression expr, StringExpression other, String knownValue) {
        HashSet<SimpleExpression<String>> rv = new HashSet<SimpleExpression<String>>();
        rv.addAll(this.stringProjections(expr, other));
        rv.addAll(this.stringProjections(expr, StringConstant.create(knownValue)));
        return rv;
    }

    public Collection<SimpleExpression<String>> stringProjections(StringExpression expr, StringExpression other) {
        HashSet<Object> rv = new HashSet<Object>();
        rv.add(expr.append("Hello"));
        rv.add(expr.append((Expression)other));
        rv.add(expr.concat((Expression)other));
        rv.add(expr.concat("Hello"));
        rv.add(expr.lower());
        rv.add(expr.prepend("Hello"));
        rv.add(expr.prepend((Expression)other));
        rv.add(expr.stringValue());
        rv.add(expr.substring(1));
        rv.add(expr.substring(0, 1));
        if (!(other instanceof Constant) && this.module != QuerydslModule.JDO && this.module != QuerydslModule.RDFBEAN) {
            CaseBuilder cases = new CaseBuilder();
            rv.add((SimpleExpression)cases.when((Predicate)expr.eq((Object)"A")).then(other).when((Predicate)expr.eq((Object)"B")).then((Expression)expr).otherwise((Expression)other));
            rv.add((SimpleExpression)expr.when((Object)"A").then(other).when((Object)"B").then((Expression)expr).otherwise((Expression)other));
        }
        rv.add(expr.trim());
        rv.add(expr.upper());
        if (this.module != QuerydslModule.JDO) {
            rv.add(expr.nullif("xxx"));
        }
        return Collections.unmodifiableSet(rv);
    }

    public <A extends Comparable> Collection<Expression<?>> time(TimeExpression<A> expr, TimeExpression<A> other, A knownValue) {
        HashSet<NumberExpression> rv = new HashSet<NumberExpression>();
        rv.add(expr.hour());
        rv.add(expr.minute());
        rv.add(expr.second());
        return Collections.unmodifiableSet(rv);
    }
}

