/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.hibernate.search;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.querydsl.core.Fetchable;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.SimpleQuery;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Predicate;
import com.querydsl.hibernate.search.SearchSerializer;
import com.querydsl.lucene5.LuceneSerializer;
import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;

public abstract class AbstractSearchQuery<T, Q extends AbstractSearchQuery<T, Q>>
implements SimpleQuery<Q>,
Fetchable<T> {
    private final EntityPath<T> path;
    private final QueryMixin<Q> queryMixin = new QueryMixin((Object)this);
    private final LuceneSerializer serializer;
    private final FullTextSession session;

    public AbstractSearchQuery(FullTextSession session, EntityPath<T> path) {
        this.session = session;
        this.path = path;
        this.serializer = SearchSerializer.DEFAULT;
        this.queryMixin.from(path);
    }

    public AbstractSearchQuery(Session session, EntityPath<T> path) {
        this(Search.getFullTextSession((Session)session), path);
    }

    public long fetchCount() {
        return this.createQuery(true).getResultSize();
    }

    private FullTextQuery createQuery(boolean forCount) {
        QueryModifiers modifiers;
        QueryMetadata metadata = this.queryMixin.getMetadata();
        Object query = metadata.getWhere() != null ? this.serializer.toQuery((Expression)metadata.getWhere(), metadata) : new MatchAllDocsQuery();
        FullTextQuery fullTextQuery = this.session.createFullTextQuery((Query)query, new Class[]{this.path.getType()});
        if (!metadata.getOrderBy().isEmpty() && !forCount) {
            fullTextQuery.setSort(this.serializer.toSort(metadata.getOrderBy()));
        }
        if ((modifiers = metadata.getModifiers()).isRestricting() && !forCount) {
            Integer limit = modifiers.getLimitAsInteger();
            Integer offset = modifiers.getOffsetAsInteger();
            if (limit != null) {
                fullTextQuery.setMaxResults(limit.intValue());
            }
            if (offset != null) {
                fullTextQuery.setFirstResult(offset.intValue());
            }
        }
        return fullTextQuery;
    }

    public Q distinct() {
        return (Q)((AbstractSearchQuery)this.queryMixin.distinct());
    }

    public CloseableIterator<T> iterate() {
        return new IteratorAdapter(this.createQuery(false).iterate());
    }

    public Q limit(long limit) {
        return (Q)((AbstractSearchQuery)this.queryMixin.limit(limit));
    }

    public List<T> fetch() {
        return this.createQuery(false).list();
    }

    public QueryResults<T> fetchResults() {
        FullTextQuery query = this.createQuery(false);
        return new QueryResults(query.list(), this.queryMixin.getMetadata().getModifiers(), (long)query.getResultSize());
    }

    public Q offset(long offset) {
        return (Q)((AbstractSearchQuery)this.queryMixin.offset(offset));
    }

    public Q orderBy(OrderSpecifier<?> ... o) {
        return (Q)((AbstractSearchQuery)this.queryMixin.orderBy(o));
    }

    public Q restrict(QueryModifiers modifiers) {
        return (Q)((AbstractSearchQuery)this.queryMixin.restrict(modifiers));
    }

    public <P> Q set(ParamExpression<P> param, P value) {
        return (Q)((AbstractSearchQuery)this.queryMixin.set(param, value));
    }

    public T fetchFirst() {
        return this.limit(1L).fetchOne();
    }

    public T fetchOne() throws NonUniqueResultException {
        try {
            return (T)this.createQuery(false).uniqueResult();
        }
        catch (org.hibernate.NonUniqueResultException e) {
            throw new NonUniqueResultException((Exception)((Object)e));
        }
    }

    public Q where(Predicate ... e) {
        return (Q)((AbstractSearchQuery)this.queryMixin.where(e));
    }
}

