/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jdo;

import com.querydsl.core.JoinExpression;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.SerializerBase;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.ParamNotSetException;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.dsl.Param;
import com.querydsl.core.util.PrimitiveUtils;
import com.querydsl.jdo.JDOQLTemplates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public final class JDOQLSerializer
extends SerializerBase<JDOQLSerializer> {
    private static final String COMMA = ", ";
    private static final String FROM = "\nFROM ";
    private static final String GROUP_BY = "\nGROUP BY ";
    private static final String HAVING = "\nHAVING ";
    private static final String ORDER_BY = "\nORDER BY ";
    private static final String PARAMETERS = "\nPARAMETERS ";
    private static final String RANGE = "\nRANGE ";
    private static final String SELECT = "SELECT ";
    private static final String SELECT_COUNT = "SELECT count(";
    private static final String SELECT_COUNT_THIS = "SELECT count(this)\n";
    private static final String SELECT_DISTINCT = "SELECT DISTINCT ";
    private static final String SELECT_UNIQUE = "SELECT UNIQUE ";
    private static final String THIS = "this";
    private static final String VARIABLES = "\nVARIABLES ";
    private static final String WHERE = "\nWHERE ";
    private static Comparator<Map.Entry<Object, String>> comparator = new Comparator<Map.Entry<Object, String>>(){

        @Override
        public int compare(Map.Entry<Object, String> o1, Map.Entry<Object, String> o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    };
    private final Expression<?> candidatePath;
    private final List<Object> constants = new ArrayList<Object>();
    private final Stack<Map<Object, String>> constantToLabel = new Stack();

    public JDOQLSerializer(JDOQLTemplates templates, Expression<?> candidate) {
        super((Templates)templates);
        this.candidatePath = candidate;
        this.constantToLabel.push(new LinkedHashMap());
    }

    public Expression<?> getCandidatePath() {
        return this.candidatePath;
    }

    public List<Object> getConstants() {
        return this.constants;
    }

    public Map<Object, String> getConstantToLabel() {
        return this.constantToLabel.peek();
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow, boolean subQuery) {
        Expression select = metadata.getProjection();
        List joins = metadata.getJoins();
        Expression source = ((JoinExpression)joins.get(0)).getTarget();
        Predicate where = metadata.getWhere();
        List groupBy = metadata.getGroupBy();
        Predicate having = metadata.getHaving();
        List orderBy = metadata.getOrderBy();
        this.constantToLabel.push(new LinkedHashMap());
        boolean skippedSelect = false;
        if (forCountRow) {
            if (joins.size() == 1 && !subQuery) {
                this.append(SELECT_COUNT_THIS);
            } else {
                this.append(SELECT_COUNT);
                this.handle(source);
                this.append(")");
            }
        } else if (select != null) {
            if (metadata.isDistinct()) {
                this.append(SELECT_DISTINCT);
            } else if (metadata.isUnique() && !subQuery) {
                this.append(SELECT_UNIQUE);
            } else {
                this.append(SELECT);
            }
            if (!select.equals(source) || metadata.isDistinct()) {
                this.handle(select);
            } else {
                skippedSelect = true;
            }
        }
        this.append(skippedSelect ? FROM.substring(1) : FROM);
        if (source instanceof Operation && subQuery) {
            this.handle(source);
        } else {
            this.append(source.getType().getName());
            if (!source.equals(this.candidatePath)) {
                ((JDOQLSerializer)this.append(" ")).handle(source);
            }
        }
        if (where != null) {
            ((JDOQLSerializer)this.append(WHERE)).handle((Expression)where);
        }
        if (joins.size() > 1) {
            this.serializeVariables(joins);
        }
        int position = this.getLength();
        if (!groupBy.isEmpty()) {
            ((JDOQLSerializer)this.append(GROUP_BY)).handle(COMMA, groupBy);
        }
        if (having != null) {
            ((JDOQLSerializer)this.append(HAVING)).handle((Expression)having);
        }
        if (!orderBy.isEmpty() && !forCountRow) {
            this.append(ORDER_BY);
            boolean first = true;
            for (OrderSpecifier os : orderBy) {
                if (!first) {
                    this.append(COMMA);
                }
                this.handle(os.getTarget());
                this.append(" " + os.getOrder());
                first = false;
            }
        }
        if (!forCountRow && metadata.getModifiers().isRestricting()) {
            Long limit = metadata.getModifiers().getLimit();
            Long offset = metadata.getModifiers().getOffset();
            this.serializeModifiers(limit, offset);
        }
        if (!this.getConstantToLabel().isEmpty()) {
            this.insert(position, this.serializeParameters(metadata.getParams()));
        }
        this.constantToLabel.pop();
    }

    private void serializeModifiers(@Nullable Long limit, @Nullable Long offset) {
        this.append(RANGE);
        if (offset != null) {
            this.append(String.valueOf(offset));
            if (limit != null) {
                this.append(COMMA);
                this.append(String.valueOf(offset + limit));
            }
        } else {
            ((JDOQLSerializer)this.append("0, ")).append(String.valueOf(limit));
        }
    }

    private String serializeParameters(Map<ParamExpression<?>, Object> params) {
        StringBuilder b = new StringBuilder();
        b.append(PARAMETERS);
        boolean first = true;
        Set<Map.Entry<Object, String>> entries = this.getConstantToLabel().entrySet();
        for (Map.Entry entry : entries) {
            if (!first) {
                b.append(COMMA);
            }
            if (entry.getKey() instanceof Param) {
                Object constant = params.get(entry.getKey());
                if (constant == null) {
                    throw new ParamNotSetException((ParamExpression)((Param)entry.getKey()));
                }
                this.constants.add(constant);
                b.append(((Param)entry.getKey()).getType().getName());
            } else {
                this.constants.add(entry.getKey());
                b.append(entry.getKey().getClass().getName());
            }
            b.append(" ").append((String)entry.getValue());
            first = false;
        }
        return b.toString();
    }

    private void serializeVariables(List<JoinExpression> joins) {
        this.append(VARIABLES);
        for (int i = 1; i < joins.size(); ++i) {
            EntityPath pe;
            JoinExpression je = joins.get(i);
            if (i > 1) {
                this.append("; ");
            }
            if (je.getTarget() instanceof EntityPath && (pe = (EntityPath)je.getTarget()).getMetadata().getParent() == null) {
                ((JDOQLSerializer)this.append(pe.getType().getName())).append(" ");
            }
            this.handle(je.getTarget());
        }
    }

    public Void visit(Path<?> path, Void context) {
        if (path.equals(this.candidatePath)) {
            this.append(THIS);
        } else {
            super.visit(path, context);
        }
        return null;
    }

    public Void visit(SubQueryExpression<?> query, Void context) {
        this.append("(");
        this.serialize(query.getMetadata(), false, true);
        this.append(")");
        return null;
    }

    protected void visitOperation(Class<?> type, Operator operator, List<? extends Expression<?>> args) {
        if (operator == Ops.INSTANCE_OF) {
            ((JDOQLSerializer)this.handle(args.get(0))).append(" instanceof ");
            Constant rightArg = (Constant)args.get(1);
            this.append(((Class)rightArg.getConstant()).getName());
        } else if (operator == Ops.LIKE || operator == Ops.LIKE_ESCAPE || operator == Ops.LIKE_IC || operator == Ops.LIKE_ESCAPE_IC) {
            Expression string = args.get(0);
            Expression regex = ExpressionUtils.likeToRegex(args.get(1), (boolean)false);
            if (operator == Ops.LIKE_IC || operator == Ops.LIKE_ESCAPE_IC) {
                string = ExpressionUtils.toLower(string);
                regex = ExpressionUtils.toLower((Expression)regex);
            }
            super.visitOperation(type, (Operator)Ops.MATCHES, Arrays.asList(string, regex));
        } else if (operator == Ops.EXISTS && args.get(0) instanceof SubQueryExpression) {
            SubQueryExpression subQuery = (SubQueryExpression)args.get(0);
            this.append("(");
            this.serialize(subQuery.getMetadata(), true, true);
            this.append(") > 0");
        } else if (operator == Ops.NOT && args.get(0) instanceof Operation && ((Operation)args.get(0)).getOperator().equals(Ops.EXISTS)) {
            SubQueryExpression subQuery = (SubQueryExpression)((Operation)args.get(0)).getArg(0);
            this.append("(");
            this.serialize(subQuery.getMetadata(), true, true);
            this.append(") == 0");
        } else if (operator == Ops.NUMCAST) {
            Constant rightArg = (Constant)args.get(1);
            Class clazz = (Class)rightArg.getConstant();
            if (Number.class.isAssignableFrom(clazz) && PrimitiveUtils.isWrapperType((Class)clazz)) {
                clazz = PrimitiveUtils.unwrap((Class)clazz);
            }
            ((JDOQLSerializer)this.append("(" + clazz.getSimpleName() + ")")).handle(args.get(0));
        } else if (operator == Ops.ALIAS) {
            if (args.get(1) instanceof Path && !((Path)args.get(1)).getMetadata().isRoot()) {
                Path path = (Path)args.get(1);
                args = Arrays.asList(args.get(0), ExpressionUtils.path((Class)path.getType(), (String)path.getMetadata().getName()));
            }
            super.visitOperation(type, operator, args);
        } else {
            super.visitOperation(type, operator, args);
        }
    }
}

