/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jdo;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.QueryException;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.support.FetchableSubQueryBase;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Path;
import com.querydsl.jdo.JDOQLQuery;
import com.querydsl.jdo.JDOQLSerializer;
import com.querydsl.jdo.JDOQLTemplates;
import com.querydsl.jdo.JDOQuery;
import com.querydsl.jdo.JDOQueryMixin;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJDOQuery<T, Q extends AbstractJDOQuery<T, Q>>
extends FetchableSubQueryBase<T, Q>
implements JDOQLQuery<T> {
    private static final Logger logger = Logger.getLogger(JDOQuery.class.getName());
    private final Closeable closeable = new Closeable(){

        @Override
        public void close() throws IOException {
            AbstractJDOQuery.this.close();
        }
    };
    private final boolean detach;
    private List<Object> orderedConstants = new ArrayList<Object>();
    @Nullable
    private final PersistenceManager persistenceManager;
    private final List<Query> queries = new ArrayList<Query>(2);
    private final JDOQLTemplates templates;
    protected final Set<String> fetchGroups = new HashSet<String>();
    @Nullable
    protected Integer maxFetchDepth;
    @Nullable
    private FactoryExpression<?> projection;

    public AbstractJDOQuery(@Nullable PersistenceManager persistenceManager) {
        this(persistenceManager, JDOQLTemplates.DEFAULT, (QueryMetadata)new DefaultQueryMetadata(), false);
    }

    public AbstractJDOQuery(@Nullable PersistenceManager persistenceManager, JDOQLTemplates templates, QueryMetadata metadata, boolean detach) {
        super(new JDOQueryMixin(metadata));
        this.queryMixin.setSelf((Object)this);
        this.templates = templates;
        this.persistenceManager = persistenceManager;
        this.detach = detach;
    }

    public Q addFetchGroup(String fetchGroupName) {
        this.fetchGroups.add(fetchGroupName);
        return (Q)((AbstractJDOQuery)this.queryMixin.getSelf());
    }

    @Override
    public void close() {
        for (Query query : this.queries) {
            query.closeAll();
        }
    }

    public long fetchCount() {
        try {
            Query query = this.createQuery(true);
            query.setUnique(true);
            Long rv = (Long)this.execute(query, true);
            if (rv != null) {
                long l = rv;
                return l;
            }
            throw new QueryException("Query returned null");
        }
        finally {
            this.reset();
        }
    }

    private Expression<?> getSource() {
        return ((JoinExpression)this.queryMixin.getMetadata().getJoins().get(0)).getTarget();
    }

    private Query createQuery(boolean forCount) {
        Expression<?> source = this.getSource();
        JDOQLSerializer serializer = new JDOQLSerializer(this.getTemplates(), source);
        serializer.serialize(this.queryMixin.getMetadata(), forCount, false);
        this.logQuery(serializer.toString(), serializer.getConstantToLabel());
        Query query = this.persistenceManager.newQuery(serializer.toString());
        this.orderedConstants = serializer.getConstants();
        this.queries.add(query);
        if (!forCount) {
            Expression projection = this.queryMixin.getMetadata().getProjection();
            if (projection instanceof FactoryExpression) {
                this.projection = (FactoryExpression)projection;
            }
            if (!this.fetchGroups.isEmpty()) {
                query.getFetchPlan().setGroups(this.fetchGroups);
            }
            if (this.maxFetchDepth != null) {
                query.getFetchPlan().setMaxFetchDepth(this.maxFetchDepth.intValue());
            }
        }
        return query;
    }

    protected void logQuery(String queryString, Map<Object, String> parameters) {
        if (logger.isLoggable(Level.FINE)) {
            String normalizedQuery = queryString.replace('\n', ' ');
            logger.fine(normalizedQuery);
        }
    }

    private <T> T detach(T results) {
        if (results instanceof Collection) {
            return (T)this.persistenceManager.detachCopyAll((Collection)results);
        }
        return (T)this.persistenceManager.detachCopy(results);
    }

    private Object project(FactoryExpression<?> expr, Object row) {
        if (row == null) {
            return null;
        }
        if (row.getClass().isArray()) {
            return expr.newInstance((Object[])row);
        }
        return expr.newInstance(new Object[]{row});
    }

    @Nullable
    private Object execute(Query query, boolean forCount) {
        Object rv = !this.orderedConstants.isEmpty() ? query.executeWithArray(this.orderedConstants.toArray()) : query.execute();
        if (this.isDetach()) {
            rv = this.detach(rv);
        }
        if (this.projection != null && !forCount) {
            if (rv instanceof List) {
                List original = (List)rv;
                rv = new ArrayList();
                for (Object o : original) {
                    ((List)rv).add(this.project(this.projection, o));
                }
            } else {
                rv = this.project(this.projection, rv);
            }
        }
        return rv;
    }

    public Q from(EntityPath<?> ... args) {
        return (Q)((AbstractJDOQuery)this.queryMixin.from(args));
    }

    public <U> Q from(CollectionExpression<?, U> path, Path<U> alias) {
        return (Q)((AbstractJDOQuery)this.queryMixin.from(ExpressionUtils.as((Expression)((Path)path), alias)));
    }

    public JDOQLTemplates getTemplates() {
        return this.templates;
    }

    public boolean isDetach() {
        return this.detach;
    }

    public CloseableIterator<T> iterate() {
        return new IteratorAdapter(this.fetch().iterator(), this.closeable);
    }

    public Stream<T> stream() {
        return (Stream)this.fetch().stream().onClose(this::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> fetch() {
        try {
            List<Object> result;
            Object rv = this.execute(this.createQuery(false), false);
            List<Object> list = result = rv instanceof List ? (List<Object>)rv : Collections.singletonList(rv);
            return list;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResults<T> fetchResults() {
        try {
            Query countQuery = this.createQuery(true);
            countQuery.setUnique(true);
            countQuery.setResult("count(this)");
            long total = (Long)this.execute(countQuery, true);
            if (total > 0L) {
                QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
                Query query = this.createQuery(false);
                QueryResults queryResults = new QueryResults((List)this.execute(query, false), modifiers, total);
                return queryResults;
            }
            QueryResults queryResults = QueryResults.emptyResults();
            return queryResults;
        }
        finally {
            this.reset();
        }
    }

    private void reset() {
    }

    public Q setMaxFetchDepth(int depth) {
        this.maxFetchDepth = depth;
        return (Q)((AbstractJDOQuery)this.queryMixin.getSelf());
    }

    public String toString() {
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            Expression<?> source = this.getSource();
            JDOQLSerializer serializer = new JDOQLSerializer(this.getTemplates(), source);
            serializer.serialize(this.queryMixin.getMetadata(), false, false);
            return serializer.toString().trim();
        }
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T fetchOne() throws NonUniqueResultException {
        if (this.getMetadata().getModifiers().getLimit() == null) {
            this.limit(2L);
        }
        try {
            Object result;
            Query query = this.createQuery(false);
            Object rv = this.execute(query, false);
            if (rv instanceof List) {
                List list = (List)rv;
                if (!list.isEmpty()) {
                    if (list.size() > 1) {
                        throw new NonUniqueResultException();
                    }
                    Object e = list.get(0);
                    return (T)e;
                }
                T t = null;
                return t;
            }
            Object object = result = rv;
            return (T)object;
        }
        finally {
            this.reset();
        }
    }
}

