/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.LongString;
import com.rabbitmq.client.impl.MethodArgumentReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentHeaderPropertyReader {
    private final DataInputStream in;
    public int flagWord;
    public int bitCount;

    public ContentHeaderPropertyReader(DataInputStream in) throws IOException {
        this.in = in;
        this.flagWord = 1;
        this.bitCount = 15;
    }

    public boolean isContinuationBitSet() {
        return (this.flagWord & 1) != 0;
    }

    public void readFlagWord() throws IOException {
        if (!this.isContinuationBitSet()) {
            throw new IOException("Attempted to read flag word when none advertised");
        }
        this.flagWord = this.in.readShort();
        this.bitCount = 0;
    }

    public boolean readPresence() throws IOException {
        if (this.bitCount == 15) {
            this.readFlagWord();
        }
        int bit = 15 - this.bitCount;
        ++this.bitCount;
        return (this.flagWord & 1 << bit) != 0;
    }

    public void finishPresence() throws IOException {
        if (this.isContinuationBitSet()) {
            throw new IOException("Unexpected continuation flag word");
        }
    }

    public String readShortstr() throws IOException {
        return MethodArgumentReader.readShortstr(this.in);
    }

    public LongString readLongstr() throws IOException {
        return MethodArgumentReader.readLongstr(this.in);
    }

    public Integer readShort() throws IOException {
        return new Integer(this.in.readUnsignedShort());
    }

    public Integer readLong() throws IOException {
        return this.in.readInt();
    }

    public Long readLonglong() throws IOException {
        return new Long(this.in.readLong());
    }

    public Map<String, Object> readTable() throws IOException {
        return MethodArgumentReader.readTable(this.in);
    }

    public Integer readOctet() throws IOException {
        return this.in.readUnsignedByte();
    }

    public Date readTimestamp() throws IOException {
        return MethodArgumentReader.readTimestamp(this.in);
    }
}

