/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.LongString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodArgumentWriter {
    private final DataOutputStream out;
    private boolean needBitFlush;
    private byte bitAccumulator;
    private int bitMask;

    public MethodArgumentWriter(DataOutputStream out) {
        this.out = out;
        this.resetBitAccumulator();
    }

    private void resetBitAccumulator() {
        this.needBitFlush = false;
        this.bitAccumulator = 0;
        this.bitMask = 1;
    }

    private final void bitflush() throws IOException {
        if (this.needBitFlush) {
            this.out.writeByte(this.bitAccumulator);
            this.resetBitAccumulator();
        }
    }

    public final void writeShortstr(String str) throws IOException {
        this.bitflush();
        byte[] bytes = str.getBytes("utf-8");
        this.out.writeByte(bytes.length);
        this.out.write(bytes);
    }

    public final void writeLongstr(LongString str) throws IOException {
        this.bitflush();
        this.writeLong((int)str.length());
        IOUtils.copy((InputStream)str.getStream(), (OutputStream)this.out);
    }

    public final void writeLongstr(String str) throws IOException {
        this.bitflush();
        byte[] bytes = str.getBytes("utf-8");
        this.writeLong(bytes.length);
        this.out.write(bytes);
    }

    public final void writeShort(int s) throws IOException {
        this.bitflush();
        this.out.writeShort(s);
    }

    public final void writeLong(int l) throws IOException {
        this.bitflush();
        this.out.writeInt(l);
    }

    public final void writeLonglong(long ll) throws IOException {
        this.bitflush();
        this.out.writeLong(ll);
    }

    public void writeBit(boolean b) throws IOException {
        if (this.bitMask > 128) {
            this.bitflush();
        }
        if (b) {
            this.bitAccumulator = (byte)(this.bitAccumulator | this.bitMask);
        }
        this.bitMask <<= 1;
        this.needBitFlush = true;
    }

    public final void writeTable(Map<String, Object> table) throws IOException {
        this.bitflush();
        if (table == null) {
            this.out.writeInt(0);
        } else {
            this.out.writeInt((int)Frame.tableSize(table));
            for (Map.Entry<String, Object> entry : table.entrySet()) {
                this.writeShortstr(entry.getKey());
                Object value = entry.getValue();
                if (value instanceof String) {
                    this.writeOctet(83);
                    this.writeLongstr((String)value);
                    continue;
                }
                if (value instanceof LongString) {
                    this.writeOctet(83);
                    this.writeLongstr((LongString)value);
                    continue;
                }
                if (value instanceof Integer) {
                    this.writeOctet(73);
                    this.writeLong((Integer)value);
                    continue;
                }
                if (value instanceof BigDecimal) {
                    this.writeOctet(68);
                    BigDecimal decimal = (BigDecimal)value;
                    this.writeOctet(decimal.scale());
                    BigInteger unscaled = decimal.unscaledValue();
                    if (unscaled.bitLength() > 32) {
                        throw new IllegalArgumentException("BigDecimal too large to be encoded");
                    }
                    this.writeLong(decimal.unscaledValue().intValue());
                    continue;
                }
                if (value instanceof Date) {
                    this.writeOctet(84);
                    this.writeTimestamp((Date)value);
                    continue;
                }
                if (value instanceof Map) {
                    this.writeOctet(70);
                    this.writeTable((Map)value);
                    continue;
                }
                throw new IllegalArgumentException("Invalid value type: " + value.getClass().getName() + " for key " + entry.getKey());
            }
        }
    }

    public final void writeOctet(int octet) throws IOException {
        this.bitflush();
        this.out.writeByte(octet);
    }

    public final void writeOctet(byte octet) throws IOException {
        this.bitflush();
        this.out.writeByte(octet);
    }

    public final void writeTimestamp(Date timestamp) throws IOException {
        this.writeLonglong(timestamp.getTime() / 1000L);
    }

    public void flush() throws IOException {
        this.bitflush();
        this.out.flush();
    }
}

