/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.LongString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentHeaderPropertyWriter {
    public DataOutputStream out;
    public int flagWord;
    public int bitCount;

    public ContentHeaderPropertyWriter(DataOutputStream out) {
        this.out = out;
        this.flagWord = 0;
        this.bitCount = 0;
    }

    public void emitFlagWord(boolean continuationBit) throws IOException {
        this.out.writeShort(continuationBit ? this.flagWord | 1 : this.flagWord);
        this.flagWord = 0;
        this.bitCount = 0;
    }

    public void writePresence(boolean present) throws IOException {
        if (this.bitCount == 15) {
            this.emitFlagWord(true);
        }
        if (present) {
            int bit = 15 - this.bitCount;
            this.flagWord |= 1 << bit;
        }
        ++this.bitCount;
    }

    public void finishPresence() throws IOException {
        this.emitFlagWord(false);
    }

    public void writeShortstr(String str) throws IOException {
        byte[] bytes = str.getBytes("utf-8");
        this.out.writeByte(bytes.length);
        this.out.write(bytes);
    }

    public void writeLongstr(String str) throws IOException {
        byte[] bytes = str.getBytes("utf-8");
        this.out.writeInt(bytes.length);
        this.out.write(bytes);
    }

    public void writeLongstr(LongString str) throws IOException {
        this.out.writeInt((int)str.length());
        IOUtils.copy((InputStream)str.getStream(), (OutputStream)this.out);
    }

    public void writeShort(Integer s) throws IOException {
        this.out.writeShort(s);
    }

    public void writeLong(Integer l) throws IOException {
        this.out.writeInt(l);
    }

    public void writeLonglong(Long ll) throws IOException {
        this.out.writeLong(ll);
    }

    public void writeTable(Map<String, Object> table) throws IOException {
        this.out.writeInt((int)Frame.tableSize(table));
        for (Map.Entry<String, Object> entry : table.entrySet()) {
            this.writeShortstr(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof String) {
                this.out.writeByte(83);
                this.writeLongstr((String)value);
                continue;
            }
            if (value instanceof LongString) {
                this.out.writeByte(83);
                this.writeLongstr((LongString)value);
                continue;
            }
            if (value instanceof Integer) {
                this.out.writeByte(73);
                this.writeLong((Integer)value);
                continue;
            }
            if (value instanceof BigDecimal) {
                this.out.writeByte(68);
                BigDecimal decimal = (BigDecimal)value;
                this.out.writeByte(decimal.scale());
                BigInteger unscaled = decimal.unscaledValue();
                if (unscaled.bitLength() > 32) {
                    throw new IllegalArgumentException("BigDecimal too large to be encoded");
                }
                this.out.writeInt(decimal.unscaledValue().intValue());
                continue;
            }
            if (value instanceof Date) {
                this.out.writeByte(84);
                this.writeTimestamp((Date)value);
                continue;
            }
            if (value instanceof Map) {
                this.out.writeByte(70);
                this.writeTable((Map)value);
                continue;
            }
            throw new IllegalArgumentException("Invalid value type: " + value.getClass().getName() + " for key " + entry.getKey());
        }
    }

    public void writeOctet(Integer octet) throws IOException {
        this.out.writeByte(octet);
    }

    public void writeTimestamp(Date timestamp) throws IOException {
        this.out.writeLong(timestamp.getTime() / 1000L);
    }
}

