/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools;

import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.utility.BlockingCell;
import com.rabbitmq.utility.Utility;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class Tracer
implements Runnable {
    public static final boolean WITHHOLD_INBOUND_HEARTBEATS = Tracer.property("WITHHOLD_INBOUND_HEARTBEATS");
    public static final boolean WITHHOLD_OUTBOUND_HEARTBEATS = Tracer.property("WITHHOLD_OUTBOUND_HEARTBEATS");
    public static final boolean NO_ASSEMBLE_FRAMES = Tracer.property("NO_ASSEMBLE_FRAMES");
    public static final boolean NO_DECODE_FRAMES = Tracer.property("NO_DECODE_FRAMES");
    public static final boolean SUPPRESS_COMMAND_BODIES = Tracer.property("SUPPRESS_COMMAND_BODIES");
    public static final boolean SILENT_MODE = Tracer.property("SILENT_MODE");
    static final int LOG_QUEUE_SIZE = 0x100000;
    static final int BUFFER_SIZE = 0xA00000;
    static final int MAX_TIME_BETWEEN_FLUSHES = 1000;
    static final Object FLUSH = new Object();
    public Socket inSock;
    public Socket outSock;
    public int id;
    public DataInputStream iis;
    public DataOutputStream ios;
    public DataInputStream ois;
    public DataOutputStream oos;
    public AsyncLogger logger;

    private static boolean property(String property) {
        return Boolean.parseBoolean(System.getProperty("com.rabbitmq.tools.Tracer." + property));
    }

    public static void main(String[] args) {
        int listenPort = args.length > 0 ? Integer.parseInt(args[0]) : 5673;
        String connectHost = args.length > 1 ? args[1] : "localhost";
        int connectPort = args.length > 2 ? Integer.parseInt(args[2]) : 5672;
        System.out.println("Usage: Tracer [<listenport> [<connecthost> [<connectport>]]]");
        System.out.println("Invoked as: Tracer " + listenPort + " " + connectHost + " " + connectPort);
        System.out.println("com.rabbitmq.tools.Tracer.WITHHOLD_INBOUND_HEARTBEATS = " + WITHHOLD_INBOUND_HEARTBEATS);
        System.out.println("com.rabbitmq.tools.Tracer.WITHHOLD_OUTBOUND_HEARTBEATS = " + WITHHOLD_OUTBOUND_HEARTBEATS);
        System.out.println("com.rabbitmq.tools.Tracer.NO_ASSEMBLE_FRAMES = " + NO_ASSEMBLE_FRAMES);
        System.out.println("com.rabbitmq.tools.Tracer.NO_DECODE_FRAMES = " + NO_DECODE_FRAMES);
        System.out.println("com.rabbitmq.tools.Tracer.SUPPRESS_COMMAND_BODIES = " + SUPPRESS_COMMAND_BODIES);
        try {
            ServerSocket server = new ServerSocket(listenPort);
            int counter = 0;
            AsyncLogger logger = new AsyncLogger(System.out);
            while (true) {
                Socket conn = server.accept();
                ++counter;
                new Tracer(conn, counter, connectHost, connectPort, logger);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public Tracer(Socket sock, int id, String host, int port, AsyncLogger logger) throws IOException {
        this.inSock = sock;
        this.outSock = new Socket(host, port);
        this.id = id;
        this.iis = new DataInputStream(this.inSock.getInputStream());
        this.ios = new DataOutputStream(this.inSock.getOutputStream());
        this.ois = new DataInputStream(this.outSock.getInputStream());
        this.oos = new DataOutputStream(this.outSock.getOutputStream());
        this.logger = logger;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            byte[] handshake = new byte[8];
            this.iis.readFully(handshake);
            this.oos.write(handshake);
            BlockingCell<Object> w = new BlockingCell<Object>();
            DirectionHandler inHandler = new DirectionHandler(w, true, this.iis, this.oos);
            DirectionHandler outHandler = new DirectionHandler(w, false, this.ois, this.ios);
            new Thread(inHandler).start();
            new Thread(outHandler).start();
            Object result = w.uninterruptibleGet();
            if (result instanceof Exception) {
                this.logException((Exception)result);
            }
        }
        catch (EOFException eofe) {
            this.logException(eofe);
        }
        catch (IOException ioe) {
            this.logException(ioe);
        }
        finally {
            try {
                this.inSock.close();
                this.outSock.close();
            }
            catch (IOException ioe2) {
                this.logException(ioe2);
            }
        }
    }

    public void log(String message) {
        this.logger.log("" + System.currentTimeMillis() + ": conn#" + this.id + " " + message);
    }

    public void logException(Exception e) {
        this.log("uncaught " + Utility.makeStackTrace(e));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DirectionHandler
    implements Runnable {
        public BlockingCell<Object> waitCell;
        public boolean inBound;
        public DataInputStream i;
        public DataOutputStream o;
        public HashMap<Integer, AMQCommand.Assembler> assemblers = new HashMap();

        public DirectionHandler(BlockingCell<Object> waitCell, boolean inBound, DataInputStream i, DataOutputStream o) {
            this.waitCell = waitCell;
            this.inBound = inBound;
            this.i = i;
            this.o = o;
        }

        public Frame readFrame() throws IOException {
            return Frame.readFrom(this.i);
        }

        public void report(int channel, Object object) {
            Tracer.this.log("ch#" + channel + (this.inBound ? " -> " : " <- ") + object);
        }

        public void reportFrame(Frame f) throws IOException {
            switch (f.type) {
                case 1: {
                    this.report(f.channel, AMQImpl.readMethodFrom(f.getInputStream()));
                    break;
                }
                case 2: {
                    AMQContentHeader contentHeader = AMQImpl.readContentHeaderFrom(f.getInputStream());
                    long remainingBodyBytes = contentHeader.getBodySize();
                    this.report(f.channel, "Expected body size: " + remainingBodyBytes + "; " + contentHeader.toString());
                    break;
                }
                default: {
                    this.report(f.channel, f);
                }
            }
        }

        public void doFrame() throws IOException {
            Frame f = this.readFrame();
            if (f != null) {
                if (SILENT_MODE) {
                    f.writeTo(this.o);
                    return;
                }
                if (f.type == 8) {
                    if (this.inBound && !WITHHOLD_INBOUND_HEARTBEATS || !this.inBound && !WITHHOLD_OUTBOUND_HEARTBEATS) {
                        f.writeTo(this.o);
                        this.report(f.channel, f);
                    } else {
                        this.report(f.channel, "(withheld) " + f.toString());
                    }
                } else {
                    f.writeTo(this.o);
                    if (NO_ASSEMBLE_FRAMES || NO_DECODE_FRAMES) {
                        if (NO_DECODE_FRAMES) {
                            this.report(f.channel, f);
                        } else {
                            this.reportFrame(f);
                        }
                    } else {
                        AMQCommand cmd;
                        AMQCommand.Assembler c = this.assemblers.get(f.channel);
                        if (c == null) {
                            c = AMQCommand.newAssembler();
                            this.assemblers.put(f.channel, c);
                        }
                        if ((cmd = c.handleFrame(f)) != null) {
                            this.report(f.channel, cmd.toString(SUPPRESS_COMMAND_BODIES));
                            this.assemblers.remove(f.channel);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        this.doFrame();
                    }
                }
                catch (Exception e) {
                    this.waitCell.setIfUnset(e);
                    this.waitCell.setIfUnset(new Object());
                }
            }
            catch (Throwable throwable) {
                this.waitCell.setIfUnset(new Object());
                throw throwable;
            }
        }
    }

    private static class AsyncLogger
    extends Thread {
        final PrintStream ps;
        final BlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(0x100000, true);

        AsyncLogger(PrintStream ps) {
            this.ps = new PrintStream(new BufferedOutputStream(ps, 0xA00000), false);
            this.start();
            new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(1000L);
                                AsyncLogger.this.queue.add(FLUSH);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        }

        public void run() {
            try {
                while (true) {
                    Object message;
                    if ((message = this.queue.take()) == FLUSH) {
                        this.ps.flush();
                        continue;
                    }
                    this.ps.println(message);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        void log(String message) {
            try {
                this.queue.put(message);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

