/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.impl.AbstractMetricsCollector;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class MicrometerMetricsCollector
extends AbstractMetricsCollector {
    private final AtomicLong connections;
    private final AtomicLong channels;
    private final Counter publishedMessages;
    private final Counter consumedMessages;
    private final Counter acknowledgedMessages;
    private final Counter rejectedMessages;

    public MicrometerMetricsCollector(MeterRegistry registry) {
        this(registry, "rabbitmq");
    }

    public MicrometerMetricsCollector(MeterRegistry registry, String prefix) {
        this((Metrics metric) -> metric.create(registry, prefix));
    }

    public MicrometerMetricsCollector(Function<Metrics, Object> metricsCreator) {
        this.connections = (AtomicLong)metricsCreator.apply(Metrics.CONNECTIONS);
        this.channels = (AtomicLong)metricsCreator.apply(Metrics.CHANNELS);
        this.publishedMessages = (Counter)metricsCreator.apply(Metrics.PUBLISHED_MESSAGES);
        this.consumedMessages = (Counter)metricsCreator.apply(Metrics.CONSUMED_MESSAGES);
        this.acknowledgedMessages = (Counter)metricsCreator.apply(Metrics.ACKNOWLEDGED_MESSAGES);
        this.rejectedMessages = (Counter)metricsCreator.apply(Metrics.REJECTED_MESSAGES);
    }

    @Override
    protected void incrementConnectionCount(Connection connection) {
        this.connections.incrementAndGet();
    }

    @Override
    protected void decrementConnectionCount(Connection connection) {
        this.connections.decrementAndGet();
    }

    @Override
    protected void incrementChannelCount(Channel channel) {
        this.channels.incrementAndGet();
    }

    @Override
    protected void decrementChannelCount(Channel channel) {
        this.channels.decrementAndGet();
    }

    @Override
    protected void markPublishedMessage() {
        this.publishedMessages.increment();
    }

    @Override
    protected void markConsumedMessage() {
        this.consumedMessages.increment();
    }

    @Override
    protected void markAcknowledgedMessage() {
        this.acknowledgedMessages.increment();
    }

    @Override
    protected void markRejectedMessage() {
        this.rejectedMessages.increment();
    }

    public AtomicLong getConnections() {
        return this.connections;
    }

    public AtomicLong getChannels() {
        return this.channels;
    }

    public Counter getPublishedMessages() {
        return this.publishedMessages;
    }

    public Counter getConsumedMessages() {
        return this.consumedMessages;
    }

    public Counter getAcknowledgedMessages() {
        return this.acknowledgedMessages;
    }

    public Counter getRejectedMessages() {
        return this.rejectedMessages;
    }

    public static enum Metrics {
        CONNECTIONS{

            @Override
            Object create(MeterRegistry registry, String prefix) {
                return registry.gauge(prefix + ".connections", (Number)new AtomicLong(0L));
            }
        }
        ,
        CHANNELS{

            @Override
            Object create(MeterRegistry registry, String prefix) {
                return registry.gauge(prefix + ".channels", (Number)new AtomicLong(0L));
            }
        }
        ,
        PUBLISHED_MESSAGES{

            @Override
            Object create(MeterRegistry registry, String prefix) {
                return registry.counter(prefix + ".published", new String[0]);
            }
        }
        ,
        CONSUMED_MESSAGES{

            @Override
            Object create(MeterRegistry registry, String prefix) {
                return registry.counter(prefix + ".consumed", new String[0]);
            }
        }
        ,
        ACKNOWLEDGED_MESSAGES{

            @Override
            Object create(MeterRegistry registry, String prefix) {
                return registry.counter(prefix + ".acknowledged", new String[0]);
            }
        }
        ,
        REJECTED_MESSAGES{

            @Override
            Object create(MeterRegistry registry, String prefix) {
                return registry.counter(prefix + ".rejected", new String[0]);
            }
        };


        abstract Object create(MeterRegistry var1, String var2);
    }
}

