/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream;

import java.time.Duration;

public interface BackOffDelayPolicy {
    public static final Duration TIMEOUT = Duration.ofMillis(Long.MAX_VALUE);

    public static BackOffDelayPolicy fixed(Duration delay) {
        return new FixedWithInitialDelayBackOffPolicy(delay, delay);
    }

    public static BackOffDelayPolicy fixedWithInitialDelay(Duration initialDelay, Duration delay) {
        return new FixedWithInitialDelayBackOffPolicy(initialDelay, delay);
    }

    public static BackOffDelayPolicy fixedWithInitialDelay(Duration initialDelay, Duration delay, Duration timeout) {
        return new FixedWithInitialDelayAndTimeoutBackOffPolicy(initialDelay, delay, timeout);
    }

    public Duration delay(int var1);

    public static final class FixedWithInitialDelayAndTimeoutBackOffPolicy
    implements BackOffDelayPolicy {
        private final int attemptLimitBeforeTimeout;
        private final BackOffDelayPolicy delegate;

        private FixedWithInitialDelayAndTimeoutBackOffPolicy(Duration initialDelay, Duration delay, Duration timeout) {
            this(BackOffDelayPolicy.fixedWithInitialDelay(initialDelay, delay), timeout);
        }

        private FixedWithInitialDelayAndTimeoutBackOffPolicy(BackOffDelayPolicy policy, Duration timeout) {
            if (timeout.toMillis() < policy.delay(0).toMillis()) {
                throw new IllegalArgumentException("Timeout must be longer than initial delay");
            }
            this.delegate = policy;
            Duration initialDelay = policy.delay(0);
            Duration delay = policy.delay(1);
            long timeoutWithInitialDelay = timeout.toMillis() - initialDelay.toMillis();
            this.attemptLimitBeforeTimeout = (int)(timeoutWithInitialDelay / delay.toMillis()) + 1;
        }

        @Override
        public Duration delay(int recoveryAttempt) {
            if (recoveryAttempt >= this.attemptLimitBeforeTimeout) {
                return TIMEOUT;
            }
            return this.delegate.delay(recoveryAttempt);
        }

        public String toString() {
            return "FixedWithInitialDelayAndTimeoutBackOffPolicy{attemptLimitBeforeTimeout=" + this.attemptLimitBeforeTimeout + ", delegate=" + this.delegate + '}';
        }
    }

    public static final class FixedWithInitialDelayBackOffPolicy
    implements BackOffDelayPolicy {
        private final Duration initialDelay;
        private final Duration delay;

        private FixedWithInitialDelayBackOffPolicy(Duration initialDelay, Duration delay) {
            this.initialDelay = initialDelay;
            this.delay = delay;
        }

        @Override
        public Duration delay(int recoveryAttempt) {
            return recoveryAttempt == 0 ? this.initialDelay : this.delay;
        }

        public String toString() {
            return "FixedWithInitialDelayBackOffPolicy{initialDelay=" + this.initialDelay + ", delay=" + this.delay + '}';
        }
    }
}

