/*
 * Decompiled with CFR 0.152.
 */
package com.rameshkp.openapi.merger.app;

import com.rameshkp.openapi.merger.app.OpenApiMergerApp;
import com.rameshkp.openapi.merger.app.exceptions.OpenApiDataInvalidException;
import com.rameshkp.openapi.merger.app.mergers.OpenApiMerger;
import com.rameshkp.openapi.merger.app.models.Contact;
import com.rameshkp.openapi.merger.app.models.ExternalDocs;
import com.rameshkp.openapi.merger.app.models.Info;
import com.rameshkp.openapi.merger.app.models.License;
import com.rameshkp.openapi.merger.app.models.OpenApi;
import com.rameshkp.openapi.merger.app.models.Server;
import com.rameshkp.openapi.merger.app.utils.OpenAPIConverter;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/rameshkp/openapi/merger/app/OpenApiMergerApp;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "openApiMerger", "Lcom/rameshkp/openapi/merger/app/mergers/OpenApiMerger;", "parseOptions", "Lio/swagger/v3/parser/core/models/ParseOptions;", "validFileExtension", "", "", "merge", "", "inputDir", "Ljava/io/File;", "outputFile", "openApi", "Lcom/rameshkp/openapi/merger/app/models/OpenApi;", "validate", "openapi-merger-app"})
public final class OpenApiMergerApp {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<String> validFileExtension = CollectionsKt.listOf((Object[])new String[]{"yaml", "json", "yml"});
    private final ParseOptions parseOptions = new ParseOptions();
    private final OpenApiMerger openApiMerger = new OpenApiMerger();

    /*
     * WARNING - void declaration
     */
    public final void merge(@NotNull File inputDir, @NotNull File outputFile, @Nullable OpenApi openApi) {
        block20: {
            String string;
            ExternalDocumentation externalDocumentation;
            ExternalDocumentation externalDocumentation2;
            ExternalDocumentation externalDocumentation3;
            Object infoModelObj;
            OpenAPI openAPI;
            boolean bl;
            boolean bl2;
            Object object;
            OpenAPI merged;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            Object element$iv2;
            Intrinsics.checkNotNullParameter((Object)inputDir, (String)"inputDir");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            this.validate(openApi);
            Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)inputDir, null, (int)1, null)), (Function1)((Function1)new Function1<File, Boolean>(this){
                final /* synthetic */ OpenApiMergerApp this$0;

                public final boolean invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return OpenApiMergerApp.access$getValidFileExtension$p(this.this$0).contains(FilesKt.getExtension((File)it));
                }
                {
                    this.this$0 = openApiMergerApp;
                    super(1);
                }
            }));
            boolean $i$f$sortedBy = false;
            boolean bl3 = false;
            Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    File it = (File)a;
                    boolean bl2 = false;
                    Comparable comparable = it;
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    File file = it;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)file);
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                File it = (File)element$iv2;
                boolean bl4 = false;
                this.log.debug("Parsing OpenAPI file {}", (Object)it.getAbsolutePath());
                this.parseOptions.setResolve(true);
                OpenAPI openAPI2 = new OpenAPIV3Parser().read(it.getAbsolutePath(), null, this.parseOptions);
                this.openApiMerger.merge(openAPI2);
            }
            OpenApi openApi2 = openApi;
            Intrinsics.checkNotNull((Object)openApi2);
            Iterable $this$map$iv = openApi2.getServers();
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                Server server = (Server)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                io.swagger.v3.oas.models.servers.Server s = new io.swagger.v3.oas.models.servers.Server();
                s.setUrl(it.getUrl());
                s.setDescription(it.getDescription());
                io.swagger.v3.oas.models.servers.Server server2 = s;
                collection.add(server2);
            }
            List servers = (List)destination$iv$iv;
            OpenAPI openAPI3 = merged = this.openApiMerger.get();
            if (openAPI3 == null) break block20;
            OpenAPI openAPI4 = openAPI3;
            boolean bl6 = false;
            boolean bl7 = false;
            OpenAPI $this$run = openAPI4;
            boolean bl8 = false;
            this.log.debug("Constructing the OpenApi model");
            item$iv$iv2 = openApi;
            boolean bl9 = false;
            boolean bl10 = false;
            Object openApiModel = item$iv$iv2;
            boolean bl11 = false;
            $this$run.setOpenapi(((OpenApi)openApiModel).getVersion());
            OpenAPI openAPI5 = $this$run;
            Info info = ((OpenApi)openApiModel).getInfo();
            if (info != null) {
                io.swagger.v3.oas.models.info.Contact contact;
                io.swagger.v3.oas.models.info.Contact contact2;
                io.swagger.v3.oas.models.info.Contact contact3;
                Object contactModelObj;
                io.swagger.v3.oas.models.info.Info info2;
                boolean bl12;
                boolean bl13;
                Object object2;
                object = info;
                bl2 = false;
                bl = false;
                Info info3 = object;
                openAPI = openAPI5;
                boolean bl14 = false;
                io.swagger.v3.oas.models.info.Info info4 = new io.swagger.v3.oas.models.info.Info();
                info4.setTitle(((Info)infoModelObj).getTitle());
                info4.setVersion(((Info)infoModelObj).getVersion());
                info4.setDescription(((Info)infoModelObj).getDescription());
                info4.setTermsOfService(((Info)infoModelObj).getTermsOfService());
                io.swagger.v3.oas.models.info.Info info5 = info4;
                Contact contact4 = ((Info)infoModelObj).getContact();
                if (contact4 != null) {
                    object2 = contact4;
                    bl13 = false;
                    bl12 = false;
                    Contact contact5 = object2;
                    info2 = info5;
                    boolean bl15 = false;
                    io.swagger.v3.oas.models.info.Contact contact6 = new io.swagger.v3.oas.models.info.Contact();
                    contact6.setUrl(((Contact)contactModelObj).getUrl());
                    contact6.setEmail(((Contact)contactModelObj).getEmail());
                    contact6.setName(((Contact)contactModelObj).getName());
                    contact3 = contact6;
                    info5 = info2;
                    contact2 = contact3;
                } else {
                    contact2 = null;
                }
                info5.setContact(contact2);
                io.swagger.v3.oas.models.info.Info info6 = info4;
                License license = ((Info)infoModelObj).getLicense();
                if (license != null) {
                    void licenseModelObj;
                    object2 = license;
                    bl13 = false;
                    bl12 = false;
                    contactModelObj = object2;
                    info2 = info6;
                    boolean bl16 = false;
                    io.swagger.v3.oas.models.info.License license2 = new io.swagger.v3.oas.models.info.License();
                    license2.setUrl(licenseModelObj.getUrl());
                    license2.setName(licenseModelObj.getName());
                    contact3 = license2;
                    info6 = info2;
                    contact = contact3;
                } else {
                    contact = null;
                }
                info6.setLicense(contact);
                externalDocumentation3 = info4;
                openAPI5 = openAPI;
                externalDocumentation2 = externalDocumentation3;
            } else {
                externalDocumentation2 = null;
            }
            openAPI5.setInfo(externalDocumentation2);
            OpenAPI openAPI6 = $this$run;
            ExternalDocs externalDocs = ((OpenApi)openApiModel).getExternalDocs();
            if (externalDocs != null) {
                void externalDocsModelObj;
                object = externalDocs;
                bl2 = false;
                bl = false;
                infoModelObj = object;
                openAPI = openAPI6;
                boolean bl17 = false;
                ExternalDocumentation externalDocs2 = new ExternalDocumentation();
                externalDocs2.setUrl(externalDocsModelObj.getUrl());
                externalDocs2.setDescription(externalDocsModelObj.getDescription());
                externalDocumentation3 = externalDocs2;
                openAPI6 = openAPI;
                externalDocumentation = externalDocumentation3;
            } else {
                externalDocumentation = null;
            }
            openAPI6.setExternalDocs(externalDocumentation);
            object = servers;
            bl2 = false;
            if (!object.isEmpty()) {
                $this$run.setServers(servers);
            }
            switch (FilesKt.getExtension((File)outputFile)) {
                case "json": {
                    string = OpenAPIConverter.toJson($this$run);
                    break;
                }
                case "yml": 
                case "yaml": {
                    string = OpenAPIConverter.toYaml($this$run);
                    break;
                }
                default: {
                    string = "";
                }
            }
            String out = string;
            this.log.debug("Writing the merged output file {}", (Object)outputFile.getAbsolutePath());
            String string2 = out;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"out");
            FilesKt.writeText((File)outputFile, (String)string2, (Charset)Charsets.UTF_8);
        }
    }

    private final void validate(OpenApi openApi) {
        ValidatorFactory validationFactory;
        if (openApi == null) {
            throw (Throwable)new OpenApiDataInvalidException("OpenApi Model parameter cannot be null.");
        }
        ValidatorFactory validatorFactory = validationFactory = Validation.buildDefaultValidatorFactory();
        Intrinsics.checkNotNullExpressionValue((Object)validatorFactory, (String)"validationFactory");
        String errorMessage2 = validatorFactory.getValidator().validate((Object)openApi, new Class[0]).stream().map(validate.errorMessage.1.INSTANCE).collect(Collectors.joining("\n"));
        CharSequence charSequence = errorMessage2;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.log.error("Validation error has occurred. errorMessage {}", (Object)errorMessage2);
            throw (Throwable)new OpenApiDataInvalidException(errorMessage2);
        }
    }

    public static final /* synthetic */ List access$getValidFileExtension$p(OpenApiMergerApp $this) {
        return $this.validFileExtension;
    }
}

