/*
 * Decompiled with CFR 0.152.
 */
package com.randomnoun.maven.plugin.yamlCombine;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.io.FileUtils;
import org.yaml.snakeyaml.Yaml;

public class YamlCombiner {
    File relativeDir;
    String[] files;
    boolean verbose;
    Log log;
    List<FileUtils.FilterWrapper> filterWrappers;
    private Map<String, Map<String, Object>> yamlFiles = new HashMap<String, Map<String, Object>>();

    public List<FileUtils.FilterWrapper> getFilterWrappers() {
        return this.filterWrappers;
    }

    public void setFilterWrappers(List<FileUtils.FilterWrapper> filterWrappers) {
        this.filterWrappers = filterWrappers;
    }

    public void combine(Writer w) throws IOException {
        ArrayList<String> fileList = new ArrayList<String>(Arrays.asList(this.files));
        Collections.sort(fileList);
        Yaml yaml = new Yaml();
        Map mergedObj = null;
        for (String f : fileList) {
            FileInputStream inputStream = new FileInputStream(new File(this.relativeDir, f));
            Reader reader = new InputStreamReader(inputStream);
            if (this.filterWrappers != null) {
                for (FileUtils.FilterWrapper wrapper : this.filterWrappers) {
                    reader = wrapper.getReader(reader);
                }
            }
            Map obj = (Map)yaml.load(reader);
            if (mergedObj == null) {
                mergedObj = obj;
                continue;
            }
            this.merge(mergedObj, obj, f, "");
        }
        this.replaceRefs(mergedObj, this.relativeDir, "");
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(YAMLGenerator.Feature.SPLIT_LINES, false).configure(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS, true));
        this.configureMapper(mapper);
        mapper.writeValue(w, mergedObj);
        w.flush();
    }

    private void merge(Map<Object, Object> mergedObj, Map<Object, Object> obj, String f, String prefix) throws IllegalArgumentException {
        LinkedHashSet<Object> cloneSet = new LinkedHashSet<Object>(obj.keySet());
        for (Object e : cloneSet) {
            Object v = obj.get(e);
            Object mv = mergedObj.get(e);
            if (mv == null) {
                mergedObj.put(e, v);
                continue;
            }
            if (v == null) continue;
            if (mv instanceof Map && v instanceof Map) {
                this.merge((Map)mv, (Map)v, f, prefix + String.valueOf(e) + "/");
                continue;
            }
            if (mv.getClass().equals(v.getClass())) {
                mergedObj.put(e, v);
                continue;
            }
            throw new IllegalArgumentException("Could not merge " + f + "#" + prefix + String.valueOf(e) + " (" + v.getClass().getName() + ") into merged object " + mv.getClass().getName());
        }
    }

    private Object replaceRefs(Map<Object, Object> obj, File relativeDir, String spacePrefix) throws IllegalArgumentException, IOException {
        Object result = null;
        if (obj.containsKey("$xref")) {
            Object xref = obj.get("$xref");
            if (this.verbose) {
                this.getLog().info((CharSequence)(spacePrefix + "$xref to " + xref));
            }
            if ((result = this.getXref(relativeDir, (String)xref)) instanceof Map) {
                result = new HashMap<Object, Object>((Map<Object, Object>)result);
                result = this.replaceRefs((Map<Object, Object>)result, relativeDir, spacePrefix + "  ");
            }
            for (Object object : obj.keySet()) {
                Object v = obj.get(object);
                if (object.equals("$xref")) continue;
                if (this.verbose) {
                    this.getLog().info((CharSequence)(spacePrefix + String.valueOf(object)));
                }
                if (result instanceof Map) {
                    Map r = (Map)result;
                    if (r.get(object) == null) {
                        r.put(object, v);
                        continue;
                    }
                    if (r.get(object) instanceof Map && v instanceof Map) {
                        Map rv = (Map)r.get(object);
                        this.merge(rv, (Map)v, "", String.valueOf(object) + "/");
                        continue;
                    }
                    r.put(object, v);
                    continue;
                }
                throw new IllegalArgumentException("Could not override " + String.valueOf(object) + " (" + v.getClass().getName() + ") from xref '" + xref + "' " + result.getClass().getName());
            }
        } else {
            LinkedHashSet<Object> cloneSet = new LinkedHashSet<Object>(obj.keySet());
            for (Object e : cloneSet) {
                Object v = obj.get(e);
                if (e.equals("$xref")) {
                    throw new IllegalStateException("$xref found in Map that didn't contain $xref");
                }
                if (this.verbose) {
                    this.getLog().info((CharSequence)(spacePrefix + String.valueOf(e)));
                }
                if (!(v instanceof Map)) continue;
                HashMap<Object, Object> clone = new HashMap<Object, Object>((Map)v);
                Object newObject = this.replaceRefs(clone, relativeDir, spacePrefix + "  ");
                obj.put(e, newObject);
            }
            result = obj;
        }
        return result;
    }

    private Object getXref(File relativeDir, String ref) throws IllegalArgumentException, IOException {
        int pos = ref.indexOf(35);
        if (pos == -1) {
            throw new IllegalArgumentException("Unparseable $xref '" + ref + "'");
        }
        String f = ref.substring(0, pos);
        String p = ref.substring(pos + 1);
        final StringBuilder result = new StringBuilder();
        p.chars().forEachOrdered(new IntConsumer(){
            boolean asJsonPath = true;

            @Override
            public void accept(int ch) {
                if (ch == 35) {
                    this.asJsonPath = !this.asJsonPath;
                } else if (this.asJsonPath) {
                    result.append((char)ch);
                } else if (ch == 47) {
                    result.append("~1");
                } else if (ch == 126) {
                    result.append("~0");
                } else {
                    result.append((char)ch);
                }
            }
        });
        ref = f + "#" + result.toString();
        String[] refParts = ref.split("#/");
        String file = refParts[0];
        String definitionPath = refParts.length == 2 ? refParts[1] : null;
        Map contents = this.yamlFiles.get(file);
        if (contents == null) {
            Yaml yaml = new Yaml();
            File inputFile = new File(relativeDir, file);
            FileInputStream inputStream = new FileInputStream(inputFile);
            try {
                contents = (Map)yaml.load((InputStream)inputStream);
            }
            catch (Exception e) {
                throw new IOException("Invalid YAML file '" + inputFile.getCanonicalPath() + "'", e);
            }
            ((InputStream)inputStream).close();
            this.yamlFiles.put(file, contents);
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)("definitionPath '" + definitionPath + "' in '" + file + "'"));
        }
        if (definitionPath == null) {
            return contents;
        }
        String[] jsonPathElements = definitionPath.split("/");
        Map node = contents;
        for (String jsonPathElement : jsonPathElements) {
            try {
                node = node.get(this.unescapePointer(jsonPathElement));
                if (node != null) continue;
                throw new IllegalArgumentException("Could not find " + definitionPath + " in contents of " + file);
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Could not descend into " + jsonPathElement + " of " + definitionPath + " in contents of " + file);
            }
        }
        return node;
    }

    private String unescapePointer(String jsonPathElement) {
        try {
            jsonPathElement = URLDecoder.decode(jsonPathElement, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        jsonPathElement = jsonPathElement.replaceAll("~1", "/");
        return jsonPathElement.replaceAll("~0", "~");
    }

    private void configureMapper(ObjectMapper mapper) {
    }

    public File getRelativeDir() {
        return this.relativeDir;
    }

    public void setRelativeDir(File relativeDir) {
        this.relativeDir = relativeDir;
    }

    public String[] getFiles() {
        return this.files;
    }

    public void setFiles(String[] files) {
        this.files = files;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

