/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.maven;

import com.h3xstream.maven.AbstractMojo;
import com.h3xstream.maven.tpl.ProjectSummary;
import com.h3xstream.maven.tpl.VulnerableLibrary;
import com.h3xstream.maven.victims.CveVulnerability;
import com.h3xstream.maven.victims.VictimsDbLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.authentication.AuthenticationException;

public class SecurityVersionsCheck
extends AbstractMojo {
    private Boolean updateRepository = Boolean.FALSE;
    private static VictimsDbLoader victimDb;
    private static Object victimDbSync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        int size;
        MavenProject lastProject;
        MavenProject rootProject = this.getProject();
        if (!rootProject.isExecutionRoot()) {
            return;
        }
        if (this.reactorProjects != null && (lastProject = (MavenProject)this.reactorProjects.get((size = this.reactorProjects.size()) - 1)) != this.getProject()) {
            return;
        }
        ArrayList<ProjectSummary> projectSummaries = new ArrayList<ProjectSummary>();
        try {
            ArrayList<MavenProject> allProjects = new ArrayList<MavenProject>(rootProject.getCollectedProjects());
            allProjects.add(rootProject);
            for (MavenProject project : allProjects) {
                DependencyNode rootNode;
                this.getLog().info((CharSequence)("Analyzing the dependencies for " + project.getGroupId() + ":" + project.getArtifactId()));
                Object object = victimDbSync;
                synchronized (object) {
                    if (victimDb == null) {
                        victimDb = new VictimsDbLoader(this.getLog(), this.wagonManager);
                        victimDb.loadRepository();
                    }
                }
                try {
                    rootNode = this.dependencyGraphBuilder.buildDependencyGraph(project, this.createResolvingArtifactFilter());
                }
                catch (DependencyGraphBuilderException e) {
                    this.getLog().error((CharSequence)"Unable to build the complete dependency graph.");
                    throw new MojoFailureException("Unable to build the complete dependency graph.", (Throwable)e);
                }
                ArrayList<VulnerableLibrary> vulnerableLibraries = new ArrayList<VulnerableLibrary>();
                this.visitNode(rootNode, 0, vulnerableLibraries);
                this.displayCommandLine(vulnerableLibraries);
                if (vulnerableLibraries.size() <= 0) continue;
                projectSummaries.add(new ProjectSummary(project, vulnerableLibraries));
            }
        }
        catch (WagonConfigurationException e) {
            throw new MojoFailureException("Unable load the repository.", (Throwable)e);
        }
        catch (UnsupportedProtocolException e) {
            throw new MojoFailureException("Unable load the repository.", (Throwable)e);
        }
        catch (ConnectionException e) {
            throw new MojoFailureException("Unable load the repository.", (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new MojoFailureException("Unable load the repository.", (Throwable)e);
        }
        try {
            File targetDir = new File(this.getProject().getBuild().getDirectory());
            if (!targetDir.exists()) {
                targetDir.mkdir();
            }
            new File(targetDir, "/dependencies/").mkdir();
            FileOutputStream out = new FileOutputStream(new File(targetDir, "/dependencies/index.html"));
            for (String file : Arrays.asList("bootstrap.min.css", "font-awesome.min.css", "fontawesome-webfont.ttf")) {
                this.copy(((Object)((Object)this)).getClass().getResourceAsStream("/victims_tpl/" + file), new FileOutputStream(new File(targetDir, "/dependencies/" + file)));
            }
            this.exportToHtml(projectSummaries, out);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException("Unable to write the HTML report.", (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to write the HTML report.", (Throwable)e);
        }
        catch (TemplateException e) {
            throw new MojoFailureException("Unable generate the HTML report using the template.", (Throwable)e);
        }
    }

    private void visitNode(DependencyNode baseNode, int level, List<VulnerableLibrary> vulnerabilities) {
        Artifact a = baseNode.getArtifact();
        List<CveVulnerability> cves = victimDb.search(a.getGroupId(), a.getArtifactId(), a.getVersion());
        if (cves.size() > 0) {
            vulnerabilities.add(new VulnerableLibrary(a, cves, this.getHierarchyChain(baseNode)));
        }
        for (DependencyNode childNode : baseNode.getChildren()) {
            this.visitNode(childNode, level + 1, vulnerabilities);
        }
    }

    private List<Artifact> getHierarchyChain(DependencyNode baseNode) {
        ArrayList<Artifact> chain = new ArrayList<Artifact>();
        DependencyNode node = baseNode;
        while ((node = node.getParent()) != null) {
            chain.add(node.getArtifact());
        }
        return chain;
    }

    public void displayCommandLine(List<VulnerableLibrary> libraries) {
        if (!libraries.isEmpty()) {
            for (VulnerableLibrary lib : libraries) {
                Artifact a = lib.getArtifact();
                for (CveVulnerability vuln : lib.getVulnerabilities()) {
                    this.getLog().error((CharSequence)(a.getGroupId() + ":" + a.getArtifactId() + " is vulnerable to CVE-" + vuln.getCveId()));
                }
            }
        }
    }

    public void exportToHtml(List<ProjectSummary> projects, OutputStream out) throws IOException, TemplateException {
        PrintWriter pw = new PrintWriter(out);
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "/");
        Template tpl = cfg.getTemplate("/victims_tpl/vulnerable_dependencies.html");
        HashMap<String, List<ProjectSummary>> ctxData = new HashMap<String, List<ProjectSummary>>();
        ctxData.put("projects", projects);
        tpl.process(ctxData, (Writer)new OutputStreamWriter(out));
    }

    private ArtifactFilter createResolvingArtifactFilter() {
        return new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(InputStream in, OutputStream out) throws IOException {
        try {
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    static {
        victimDbSync = new Object();
    }
}

