/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.maven.victims;

import com.h3xstream.maven.VersionUtil;
import com.h3xstream.maven.http.HttpRepository;
import com.h3xstream.maven.http.WagonHttpRepository;
import com.h3xstream.maven.victims.AffectedVersion;
import com.h3xstream.maven.victims.CveVulnerability;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.yaml.snakeyaml.Yaml;

public class VictimsDbLoader {
    private static final String URL_ARCHIVE_FILE = "archive/master.zip";
    private static final String URL_COMMITS_FILE = "commits.atom";
    private Log log;
    private WagonManager wagonManager;
    private Map<String, List<CveVulnerability>> cves;
    protected HttpRepository repo;
    private static final Pattern YAML_JAVA_FILE = Pattern.compile("database/java/[\\d]+/[\\d]+.yaml");

    public VictimsDbLoader(Log log, WagonManager wagonManager) throws WagonConfigurationException, UnsupportedProtocolException, ConnectionException, AuthenticationException {
        this.log = log;
        this.wagonManager = wagonManager;
        if (wagonManager != null) {
            this.repo = new WagonHttpRepository(log, wagonManager);
        }
    }

    public Map<String, List<CveVulnerability>> getRepository() {
        return this.cves;
    }

    public void loadRepository() {
        this.cves = new HashMap<String, List<CveVulnerability>>();
        String homeDir = System.getProperty("user.home");
        File cacheDir = new File(homeDir, ".victims");
        File victimsRepoFile = new File(cacheDir, "master.zip");
        File versionFile = new File(cacheDir, "version.txt");
        try {
            ZipEntry entry;
            if (!cacheDir.exists()) {
                this.log.info((CharSequence)("Creating victim cache directory " + cacheDir.getCanonicalPath()));
                cacheDir.mkdir();
            }
            this.log.info((CharSequence)"Syncing with the victims repository (based on the atom feed)");
            File tempAtomFeed = File.createTempFile("commits-atom", ".xml");
            this.log.debug((CharSequence)("Temp file: " + tempAtomFeed.getCanonicalPath()));
            this.repo.getFile(URL_COMMITS_FILE, tempAtomFeed);
            String latestVersion = this.getLatestVersion(tempAtomFeed);
            String localeVersion = this.getFileContent(versionFile);
            this.log.debug((CharSequence)String.format("Latest version %s, Locale version %s", latestVersion, localeVersion));
            if (latestVersion.equals(localeVersion)) {
                this.log.info((CharSequence)"Already to the latest version.");
            } else {
                if (victimsRepoFile.exists()) {
                    this.log.info((CharSequence)"Removing existing database.");
                    victimsRepoFile.delete();
                }
                if (versionFile.exists()) {
                    versionFile.delete();
                }
                this.log.debug((CharSequence)"Downloading the latest repository");
                this.repo.getFile(URL_ARCHIVE_FILE, victimsRepoFile);
                this.writeVersionFile(versionFile, latestVersion);
            }
            ZipInputStream stream = new ZipInputStream(new FileInputStream(victimsRepoFile));
            while ((entry = stream.getNextEntry()) != null) {
                if (!YAML_JAVA_FILE.matcher(entry.getName()).find()) continue;
                ArrayList<String> artifactIds = new ArrayList<String>();
                CveVulnerability newCve = this.parseCveYamlFile(stream, artifactIds);
                for (String artifactId : artifactIds) {
                    List<CveVulnerability> vulns = this.cves.get(artifactId);
                    if (vulns == null) {
                        vulns = new ArrayList<CveVulnerability>();
                        this.cves.put(artifactId, vulns);
                    }
                    vulns.add(newCve);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private CveVulnerability parseCveYamlFile(InputStream in, List<String> outArtifact) {
        Yaml yaml = new Yaml();
        Map obj = (Map)yaml.load(in);
        String cveId = (String)obj.get("cve");
        String title = (String)obj.get("title");
        String description = (String)obj.get("description");
        String cvssScore = obj.get("cvss_v2") != null ? String.valueOf((Double)obj.get("cvss_v2")) : null;
        List references = (List)obj.get("references");
        ArrayList<AffectedVersion> parsedVersions = new ArrayList<AffectedVersion>(5);
        List affectedVersions = (List)obj.get("affected");
        for (Map version : affectedVersions) {
            String fullArtifactId = version.get("groupId") + ":" + version.get("artifactId");
            List versionsVulnerable = (List)version.get("version");
            parsedVersions.add(new AffectedVersion(fullArtifactId, versionsVulnerable));
            outArtifact.add(fullArtifactId);
        }
        CveVulnerability cve = new CveVulnerability(cveId, title, description, cvssScore, references, parsedVersions);
        return cve;
    }

    public List<CveVulnerability> search(String groupId, String artifactId, String version) {
        ArrayList<CveVulnerability> results = new ArrayList<CveVulnerability>();
        String fullArtifactId = groupId + ":" + artifactId;
        List<CveVulnerability> vulnerabilities = this.cves.get(fullArtifactId);
        if (vulnerabilities != null) {
            for (CveVulnerability vuln : vulnerabilities) {
                if (!VersionUtil.isAffected(fullArtifactId, version, vuln)) continue;
                results.add(vuln);
            }
        }
        return results;
    }

    public String getLatestVersion(File atomFile) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        DocumentBuilderFactory objDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
        objDocumentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder objDocumentBuilder = objDocumentBuilderFactory.newDocumentBuilder();
        XPath xPath = XPathFactory.newInstance().newXPath();
        Document doc = objDocumentBuilder.parse(new FileInputStream(atomFile));
        String latestVersion = xPath.compile("/feed/updated").evaluate(doc);
        if (latestVersion == null) {
            throw new RuntimeException("Unable to read the latest commits feed.");
        }
        return latestVersion;
    }

    private String getFileContent(File versionFile) throws FileNotFoundException {
        return !versionFile.exists() ? null : new Scanner(versionFile).useDelimiter("\\A").next();
    }

    private void writeVersionFile(File versionFile, String version) throws FileNotFoundException, UnsupportedEncodingException {
        PrintWriter writer = new PrintWriter(new FileOutputStream(versionFile, false));
        writer.print(version);
        writer.close();
    }
}

