/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers;

import com.redis.enterprise.Admin;
import com.redis.enterprise.Database;
import com.redis.testcontainers.RedisEnterpriseContainer;
import com.redis.testcontainers.RedisServer;
import java.io.IOException;
import java.util.Optional;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.lifecycle.Startable;

public class RedisEnterpriseServer
implements RedisServer,
Startable {
    private static final String ENV_PREFIX = "REDIS_ENTERPRISE_";
    public static final String ENV_HOST = "REDIS_ENTERPRISE_HOST";
    public static final String ENV_USER = "REDIS_ENTERPRISE_USER";
    public static final String ENV_PASSWORD = "REDIS_ENTERPRISE_PASSWORD";
    public static final String ENV_PORT = "REDIS_ENTERPRISE_PORT";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_USER = "admin@redis.com";
    public static final String DEFAULT_PASSWORD = "redis123";
    public static final int DEFAULT_PORT = 8443;
    private String host = RedisEnterpriseServer.getenv("REDIS_ENTERPRISE_HOST", "localhost");
    private int adminPort = RedisEnterpriseServer.getenvInt("REDIS_ENTERPRISE_PORT", 8443);
    private String adminUsername = RedisEnterpriseServer.getenv("REDIS_ENTERPRISE_USER", "admin@redis.com");
    private String adminPassword = RedisEnterpriseServer.getenv("REDIS_ENTERPRISE_PASSWORD", "redis123");
    private Database database = RedisEnterpriseContainer.defaultDatabase();
    private Database runningDatabase;
    private Admin admin;

    private static String getenv(String name, String defaultValue) {
        return RedisEnterpriseServer.getenv(name).orElse(defaultValue);
    }

    private static Optional<String> getenv(String name) {
        String value = System.getenv(name);
        if (value == null || value.length() == 0) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    private static int getenvInt(String name, int defaultValue) {
        return RedisEnterpriseServer.getenv(name).map(Integer::parseInt).orElse(defaultValue);
    }

    public Database getDatabase() {
        return this.database;
    }

    public Admin getAdmin() {
        return this.admin;
    }

    public RedisEnterpriseServer withDatabase(Database database) {
        this.database = database;
        return this;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public RedisEnterpriseServer withAdminPort(int port) {
        this.adminPort = port;
        return this;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public RedisEnterpriseServer withAdminPassword(String password) {
        this.adminPassword = password;
        return this;
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public RedisEnterpriseServer withAdminUsername(String username) {
        this.adminUsername = username;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public RedisEnterpriseServer withHost(String host) {
        this.host = host;
        return this;
    }

    @Override
    public String getRedisHost() {
        return this.getHost();
    }

    @Override
    public int getRedisPort() {
        return this.runningDatabase.getPort();
    }

    @Override
    public boolean isRedisCluster() {
        return this.runningDatabase.isOssCluster();
    }

    public synchronized void start() {
        if (this.admin == null) {
            this.admin = new Admin();
            this.admin.withUserName(this.adminUsername);
            this.admin.withPassword(this.adminPassword);
            this.admin.withHost(this.host);
        }
        if (this.runningDatabase == null) {
            try {
                this.admin.getDatabases().stream().filter(d -> d.getName().equals(this.database.getName())).map(Database::getUid).forEach(arg_0 -> ((Admin)this.admin).deleteDatabase(arg_0));
                this.runningDatabase = this.admin.createDatabase(this.database);
            }
            catch (Exception e) {
                throw new ContainerLaunchException("Could not initialize Redis Enterprise database", (Throwable)e);
            }
        }
    }

    public synchronized void stop() {
        if (this.runningDatabase != null) {
            this.admin.deleteDatabase(this.runningDatabase.getUid().longValue());
            this.runningDatabase = null;
        }
        if (this.admin != null) {
            try {
                this.admin.close();
                this.admin = null;
            }
            catch (IOException e) {
                throw new ContainerLaunchException("Could not close Redis Enterprise admin", (Throwable)e);
            }
        }
    }
}

