/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import java.util.Arrays;
import java.util.Date;

public class ExpiredToken {
    private final byte[] token;
    private final Date expiration;

    protected ExpiredToken(byte[] token, Date expiration) {
        this.token = Arrays.copyOf(token, token.length);
        this.expiration = new Date(expiration.getTime());
    }

    public byte[] getToken() {
        return this.token;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expiration == null ? 0 : this.expiration.hashCode());
        result = 31 * result + Arrays.hashCode(this.token);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpiredToken other = (ExpiredToken)obj;
        if (this.expiration == null ? other.expiration != null : !this.expiration.equals(other.expiration)) {
            return false;
        }
        return Arrays.equals(this.token, other.token);
    }

    public String toString() {
        return "ExpiredToken [token=" + Arrays.toString(this.token) + ", expiration=" + this.expiration + "]";
    }
}

