/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.relayrides.pushy.apns.ApnsEnvironment;
import com.relayrides.pushy.apns.ApnsPushNotification;
import com.relayrides.pushy.apns.PushManager;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushManagerFactory<T extends ApnsPushNotification> {
    private static final String PROTOCOL = "TLS";
    private static final String DEFAULT_ALGORITHM = "SunX509";
    private final ApnsEnvironment environment;
    private final SSLContext sslContext;
    private int concurrentConnectionCount = 1;
    private NioEventLoopGroup eventLoopGroup;
    private ExecutorService listenerExecutorService;
    private BlockingQueue<T> queue;
    private static final Logger log = LoggerFactory.getLogger(PushManagerFactory.class);

    public PushManagerFactory(ApnsEnvironment environment, SSLContext sslContext) {
        if (environment == null) {
            throw new NullPointerException("APNs environment must not be null.");
        }
        if (sslContext == null) {
            throw new NullPointerException("SSL context must not be null.");
        }
        this.environment = environment;
        this.sslContext = sslContext;
    }

    public PushManagerFactory<T> setConcurrentConnectionCount(int concurrentConnectionCount) {
        this.concurrentConnectionCount = concurrentConnectionCount;
        return this;
    }

    public PushManagerFactory<T> setEventLoopGroup(NioEventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public PushManagerFactory<T> setListenerExecutorService(ExecutorService listenerExecutorService) {
        this.listenerExecutorService = listenerExecutorService;
        return this;
    }

    public PushManagerFactory<T> setQueue(BlockingQueue<T> queue) {
        this.queue = queue;
        return this;
    }

    public PushManager<T> buildPushManager() {
        return new PushManager<T>(this.environment, this.sslContext, this.concurrentConnectionCount, this.eventLoopGroup, this.listenerExecutorService, this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLContext createDefaultSSLContext(String pathToPKCS12File, String keystorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException, IOException {
        FileInputStream keystoreInputStream = new FileInputStream(pathToPKCS12File);
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(keystoreInputStream, keystorePassword != null ? keystorePassword.toCharArray() : null);
            SSLContext sSLContext = PushManagerFactory.createDefaultSSLContext(keyStore, keystorePassword != null ? keystorePassword.toCharArray() : null);
            return sSLContext;
        }
        finally {
            try {
                keystoreInputStream.close();
            }
            catch (IOException e) {
                log.error("Failed to close keystore input stream.", (Throwable)e);
            }
        }
    }

    public static SSLContext createDefaultSSLContext(KeyStore keyStore, char[] keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = DEFAULT_ALGORITHM;
        }
        if (keyStore.size() == 0) {
            throw new KeyStoreException("Keystore is empty; while this is legal for keystores in general, APNs clients must have at least one key.");
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
        trustManagerFactory.init((KeyStore)null);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
        keyManagerFactory.init(keyStore, keyStorePassword);
        SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sslContext;
    }
}

