/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.utils.Os;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.FileUtils;

@Mojo(name="backwards-compatibility-check", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class BackwardsCompatibilityCheckMojo
extends AbstractMojo {
    public static final int RESULT_CODE_SUCCESS = 0;
    @Parameter(defaultValue="${basedir}/src/main/proto")
    private String protoSourceRoot;
    @Parameter
    private String lockDir;
    @Parameter(property="allowBreakingChanges", defaultValue="false")
    private boolean allowBreakingChanges;
    @Parameter(property="plugins", required=false)
    private List<String> plugins;
    @Parameter(property="options", required=false)
    private String options;
    @Parameter(required=false, defaultValue="${project.build.directory}/protolock-plugins")
    private File protolockPluginDirectory;
    @Parameter(required=true, readonly=true, property="localRepository")
    protected ArtifactRepository localRepository;
    @Parameter(required=true, readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected ResolutionErrorHandler resolutionErrorHandler;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block32: {
            Path exePath;
            String classifier = this.project.getProperties().getProperty("os.detected.classifier");
            if (classifier == null) {
                this.getLog().error((CharSequence)"Add os-maven-plugin to your POM. https://github.com/trustin/os-maven-plugin");
                throw new MojoExecutionException("Unable to detect OS type.");
            }
            try {
                this.protolockPluginDirectory = this.protolockPluginDirectory.getCanonicalFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem with plugin directory path", (Exception)e);
            }
            Path exeDirPath = Paths.get(this.project.getBuild().getDirectory(), "protolock-bin");
            try {
                Files.createDirectories(exeDirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create the protolock binary directory", (Exception)e);
            }
            String exeExtension = "";
            if (classifier.startsWith("windows")) {
                exeExtension = ".exe";
            }
            if (!Files.exists(exePath = exeDirPath.resolve("protolock" + exeExtension), new LinkOption[0])) {
                String protolockResourcePath = classifier + "/protolock" + exeExtension;
                try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(protolockResourcePath);){
                    if (in == null) {
                        throw new MojoExecutionException("OS not supported. Unable to find a protolock binary for the classifier " + classifier);
                    }
                    Files.copy(in, exePath, new CopyOption[0]);
                    PosixFileAttributeView attributes = Files.getFileAttributeView(exePath, PosixFileAttributeView.class, new LinkOption[0]);
                    if (attributes != null) {
                        attributes.setPermissions(PosixFilePermissions.fromString("rwxrwxr-x"));
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to write the protolock binary", (Exception)e);
                }
            }
            ArrayList<String> pluginFileNames = new ArrayList<String>();
            if (this.plugins != null) {
                for (String pluginSpec : this.plugins) {
                    if (pluginSpec.contains(":")) {
                        Artifact plugin = this.createDependencyArtifact(pluginSpec);
                        File pluginFile = this.resolveBinaryArtifact(plugin);
                        pluginFileNames.add(pluginFile.getName());
                        continue;
                    }
                    pluginFileNames.add(pluginSpec);
                }
            }
            String pathEnv = "PATH=" + System.getenv("PATH");
            if (this.plugins != null && !this.plugins.isEmpty()) {
                pathEnv = classifier.startsWith("windows") ? pathEnv + ";" : pathEnv + ":";
                pathEnv = pathEnv + this.protolockPluginDirectory.getAbsolutePath();
            }
            String pluginsOption = "";
            if (!pluginFileNames.isEmpty()) {
                pluginsOption = " --plugins=" + StringUtils.join((Object[])pluginFileNames.toArray(), (String)",");
            }
            try {
                if (this.lockDir == null) {
                    this.lockDir = this.protoSourceRoot;
                }
                String protolockAdditionalOptions = this.getAdditionalOptions();
                Path lockFile = Paths.get(this.lockDir, "proto.lock");
                File protoRoot = new File(this.protoSourceRoot);
                if (!Files.exists(lockFile, new LinkOption[0])) {
                    Process protolockProcess = this.executeProtolock(exePath, "init", pathEnv, pluginsOption, protolockAdditionalOptions, protoRoot);
                    if (protolockProcess.waitFor() == 0) {
                        this.getLog().info((CharSequence)"Initialized protolock.");
                        break block32;
                    }
                    throw new MojoFailureException("Error initializing protolock. Check log for details");
                }
                Process protolockStatusProcess = this.executeProtolock(exePath, "status", pathEnv, pluginsOption, protolockAdditionalOptions, protoRoot);
                if (protolockStatusProcess.waitFor() == 0) {
                    Process protolockCommitProcess = this.executeProtolock(exePath, "commit", pathEnv, pluginsOption, protolockAdditionalOptions, protoRoot);
                    if (protolockCommitProcess.waitFor() == 0) {
                        this.getLog().info((CharSequence)"Backwards compatibility check passed.");
                        break block32;
                    }
                    throw new MojoFailureException("Error committing new protolock changes. Check log for details");
                }
                if (this.allowBreakingChanges) {
                    Process protolockCommitProcess = this.executeProtolock(exePath, "commit", pathEnv, pluginsOption, protolockAdditionalOptions = protolockAdditionalOptions + " --force=true", protoRoot);
                    if (protolockCommitProcess.waitFor() == 0) {
                        this.getLog().warn((CharSequence)"Breaking changes accepted");
                        break block32;
                    }
                    throw new MojoFailureException("Error committing new protolock changes. Check log for details");
                }
                throw new MojoFailureException("Backwards compatibility check failed! You can override this by specifying allowBreakingChanges=true");
            }
            catch (IOException | InterruptedException e) {
                throw new MojoExecutionException("An error occurred while running protolock", e);
            }
        }
    }

    private String getAdditionalOptions() throws MojoFailureException {
        if (this.options != null && this.options.toUpperCase().contains("--LOCKDIR")) {
            throw new MojoFailureException("lockDir location must be specified on the plugin and not as an option passed to protolock command");
        }
        return this.options == null ? "" : this.options;
    }

    private Process executeProtolock(Path exePath, String command, String pathEnv, String pluginsOption, String otherOptions, File protoRoot) throws IOException {
        String s;
        String[] separateArguments;
        ArrayList<String> cmdLineParametersList = new ArrayList<String>();
        cmdLineParametersList.add(StringUtils.trim((String)exePath.toString()));
        cmdLineParametersList.add(StringUtils.trim((String)command));
        cmdLineParametersList.add("--lockdir=" + this.lockDir);
        cmdLineParametersList.add("--protoroot=" + protoRoot.getAbsolutePath());
        if (!StringUtils.trim((String)pluginsOption).isEmpty()) {
            for (String arg : separateArguments = StringUtils.split((String)StringUtils.trim((String)pluginsOption), (String)" ")) {
                cmdLineParametersList.add(arg);
            }
        }
        if (!StringUtils.trim((String)otherOptions).isEmpty()) {
            for (String arg : separateArguments = StringUtils.split((String)StringUtils.trim((String)otherOptions), (String)" ")) {
                cmdLineParametersList.add(arg);
            }
        }
        CharSequence[] cmdLineParameters = cmdLineParametersList.toArray(new String[0]);
        this.getLog().info((CharSequence)("protolock cmd line: " + String.join((CharSequence)" ", cmdLineParameters)));
        Process protolockProcess = Runtime.getRuntime().exec((String[])cmdLineParameters, new String[]{pathEnv}, this.project.getBasedir());
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(protolockProcess.getInputStream()));
        while ((s = stdInput.readLine()) != null) {
            this.getLog().info((CharSequence)s);
        }
        return protolockProcess;
    }

    private Artifact createDependencyArtifact(String artifactSpec) throws MojoExecutionException {
        String[] parts = artifactSpec.split(":");
        if (parts.length < 3 || parts.length > 5) {
            throw new MojoExecutionException("Invalid artifact specification format, expected: groupId:artifactId:version[:type[:classifier]], actual: " + artifactSpec);
        }
        String type = parts.length >= 4 ? parts[3] : "exe";
        String classifier = parts.length == 5 ? parts[4] : null;
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = parts[2];
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        dependency.setType(type);
        dependency.setClassifier(classifier);
        dependency.setScope("runtime");
        return this.repositorySystem.createDependencyArtifact(dependency);
    }

    private File resolveBinaryArtifact(Artifact artifact) throws MojoExecutionException {
        ArtifactResolutionResult result;
        try {
            ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(this.project.getArtifact()).setResolveRoot(false).setResolveTransitively(false).setArtifactDependencies(Collections.singleton(artifact)).setManagedVersionMap(Collections.emptyMap()).setLocalRepository(this.localRepository).setRemoteRepositories(this.remoteRepositories).setOffline(this.session.isOffline()).setForceUpdate(this.session.getRequest().isUpdateSnapshots()).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies());
            result = this.repositorySystem.resolve(request);
            this.resolutionErrorHandler.throwErrors(request, result);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        Set artifacts = result.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            throw new MojoExecutionException("Unable to resolve artifact");
        }
        Artifact resolvedBinaryArtifact = (Artifact)artifacts.iterator().next();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Resolved artifact: " + resolvedBinaryArtifact));
        }
        File sourceFile = resolvedBinaryArtifact.getFile();
        String sourceFileName = sourceFile.getName();
        String targetFileName = Os.isFamily((String)"windows") && !sourceFileName.endsWith(".exe") ? sourceFileName + ".exe" : sourceFileName;
        File targetFile = new File(this.protolockPluginDirectory, targetFileName);
        if (targetFile.exists()) {
            this.getLog().debug((CharSequence)("Executable file already exists: " + targetFile.getAbsolutePath()));
            return targetFile;
        }
        try {
            FileUtils.forceMkdir((File)this.protolockPluginDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create directory " + this.protolockPluginDirectory, (Exception)e);
        }
        try {
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy the file to " + this.protolockPluginDirectory, (Exception)e);
        }
        if (!Os.isFamily((String)"windows")) {
            targetFile.setExecutable(true);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Executable file: " + targetFile.getAbsolutePath()));
        }
        return targetFile;
    }
}

