/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.ProjectAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Project;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.StreamSupport;

public class JAXRSAnalyzer {
    private final Analysis analysis;

    public JAXRSAnalyzer(Analysis analysis) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(analysis.projectClassPaths);
        Objects.requireNonNull(analysis.projectSourcePaths);
        Objects.requireNonNull(analysis.classPaths);
        Objects.requireNonNull(analysis.projectName);
        Objects.requireNonNull(analysis.projectVersion);
        Objects.requireNonNull(analysis.backend);
        if (analysis.projectClassPaths.isEmpty()) {
            throw new IllegalArgumentException("At least one project path is mandatory");
        }
        this.analysis = analysis;
    }

    public void analyze() {
        Resources resources = new ProjectAnalyzer(this.analysis.classPaths).analyze(this.analysis.projectClassPaths, this.analysis.projectSourcePaths, this.analysis.ignoredResources);
        if (resources.isEmpty()) {
            LogProvider.info("Empty JAX-RS analysis result, omitting output");
            return;
        }
        Project project = new Project(this.analysis.projectName, this.analysis.projectVersion, resources);
        byte[] output = this.analysis.backend.render(project);
        if (this.analysis.outputLocation != null) {
            JAXRSAnalyzer.outputToFile(output, this.analysis.outputLocation);
        } else {
            this.outputToConsole(output);
        }
    }

    private void outputToConsole(byte[] output) {
        try {
            System.out.write(output);
            System.out.flush();
        }
        catch (IOException e) {
            LogProvider.error("Could not write the output, reason: " + e.getMessage());
            LogProvider.debug(e);
        }
    }

    private static void outputToFile(byte[] output, Path outputLocation) {
        try (FileOutputStream stream = new FileOutputStream(outputLocation.toFile());){
            ((OutputStream)stream).write(output);
            stream.flush();
        }
        catch (IOException e) {
            LogProvider.error("Could not write to the specified output location, reason: " + e.getMessage());
            LogProvider.debug(e);
        }
    }

    public static Backend constructBackend(String backendType) {
        ServiceLoader<Backend> backends = ServiceLoader.load(Backend.class);
        return StreamSupport.stream(backends.spliterator(), false).filter(b -> backendType.equalsIgnoreCase(b.getName())).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown backend type " + backendType));
    }

    public static class Analysis {
        private final Set<Path> projectClassPaths = new HashSet<Path>();
        private final Set<Path> projectSourcePaths = new HashSet<Path>();
        private final Set<Path> classPaths = new HashSet<Path>();
        private final Set<String> ignoredResources = new HashSet<String>();
        private String projectName;
        private String projectVersion;
        private Path outputLocation;
        private Backend backend;

        public Set<Path> getProjectClassPaths() {
            return this.projectClassPaths;
        }

        public void addProjectClassPath(Path classPath) {
            this.projectClassPaths.add(classPath);
        }

        public void addProjectSourcePath(Path sourcePath) {
            this.projectSourcePaths.add(sourcePath);
        }

        public void addClassPath(Path classPath) {
            this.classPaths.add(classPath);
        }

        public void addIgnoredResource(String ignored) {
            this.ignoredResources.add(ignored);
        }

        public void configureBackend(Map<String, String> attributes) {
            if (this.backend != null) {
                this.backend.configure(attributes);
            }
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public void setProjectVersion(String projectVersion) {
            this.projectVersion = projectVersion;
        }

        public void setOutputLocation(Path outputLocation) {
            this.outputLocation = outputLocation;
        }

        public void setBackend(Backend backend) {
            this.backend = backend;
        }

        public Backend getBackend() {
            return this.backend;
        }
    }
}

