/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation;

import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodSimulator;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.IntStream;

public class InjectableArgumentMethodSimulator
extends MethodSimulator {
    private static final List<MethodIdentifier> EXECUTED_PATH_METHODS = Collections.synchronizedList(new LinkedList());
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element simulate(List<Element> arguments, List<Instruction> instructions, MethodIdentifier identifier) {
        if (EXECUTED_PATH_METHODS.contains(identifier)) {
            return new Element();
        }
        this.lock.lock();
        EXECUTED_PATH_METHODS.add(identifier);
        try {
            this.injectArguments(arguments, identifier);
            Element element = this.simulateInternal(instructions);
            return element;
        }
        finally {
            EXECUTED_PATH_METHODS.remove(identifier);
            this.lock.unlock();
        }
    }

    private void injectArguments(List<Element> arguments, MethodIdentifier identifier) {
        boolean staticMethod = identifier.isStaticMethod();
        int startIndex = staticMethod ? 0 : 1;
        int endIndex = staticMethod ? arguments.size() - 1 : arguments.size();
        IntStream.rangeClosed(startIndex, endIndex).forEach(i -> this.localVariables.put(i, (Element)arguments.get(staticMethod ? i : i - 1)));
    }
}

