/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.classes;

import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.annotation.DefaultValueAnnotationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.annotation.ParamAnnotationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ParameterType;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;

class JAXRSFieldVisitor
extends FieldVisitor {
    private final ClassResult classResult;
    private final String signature;
    private MethodParameter parameter;

    JAXRSFieldVisitor(ClassResult classResult, String desc, String signature) {
        super(327680);
        this.classResult = classResult;
        this.signature = signature == null ? desc : signature;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        switch (desc) {
            case "Ljavax/ws/rs/PathParam;": {
                return this.paramAnnotationVisitor(ParameterType.PATH);
            }
            case "Ljavax/ws/rs/QueryParam;": {
                return this.paramAnnotationVisitor(ParameterType.QUERY);
            }
            case "Ljavax/ws/rs/HeaderParam;": {
                return this.paramAnnotationVisitor(ParameterType.HEADER);
            }
            case "Ljavax/ws/rs/FormParam;": {
                return this.paramAnnotationVisitor(ParameterType.FORM);
            }
            case "Ljavax/ws/rs/CookieParam;": {
                return this.paramAnnotationVisitor(ParameterType.COOKIE);
            }
            case "Ljavax/ws/rs/MatrixParam;": {
                return this.paramAnnotationVisitor(ParameterType.MATRIX);
            }
            case "Ljavax/ws/rs/DefaultValue;": {
                return this.defaultAnnotationVisitor();
            }
        }
        return null;
    }

    private AnnotationVisitor paramAnnotationVisitor(ParameterType parameterType) {
        if (this.parameter == null) {
            this.parameter = new MethodParameter(TypeIdentifier.ofType(this.signature), parameterType);
        } else {
            this.parameter.setParameterType(parameterType);
        }
        return new ParamAnnotationVisitor(this.parameter);
    }

    private AnnotationVisitor defaultAnnotationVisitor() {
        if (this.parameter == null) {
            this.parameter = new MethodParameter(TypeIdentifier.ofType(this.signature));
        }
        return new DefaultValueAnnotationVisitor(this.parameter);
    }

    @Override
    public void visitEnd() {
        if (this.parameter != null) {
            this.classResult.getClassFields().add(this.parameter);
        }
    }
}

