/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.javadoc.ClassComment;
import com.sebastian_daschner.jaxrs_analyzer.model.javadoc.MemberParameterTag;
import com.sebastian_daschner.jaxrs_analyzer.model.javadoc.MethodComment;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ParameterType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

final class JavaDocParameterResolver {
    private static final String[] KNOWN_ANNOTATIONS = new String[]{"Ljavax/ws/rs/PathParam;", "Ljavax/ws/rs/QueryParam;", "Ljavax/ws/rs/HeaderParam;", "Ljavax/ws/rs/FormParam;", "Ljavax/ws/rs/CookieParam;", "Ljavax/ws/rs/MatrixParam;", "Ljavax/ws/rs/DefaultValue;", "Ljavax/ws/rs/container/Suspended;", "Ljavax/ws/rs/core/Context;"};

    private JavaDocParameterResolver() {
        throw new UnsupportedOperationException();
    }

    static Optional<MemberParameterTag> findParameterDoc(MethodParameter parameter, MethodComment methodDoc) {
        return methodDoc.getParamTags().stream().filter(p -> JavaDocParameterResolver.hasAnnotation(parameter, p.getAnnotations())).findAny();
    }

    static Optional<MemberParameterTag> findFieldDoc(MethodParameter parameter, ClassComment classDoc) {
        if (classDoc == null) {
            return Optional.empty();
        }
        return classDoc.getFieldComments().stream().filter(f -> JavaDocParameterResolver.hasAnnotation(parameter, f.getAnnotations())).findAny();
    }

    static Optional<MemberParameterTag> findRequestBodyDoc(MethodComment methodDoc) {
        return methodDoc.getParamTags().stream().filter(p -> JavaDocParameterResolver.isRequestBody(p.getAnnotations())).findAny();
    }

    private static boolean hasAnnotation(MethodParameter parameter, Map<String, String> annotations) {
        return annotations.entrySet().stream().filter(e -> JavaDocParameterResolver.annotationTypeMatches((String)e.getKey(), parameter.getParameterType())).anyMatch(e -> Objects.equals(e.getValue(), parameter.getName()));
    }

    private static boolean isRequestBody(Map<String, String> annotations) {
        return annotations.entrySet().stream().noneMatch(e -> JavaDocParameterResolver.findKnownAnnotation((String)e.getKey()));
    }

    private static boolean findKnownAnnotation(String simpleTypeName) {
        return Stream.of(KNOWN_ANNOTATIONS).anyMatch(a -> a.contains(simpleTypeName));
    }

    private static boolean annotationTypeMatches(String qualifiedTypeName, ParameterType parameterType) {
        String javaType = JavaDocParameterResolver.getJavaType(parameterType);
        return javaType != null && javaType.contains(qualifiedTypeName);
    }

    private static String getJavaType(ParameterType parameterType) {
        switch (parameterType) {
            case PATH: {
                return JavaUtils.toReadableType("Ljavax/ws/rs/PathParam;");
            }
            case QUERY: {
                return JavaUtils.toReadableType("Ljavax/ws/rs/QueryParam;");
            }
            case HEADER: {
                return JavaUtils.toReadableType("Ljavax/ws/rs/HeaderParam;");
            }
            case FORM: {
                return JavaUtils.toReadableType("Ljavax/ws/rs/FormParam;");
            }
            case MATRIX: {
                return JavaUtils.toReadableType("Ljavax/ws/rs/MatrixParam;");
            }
            case COOKIE: {
                return JavaUtils.toReadableType("Ljavax/ws/rs/CookieParam;");
            }
        }
        return null;
    }
}

