/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend.markdown;

import com.sebastian_daschner.jaxrs_analyzer.backend.ComparatorUtils;
import com.sebastian_daschner.jaxrs_analyzer.backend.StringBackend;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ParameterType;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ResourceMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Response;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import com.sebastian_daschner.jaxrs_analyzer.utils.StringUtils;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;

public class MarkdownBackend
extends StringBackend {
    private static final String NAME = "Markdown";
    private static final String DOCUMENT_TITLE = "# REST resources of ";
    private static final String TYPE_WILDCARD = "\\*/*";

    @Override
    protected void appendMethod(String baseUri, String resource, ResourceMethod resourceMethod) {
        this.builder.append("## `").append((Object)resourceMethod.getMethod()).append(' ');
        if (!StringUtils.isBlank(baseUri)) {
            this.builder.append(baseUri).append('/');
        }
        this.builder.append(resource).append("`\n\n");
        if (!StringUtils.isBlank(resourceMethod.getDescription())) {
            this.builder.append("### Description: ").append(resourceMethod.getDescription()).append("\n\n");
        }
        if (resourceMethod.isDeprecated()) {
            this.builder.append("CAUTION: deprecated\n\n");
        }
    }

    @Override
    protected void appendRequest(ResourceMethod resourceMethod) {
        this.builder.append("### Request\n");
        if (resourceMethod.getRequestBody() != null) {
            this.builder.append("*Content-Type*: `");
            this.builder.append(resourceMethod.getRequestMediaTypes().isEmpty() ? TYPE_WILDCARD : MarkdownBackend.toString(resourceMethod.getRequestMediaTypes()));
            this.builder.append("` + \n");
            this.builder.append("*Request Body*: (").append(this.toTypeOrCollection(resourceMethod.getRequestBody())).append(")");
            Optional.ofNullable(this.resources.getTypeRepresentations().get(resourceMethod.getRequestBody())).ifPresent(this::generateSample);
            this.builder.append("\n");
        } else {
            this.builder.append("_No body_ + \n");
        }
        Set<MethodParameter> parameters = resourceMethod.getMethodParameters();
        this.appendParams("Path Param", parameters, ParameterType.PATH);
        this.appendParams("Query Param", parameters, ParameterType.QUERY);
        this.appendParams("Form Param", parameters, ParameterType.FORM);
        this.appendParams("Header Param", parameters, ParameterType.HEADER);
        this.appendParams("Cookie Param", parameters, ParameterType.COOKIE);
        this.appendParams("Matrix Param", parameters, ParameterType.MATRIX);
        this.builder.append('\n');
    }

    private void appendParams(String name, Set<MethodParameter> parameters, ParameterType parameterType) {
        parameters.stream().filter(p -> p.getParameterType() == parameterType).sorted(ComparatorUtils.parameterComparator()).forEach(p -> this.builder.append('*').append(name).append("*: `").append(p.getName()).append("`, `").append(JavaUtils.toReadableType(p.getType().getType())).append("` + \n"));
    }

    @Override
    protected void appendResponse(ResourceMethod resourceMethod) {
        this.builder.append("### Response\n");
        this.builder.append("*Content-Type*: `");
        this.builder.append(resourceMethod.getResponseMediaTypes().isEmpty() ? TYPE_WILDCARD : MarkdownBackend.toString(resourceMethod.getResponseMediaTypes()));
        this.builder.append("`\n\n");
        resourceMethod.getResponses().entrySet().stream().sorted(ComparatorUtils.mapKeyComparator()).forEach(e -> {
            this.builder.append("#### `").append(e.getKey()).append(' ').append(Response.Status.fromStatusCode((Integer)e.getKey()).getReasonPhrase()).append("`\n");
            Response response = (Response)e.getValue();
            response.getHeaders().forEach(h -> this.builder.append("*Header*: `").append((String)h).append("` + \n"));
            if (response.getResponseBody() != null) {
                this.builder.append("*Response Body*: ").append('(').append(this.toTypeOrCollection(response.getResponseBody())).append(")");
                Optional.ofNullable(this.resources.getTypeRepresentations().get(response.getResponseBody())).ifPresent(this::generateSample);
                this.builder.append("\n");
            }
            this.builder.append('\n');
        });
    }

    private void generateSample(TypeRepresentation r) {
        this.builder.append("\n\n```javascript\n");
        this.builder.append(this.doVisit(r));
        this.builder.append("\n```\n\n");
    }

    private String toTypeOrCollection(TypeIdentifier type) {
        TypeRepresentation representation = this.resources.getTypeRepresentations().get(type);
        if (representation != null && !representation.getComponentType().equals(type) && !type.getType().equals("Ljavax/json/Json;")) {
            return "Collection of `" + this.toReadableComponentType(representation.getComponentType()) + '`';
        }
        return '`' + JavaUtils.toReadableType(type.getType()) + '`';
    }

    private static String toString(Set<String> set) {
        return set.stream().sorted().map(Object::toString).collect(Collectors.joining(", "));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void appendFirstLine() {
        this.builder.append(DOCUMENT_TITLE).append(this.projectName).append("\n\n");
    }
}

