/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend.swagger;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerScheme;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonPatch;

public class SwaggerOptions {
    public static final String DOMAIN = "domain";
    public static final String SWAGGER_SCHEMES = "swaggerSchemes";
    public static final String RENDER_SWAGGER_TAGS = "renderSwaggerTags";
    public static final String SWAGGER_TAGS_PATH_OFFSET = "swaggerTagsPathOffset";
    public static final String JSON_PATCH = "jsonPatch";
    private static final String DEFAULT_DOMAIN = "";
    private static final Set<SwaggerScheme> DEFAULT_SCHEMES = EnumSet.of(SwaggerScheme.HTTP);
    private static final boolean DEFAULT_RENDER_TAGS = false;
    private static final int DEFAULT_TAGS_PATH_OFFSET = 0;
    private String domain = "";
    private Set<SwaggerScheme> schemes = DEFAULT_SCHEMES;
    private boolean renderTags = false;
    private int tagsPathOffset = 0;
    private JsonPatch jsonPatch;

    String getDomain() {
        return this.domain;
    }

    Set<SwaggerScheme> getSchemes() {
        return this.schemes;
    }

    boolean isRenderTags() {
        return this.renderTags;
    }

    int getTagsPathOffset() {
        return this.tagsPathOffset;
    }

    JsonPatch getJsonPatch() {
        return this.jsonPatch;
    }

    void configure(Map<String, String> config) {
        if (config.containsKey(SWAGGER_TAGS_PATH_OFFSET)) {
            int swaggerTagsPathOffset = Integer.parseInt(config.get(SWAGGER_TAGS_PATH_OFFSET));
            if (swaggerTagsPathOffset < 0) {
                System.err.println("Please provide positive integer number for option --swaggerTagsPathOffset\n");
                throw new IllegalArgumentException("Please provide positive integer number for option --swaggerTagsPathOffset");
            }
            this.tagsPathOffset = swaggerTagsPathOffset;
        }
        if (config.containsKey(DOMAIN)) {
            this.domain = config.get(DOMAIN);
        }
        if (config.containsKey(SWAGGER_SCHEMES)) {
            this.schemes = this.extractSwaggerSchemes(config.get(SWAGGER_SCHEMES));
        }
        if (config.containsKey(RENDER_SWAGGER_TAGS)) {
            this.renderTags = Boolean.parseBoolean(config.get(RENDER_SWAGGER_TAGS));
        }
        if (config.containsKey(JSON_PATCH)) {
            this.jsonPatch = SwaggerOptions.readPatch(config.get(JSON_PATCH));
        }
    }

    private Set<SwaggerScheme> extractSwaggerSchemes(String schemes) {
        return Stream.of(schemes.split(",")).map(this::extractSwaggerScheme).collect(() -> EnumSet.noneOf(SwaggerScheme.class), Set::add, Set::addAll);
    }

    private SwaggerScheme extractSwaggerScheme(String scheme) {
        switch (scheme.toLowerCase()) {
            case "http": {
                return SwaggerScheme.HTTP;
            }
            case "https": {
                return SwaggerScheme.HTTPS;
            }
            case "ws": {
                return SwaggerScheme.WS;
            }
            case "wss": {
                return SwaggerScheme.WSS;
            }
        }
        throw new IllegalArgumentException("Unknown swagger scheme " + scheme);
    }

    private static JsonPatch readPatch(String patchFile) {
        try {
            JsonArray patchArray = Json.createReader(Files.newBufferedReader(Paths.get(patchFile, new String[0]))).readArray();
            return Json.createPatchBuilder(patchArray).build();
        }
        catch (Exception e) {
            LogProvider.error("Could not read JSON patch from the specified location, reason: " + e.getMessage());
            LogProvider.error("Patch won't be applied");
            LogProvider.debug(e);
            return null;
        }
    }
}

