/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.elements;

import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodPool;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.Method;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MethodHandle
extends Element
implements Method {
    private final Set<MethodIdentifier> possibleIdentifiers = new HashSet<MethodIdentifier>();
    private final List<Element> transferredArguments = new LinkedList<Element>();

    public MethodHandle(String returnType, MethodIdentifier handleIdentifier, List<Element> transferredArguments) {
        super(returnType, new Object[0]);
        this.possibleIdentifiers.add(handleIdentifier);
        this.transferredArguments.addAll(transferredArguments);
    }

    public MethodHandle(MethodHandle methodHandle) {
        super(methodHandle.getTypes(), new Object[0]);
        this.possibleIdentifiers.addAll(methodHandle.possibleIdentifiers);
        this.transferredArguments.addAll(methodHandle.transferredArguments);
    }

    public Set<MethodIdentifier> getPossibleIdentifiers() {
        return this.possibleIdentifiers;
    }

    public List<Element> getTransferredArguments() {
        return this.transferredArguments;
    }

    @Override
    public Element invoke(Element unused, List<Element> arguments) {
        List combinedArguments = Stream.concat(this.transferredArguments.stream(), arguments.stream()).collect(Collectors.toList());
        return this.possibleIdentifiers.stream().map(i -> {
            Method method = MethodPool.getInstance().get((MethodIdentifier)i);
            if (!i.isStaticMethod()) {
                Element object;
                ArrayList<Element> actualArguments = new ArrayList<Element>(combinedArguments);
                Element element = object = actualArguments.isEmpty() ? new Element() : (Element)actualArguments.remove(0);
                if (JavaUtils.isInitializerName(i.getMethodName())) {
                    return new Element(i.getContainingClass(), new Object[0]);
                }
                return method.invoke(object, actualArguments);
            }
            return method.invoke(null, combinedArguments);
        }).filter(Objects::nonNull).reduce(Element::merge).orElse(null);
    }

    @Override
    public Element merge(Element element) {
        super.merge(element);
        if (element instanceof MethodHandle) {
            MethodHandle methodHandle = (MethodHandle)element;
            this.possibleIdentifiers.addAll(methodHandle.possibleIdentifiers);
            IntStream.range(0, Math.max(this.transferredArguments.size(), methodHandle.transferredArguments.size())).forEach(i -> {
                if (this.transferredArguments.size() < i && methodHandle.transferredArguments.size() < i) {
                    this.transferredArguments.get(i).merge(methodHandle.transferredArguments.get(i));
                }
            });
        }
        return this;
    }

    @Override
    public String toString() {
        return "MethodHandle{possibleIdentifiers=" + this.possibleIdentifiers + "transferredArguments=" + this.transferredArguments + ", type='" + this.getTypes() + '\'' + '}';
    }
}

