/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2.Directives;

import com.shapesecurity.salvation2.Constants;
import com.shapesecurity.salvation2.Directive;
import com.shapesecurity.salvation2.Policy;
import com.shapesecurity.salvation2.Values.Host;
import com.shapesecurity.salvation2.Values.Scheme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public abstract class HostSourceDirective
extends Directive {
    protected List<Scheme> schemes = new ArrayList<Scheme>();
    protected List<Host> hosts = new ArrayList<Host>();
    protected boolean star = false;
    protected boolean self = false;
    protected String none = null;

    protected HostSourceDirective(List<String> values) {
        super(values);
    }

    @Override
    protected void addValue(String value) {
        if (this.none != null) {
            super.removeValueIgnoreCase("'none'");
            this.none = null;
        }
        super.addValue(value);
    }

    @Override
    protected void removeValueIgnoreCase(String value) {
        super.removeValueIgnoreCase(value);
        if (this.values.isEmpty()) {
            this.values.add("'none'");
            this.none = "'none'";
        }
    }

    protected <T> void removeValuesMatching(T value, Function<String, Optional<T>> parser) {
        ArrayList<String> copy = new ArrayList<String>(this.values.size());
        for (String existing : this.values) {
            Optional<T> parsed = parser.apply(existing);
            if (parsed.isPresent() && parsed.get().equals(value)) continue;
            copy.add(existing);
        }
        this.values = copy;
        if (this.values.isEmpty()) {
            this.values.add("'none'");
            this.none = "'none'";
        }
    }

    void _addHostOrSchemeDuringConstruction(String token, String lowcaseToken, String kind, int index, Directive.DirectiveErrorConsumer errors) {
        if (lowcaseToken.equals("'none'")) {
            if (this.none == null) {
                this.none = token;
            }
        } else if (lowcaseToken.equals("*")) {
            if (!this.star) {
                this.star = true;
            } else {
                errors.add(Policy.Severity.Warning, "Duplicate " + kind + " *", index);
            }
        } else if (lowcaseToken.equals("'self'")) {
            if (!this.self) {
                this.self = true;
            } else {
                errors.add(Policy.Severity.Warning, "Duplicate " + kind + " 'self'", index);
            }
        } else {
            Optional<Scheme> asScheme = Scheme.parseScheme(token);
            if (asScheme.isPresent()) {
                this._addScheme(asScheme.get(), index, errors);
            } else {
                Optional<Host> asHost;
                if (Constants.unquotedKeywordPattern.matcher(token).find()) {
                    errors.add(Policy.Severity.Warning, "This host name is unusual, and likely meant to be a keyword that is missing the required quotes: '" + token + "'.", index);
                }
                if ((asHost = Host.parseHost(token)).isPresent()) {
                    this._addHostSource(asHost.get(), index, errors);
                } else {
                    errors.add(Policy.Severity.Error, "Unrecognized " + kind + " " + token, index);
                }
            }
        }
    }

    private boolean _addScheme(Scheme scheme, int index, Directive.DirectiveErrorConsumer errors) {
        if (this.schemes.contains(scheme)) {
            errors.add(Policy.Severity.Warning, "Duplicate scheme " + scheme, index);
            return false;
        }
        this.schemes.add(scheme);
        return true;
    }

    private boolean _addHostSource(Host source, int index, Directive.DirectiveErrorConsumer errors) {
        if (this.hosts.contains(source)) {
            errors.add(Policy.Severity.Warning, "Duplicate host " + source.toString(), index);
            return false;
        }
        this.hosts.add(source);
        return true;
    }

    public boolean star() {
        return this.star;
    }

    public void setStar(boolean star) {
        if (this.star == star) {
            return;
        }
        if (star) {
            this.addValue("*");
        } else {
            this.removeValueIgnoreCase("*");
        }
        this.star = star;
    }

    public boolean self() {
        return this.self;
    }

    public void setSelf(boolean self) {
        if (this.self == self) {
            return;
        }
        if (self) {
            this.addValue("'self'");
        } else {
            this.removeValueIgnoreCase("'self'");
        }
        this.self = self;
    }

    public List<Scheme> getSchemes() {
        return Collections.unmodifiableList(this.schemes);
    }

    public void addScheme(Scheme scheme, Directive.ManipulationErrorConsumer errors) {
        if (this._addScheme(scheme, -1, HostSourceDirective.wrapManipulationErrorConsumer(errors))) {
            this.addValue(scheme.toString());
        }
    }

    public boolean removeScheme(Scheme scheme) {
        if (!this.schemes.contains(scheme)) {
            return false;
        }
        this.schemes.remove(scheme);
        this.removeValueIgnoreCase(scheme.toString());
        return true;
    }

    public List<Host> getHosts() {
        return Collections.unmodifiableList(this.hosts);
    }

    public void addHost(Host host, Directive.ManipulationErrorConsumer errors) {
        if (host.equals(Host.STAR)) {
            if (this.star) {
                errors.add(Directive.ManipulationErrorConsumer.Severity.Warning, "Duplicate host *");
            } else {
                this.star = true;
                this.addValue("*");
            }
            return;
        }
        if (this._addHostSource(host, -1, HostSourceDirective.wrapManipulationErrorConsumer(errors))) {
            this.addValue(host.toString());
        }
    }

    public boolean removeHost(Host host) {
        if (host.equals(Host.STAR)) {
            if (this.star) {
                this.setStar(false);
                return true;
            }
            return false;
        }
        if (!this.hosts.contains(host)) {
            return false;
        }
        this.hosts.remove(host);
        this.removeValuesMatching(host, Host::parseHost);
        return true;
    }
}

