/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.signalflow;

import com.signalfx.shaded.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class StreamMessage {
    private String event;
    private String id;
    private String data;
    private Kind kind;

    public StreamMessage() {
        this.event = "message";
        this.kind = Kind.INFORMATION;
    }

    public StreamMessage(String event, String id, String data) {
        this.event = event;
        this.id = id;
        this.data = data;
        try {
            this.kind = Kind.fromSpecName(event);
        }
        catch (IllegalArgumentException ex) {
            this.kind = Kind.INFORMATION;
        }
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean isKind(Kind kind) {
        return this.kind == kind;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.event);
        builder.append(":");
        builder.append(this.id);
        builder.append(":");
        builder.append(this.data);
        return builder.toString();
    }

    public static enum Kind {
        CONTROL("control-message", 1),
        INFORMATION("message", 2),
        EVENT("event", 3),
        METADATA("metadata", 4),
        DATA("data", 5),
        ERROR("error", 6),
        EXPIRED_TSID("expired-tsid", 10);

        private final String specName;
        private final byte type;
        private static final Map<String, Kind> SPECNAME_KINDS;
        private static final Map<Integer, Kind> BINARYTYPE_KINDS;

        private Kind(String specName, byte type) {
            this.specName = specName;
            this.type = type;
        }

        public byte getBinaryType() {
            return this.type;
        }

        public String toString() {
            return this.specName;
        }

        public static Kind fromSpecName(String specName) {
            Kind kind = SPECNAME_KINDS.get(specName);
            Preconditions.checkArgument(kind != null);
            return kind;
        }

        public static Kind fromBinaryType(int binaryType) {
            Kind kind = BINARYTYPE_KINDS.get(binaryType);
            Preconditions.checkArgument(kind != null);
            return kind;
        }

        static {
            SPECNAME_KINDS = new HashMap<String, Kind>();
            BINARYTYPE_KINDS = new HashMap<Integer, Kind>();
            for (Kind kind : Kind.values()) {
                SPECNAME_KINDS.put(kind.specName, kind);
                BINARYTYPE_KINDS.put(new Integer(kind.getBinaryType()), kind);
            }
        }
    }
}

