/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.AndroidTestRunListener;
import com.simpligility.maven.plugins.android.DeviceCallback;
import com.simpligility.maven.plugins.android.InstrumentationArgumentParser;
import com.simpligility.maven.plugins.android.ScreenshotServiceWrapper;
import com.simpligility.maven.plugins.android.asm.AndroidTestFinder;
import com.simpligility.maven.plugins.android.common.DeviceHelper;
import com.simpligility.maven.plugins.android.configuration.Test;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractInstrumentationMojo
extends AbstractAndroidMojo {
    @Parameter(property="maven.test.skip", defaultValue="false", readonly=true)
    private boolean mavenTestSkip;
    @Parameter(property="skipTests", defaultValue="false", readonly=true)
    private boolean mavenSkipTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false", readonly=true)
    private boolean mavenIgnoreTestFailure;
    @Parameter(property="maven.test.error.ignore", defaultValue="false", readonly=true)
    private boolean mavenIgnoreTestError;
    @Parameter
    private Test test;
    @Parameter(property="android.test.skip", defaultValue="auto")
    private String testSkip;
    @Parameter(property="android.test.failsafe", defaultValue="true")
    private Boolean testFailSafe;
    @Parameter(property="android.test.instrumentationPackage")
    private String testInstrumentationPackage;
    @Parameter(property="android.test.instrumentationRunner")
    private String testInstrumentationRunner;
    @Parameter(property="android.test.debug", defaultValue="false")
    private Boolean testDebug;
    @Parameter(property="android.test.coverage", defaultValue="false")
    private Boolean testCoverage;
    @Parameter(property="android.test.coverageFile")
    private String testCoverageFile;
    @Parameter(property="android.test.logonly", defaultValue="false")
    private Boolean testLogOnly;
    @Parameter(property="android.test.testsize")
    private String testTestSize;
    @Parameter(property="android.test.createreport", defaultValue="true")
    private Boolean testCreateReport;
    @Parameter(property="android.test.packages")
    protected List<String> testPackages;
    @Parameter(property="android.test.classes")
    protected List<String> testClasses;
    @Parameter(property="android.test.annotations")
    protected List<String> testAnnotations;
    @Parameter(property="android.test.excludeAnnotations")
    protected List<String> testExcludeAnnotations;
    @Parameter(property="android.test.instrumentationArgs")
    protected List<String> testInstrumentationArgs;
    private boolean classesExists;
    private boolean packagesExists;
    private String parsedSkip;
    private String parsedInstrumentationPackage;
    private String parsedInstrumentationRunner;
    private List<String> parsedClasses;
    private List<String> parsedPackages;
    private List<String> parsedAnnotations;
    private List<String> parsedExcludeAnnotations;
    private Map<String, String> parsedInstrumentationArgs;
    private String parsedTestSize;
    private Boolean parsedCoverage;
    private String parsedCoverageFile;
    private Boolean parsedDebug;
    private Boolean parsedLogOnly;
    private Boolean parsedCreateReport;
    private String packagesList;

    protected void instrument() throws MojoExecutionException, MojoFailureException {
        this.parseConfiguration();
        if (this.parsedInstrumentationPackage == null) {
            this.parsedInstrumentationPackage = this.extractPackageNameFromAndroidManifest(this.destinationManifestFile);
        }
        if (this.parsedInstrumentationRunner == null) {
            this.parsedInstrumentationRunner = this.extractInstrumentationRunnerFromAndroidManifest(this.destinationManifestFile);
        }
        this.packagesList = AbstractInstrumentationMojo.buildCommaSeparatedString(this.parsedPackages);
        this.packagesExists = StringUtils.isNotBlank((CharSequence)this.packagesList);
        this.classesExists = this.parsedClasses != null ? this.parsedClasses.size() > 0 : false;
        if (this.classesExists && this.packagesExists) {
            throw new MojoFailureException("packages and classes are mutually exclusive. They cannot be specified at the same time. Please specify either packages or classes. For details, see http://developer.android.com/guide/developing/testing/testing_otheride.html");
        }
        DeviceCallback instrumentationTestExecutor = new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException, MojoFailureException {
                String deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
                RemoteAndroidTestRunner remoteAndroidTestRunner = new RemoteAndroidTestRunner(AbstractInstrumentationMojo.this.parsedInstrumentationPackage, AbstractInstrumentationMojo.this.parsedInstrumentationRunner, (IShellEnabledDevice)device);
                if (AbstractInstrumentationMojo.this.packagesExists) {
                    for (String str : AbstractInstrumentationMojo.this.packagesList.split(",")) {
                        remoteAndroidTestRunner.setTestPackageName(str);
                        AbstractInstrumentationMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Running tests for specified test package: " + (String)str));
                    }
                }
                if (AbstractInstrumentationMojo.this.classesExists) {
                    remoteAndroidTestRunner.setClassNames(AbstractInstrumentationMojo.this.parsedClasses.toArray(new String[AbstractInstrumentationMojo.this.parsedClasses.size()]));
                    AbstractInstrumentationMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Running tests for specified test classes/methods: " + AbstractInstrumentationMojo.this.parsedClasses));
                }
                if (AbstractInstrumentationMojo.this.parsedAnnotations != null) {
                    for (String annotation : AbstractInstrumentationMojo.this.parsedAnnotations) {
                        remoteAndroidTestRunner.addInstrumentationArg("annotation", annotation);
                    }
                }
                if (AbstractInstrumentationMojo.this.parsedExcludeAnnotations != null) {
                    for (String annotation : AbstractInstrumentationMojo.this.parsedExcludeAnnotations) {
                        remoteAndroidTestRunner.addInstrumentationArg("notAnnotation", annotation);
                    }
                }
                remoteAndroidTestRunner.setDebug(AbstractInstrumentationMojo.this.parsedDebug.booleanValue());
                remoteAndroidTestRunner.setCoverage(AbstractInstrumentationMojo.this.parsedCoverage.booleanValue());
                if (StringUtils.isNotBlank((CharSequence)AbstractInstrumentationMojo.this.parsedCoverageFile)) {
                    remoteAndroidTestRunner.addInstrumentationArg("coverageFile", AbstractInstrumentationMojo.this.parsedCoverageFile);
                }
                remoteAndroidTestRunner.setLogOnly(AbstractInstrumentationMojo.this.parsedLogOnly.booleanValue());
                if (StringUtils.isNotBlank((CharSequence)AbstractInstrumentationMojo.this.parsedTestSize)) {
                    IRemoteAndroidTestRunner.TestSize validSize = IRemoteAndroidTestRunner.TestSize.getTestSize((String)AbstractInstrumentationMojo.this.parsedTestSize);
                    remoteAndroidTestRunner.setTestSize(validSize);
                }
                AbstractInstrumentationMojo.this.addAllInstrumentationArgs(remoteAndroidTestRunner, AbstractInstrumentationMojo.this.parsedInstrumentationArgs);
                AbstractInstrumentationMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Running instrumentation tests in " + AbstractInstrumentationMojo.this.parsedInstrumentationPackage));
                try {
                    AndroidTestRunListener testRunListener = new AndroidTestRunListener(device, AbstractInstrumentationMojo.this.getLog(), AbstractInstrumentationMojo.this.parsedCreateReport, false, "", "", AbstractInstrumentationMojo.this.targetDirectory);
                    remoteAndroidTestRunner.run(new ITestRunListener[]{testRunListener});
                    if (testRunListener.hasFailuresOrErrors() && !AbstractInstrumentationMojo.this.testFailSafe.booleanValue()) {
                        throw new MojoFailureException(deviceLogLinePrefix + "Tests failed on device.");
                    }
                    if (testRunListener.testRunFailed() && !AbstractInstrumentationMojo.this.testFailSafe.booleanValue()) {
                        throw new MojoFailureException(deviceLogLinePrefix + "Test run failed to complete: " + testRunListener.getTestRunFailureCause());
                    }
                    if (testRunListener.threwException() && !AbstractInstrumentationMojo.this.testFailSafe.booleanValue()) {
                        throw new MojoFailureException(deviceLogLinePrefix + testRunListener.getExceptionMessages());
                    }
                }
                catch (TimeoutException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "timeout", (Exception)((Object)e));
                }
                catch (AdbCommandRejectedException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "adb command rejected", (Exception)((Object)e));
                }
                catch (ShellCommandUnresponsiveException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "shell command unresponsive", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "IO problem", (Exception)e);
                }
            }
        };
        instrumentationTestExecutor = new ScreenshotServiceWrapper(instrumentationTestExecutor, this.project, this.getLog());
        this.doWithDevices(instrumentationTestExecutor);
    }

    private void addAllInstrumentationArgs(RemoteAndroidTestRunner remoteAndroidTestRunner, Map<String, String> parsedInstrumentationArgs) {
        for (Map.Entry<String, String> entry : parsedInstrumentationArgs.entrySet()) {
            remoteAndroidTestRunner.addInstrumentationArg(entry.getKey(), entry.getValue());
        }
    }

    private void parseConfiguration() {
        if (this.test != null) {
            this.parsedSkip = StringUtils.isNotEmpty((CharSequence)this.test.getSkip()) ? this.test.getSkip() : this.testSkip;
            this.parsedInstrumentationPackage = StringUtils.isNotEmpty((CharSequence)this.test.getInstrumentationPackage()) ? this.test.getInstrumentationPackage() : this.testInstrumentationPackage;
            this.parsedInstrumentationRunner = StringUtils.isNotEmpty((CharSequence)this.test.getInstrumentationRunner()) ? this.test.getInstrumentationRunner() : this.testInstrumentationRunner;
            this.parsedClasses = this.test.getClasses() != null && !this.test.getClasses().isEmpty() ? this.test.getClasses() : this.testClasses;
            this.parsedAnnotations = this.test.getAnnotations() != null && !this.test.getAnnotations().isEmpty() ? this.test.getAnnotations() : this.testAnnotations;
            this.parsedExcludeAnnotations = this.test.getExcludeAnnotations() != null && !this.test.getExcludeAnnotations().isEmpty() ? this.test.getExcludeAnnotations() : this.testExcludeAnnotations;
            this.parsedPackages = this.test.getPackages() != null && !this.test.getPackages().isEmpty() ? this.test.getPackages() : this.testPackages;
            this.parsedTestSize = StringUtils.isNotEmpty((CharSequence)this.test.getTestSize()) ? this.test.getTestSize() : this.testTestSize;
            this.parsedCoverage = this.test.isCoverage() != null ? this.test.isCoverage() : this.testCoverage;
            this.parsedCoverageFile = this.test.getCoverageFile() != null ? this.test.getCoverageFile() : "";
            this.parsedDebug = this.test.isDebug() != null ? this.test.isDebug() : this.testDebug;
            this.parsedLogOnly = this.test.isLogOnly() != null ? this.test.isLogOnly() : this.testLogOnly;
            this.parsedCreateReport = this.test.isCreateReport() != null ? this.test.isCreateReport() : this.testCreateReport;
            this.parsedInstrumentationArgs = InstrumentationArgumentParser.parse(this.test.getInstrumentationArgs());
        } else {
            this.parsedSkip = this.testSkip;
            this.parsedInstrumentationPackage = this.testInstrumentationPackage;
            this.parsedInstrumentationRunner = this.testInstrumentationRunner;
            this.parsedClasses = this.testClasses;
            this.parsedAnnotations = this.testAnnotations;
            this.parsedExcludeAnnotations = this.testExcludeAnnotations;
            this.parsedPackages = this.testPackages;
            this.parsedTestSize = this.testTestSize;
            this.parsedCoverage = this.testCoverage;
            this.parsedCoverageFile = this.testCoverageFile;
            this.parsedDebug = this.testDebug;
            this.parsedLogOnly = this.testLogOnly;
            this.parsedCreateReport = this.testCreateReport;
            this.parsedInstrumentationArgs = InstrumentationArgumentParser.parse(this.testInstrumentationArgs);
        }
    }

    protected boolean isEnableIntegrationTest() throws MojoFailureException, MojoExecutionException {
        this.parseConfiguration();
        if (this.mavenTestSkip) {
            this.getLog().info((CharSequence)"maven.test.skip set - skipping tests");
            return false;
        }
        if (this.mavenSkipTests) {
            this.getLog().info((CharSequence)"maven.skip.tests set - skipping tests");
            return false;
        }
        if ("true".equalsIgnoreCase(this.parsedSkip)) {
            this.getLog().info((CharSequence)"android.test.skip set - skipping tests");
            return false;
        }
        if ("false".equalsIgnoreCase(this.parsedSkip)) {
            return true;
        }
        if (this.parsedSkip == null || "auto".equalsIgnoreCase(this.parsedSkip)) {
            if (this.extractInstrumentationRunnerFromAndroidManifest(this.destinationManifestFile) == null) {
                this.getLog().info((CharSequence)"No InstrumentationRunner found - skipping tests");
                return false;
            }
            return AndroidTestFinder.containsAndroidTests(this.projectOutputDirectory);
        }
        throw new MojoFailureException("android.test.skip must be configured as 'true', 'false' or 'auto'.");
    }

    protected static String buildCommaSeparatedString(List<String> lines) {
        if (lines == null || lines.size() == 0) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>(lines.size());
        for (String str : lines) {
            if (!StringUtils.isNotBlank((CharSequence)str)) continue;
            strings.add(StringUtils.trimToEmpty((String)str));
        }
        return StringUtils.join(strings, (String)",");
    }
}

