/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.common;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class AaptCommandBuilder {
    protected final List<String> commands;
    protected final Log log;

    protected AaptCommandBuilder(Log log) {
        this.log = log;
        this.commands = new ArrayList<String>();
    }

    public static AaptPackageCommandBuilder packageResources(Log log) {
        return new AaptPackageCommandBuilder(log);
    }

    public static final AaptDumpCommandBuilder dump(Log log) {
        return new AaptDumpCommandBuilder(log);
    }

    public String toString() {
        return this.commands.toString();
    }

    public List<String> build() {
        return Collections.unmodifiableList(this.commands);
    }

    public static final class AaptDumpCommandBuilder
    extends AaptCommandBuilder {
        public AaptDumpCommandBuilder(Log log) {
            super(log);
            this.commands.add("dump");
        }

        public AaptDumpCommandBuilder xmlTree() {
            this.commands.add("xmltree");
            return this;
        }

        public AaptDumpCommandBuilder setPathToApk(String pathToApk) {
            this.commands.add(pathToApk);
            return this;
        }

        public AaptDumpCommandBuilder addAssetFile(String assetFile) {
            this.commands.add(assetFile);
            return this;
        }
    }

    public static final class AaptPackageCommandBuilder
    extends AaptCommandBuilder {
        public AaptPackageCommandBuilder(Log log) {
            super(log);
            this.commands.add("package");
        }

        public AaptPackageCommandBuilder makeResourcesNonConstant() {
            return this.makeResourcesNonConstant(true);
        }

        public AaptPackageCommandBuilder makeResourcesNonConstant(boolean make) {
            if (make) {
                this.log.debug((CharSequence)"Adding non-constant-id");
                this.commands.add("--non-constant-id");
            }
            return this;
        }

        public AaptPackageCommandBuilder makePackageDirectories() {
            this.commands.add("-m");
            return this;
        }

        public AaptPackageCommandBuilder setResourceConstantsFolder(File path) {
            this.commands.add("-J");
            this.commands.add(path.getAbsolutePath());
            return this;
        }

        public AaptPackageCommandBuilder generateRIntoPackage(String packageName) {
            if (StringUtils.isNotBlank((CharSequence)packageName)) {
                this.commands.add("--custom-package");
                this.commands.add(packageName);
            }
            return this;
        }

        public AaptPackageCommandBuilder setPathToAndroidManifest(File path) {
            this.commands.add("-M");
            this.commands.add(path.getAbsolutePath());
            return this;
        }

        public AaptPackageCommandBuilder addResourceDirectoryIfExists(File resourceDirectory) {
            if (resourceDirectory != null && resourceDirectory.exists()) {
                this.commands.add("-S");
                this.commands.add(resourceDirectory.getAbsolutePath());
            }
            return this;
        }

        public AaptPackageCommandBuilder addResourceDirectoriesIfExists(List<File> resourceDirectories) {
            if (resourceDirectories != null) {
                for (File resourceDirectory : resourceDirectories) {
                    this.addResourceDirectoryIfExists(resourceDirectory);
                }
            }
            return this;
        }

        public AaptPackageCommandBuilder addResourceDirectoriesIfExists(File[] resourceDirectories) {
            if (resourceDirectories != null) {
                for (File resourceDirectory : resourceDirectories) {
                    this.addResourceDirectoryIfExists(resourceDirectory);
                }
            }
            return this;
        }

        public AaptPackageCommandBuilder autoAddOverlay() {
            this.commands.add("--auto-add-overlay");
            return this;
        }

        public AaptPackageCommandBuilder addRawAssetsDirectoryIfExists(File assetsFolder) {
            if (assetsFolder != null && assetsFolder.exists()) {
                this.log.debug((CharSequence)("Adding assets folder : " + assetsFolder));
                this.commands.add("-A");
                this.commands.add(assetsFolder.getAbsolutePath());
            }
            return this;
        }

        public AaptPackageCommandBuilder addExistingPackageToBaseIncludeSet(File path) {
            this.commands.add("-I");
            this.commands.add(path.getAbsolutePath());
            return this;
        }

        public AaptPackageCommandBuilder addConfigurations(String configurations) {
            if (StringUtils.isNotBlank((CharSequence)configurations)) {
                this.commands.add("-c");
                this.commands.add(configurations);
            }
            return this;
        }

        public AaptPackageCommandBuilder addExtraArguments(String[] extraArguments) {
            if (extraArguments != null) {
                this.commands.addAll(Arrays.asList(extraArguments));
            }
            return this;
        }

        public AaptPackageCommandBuilder setVerbose(boolean isVerbose) {
            if (isVerbose) {
                this.commands.add("-v");
            }
            return this;
        }

        public AaptPackageCommandBuilder generateRTextFile(File folderForR) {
            this.commands.add("--output-text-symbols");
            this.commands.add(folderForR.getAbsolutePath());
            return this;
        }

        public AaptPackageCommandBuilder forceOverwriteExistingFiles() {
            this.commands.add("-f");
            return this;
        }

        public AaptPackageCommandBuilder disablePngCrunching() {
            this.commands.add("--no-crunch");
            return this;
        }

        public AaptPackageCommandBuilder setOutputApkFile(File outputFile) {
            this.commands.add("-F");
            this.commands.add(outputFile.getAbsolutePath());
            return this;
        }

        public AaptPackageCommandBuilder setProguardOptionsOutputFile(File outputFile) {
            if (outputFile != null) {
                File parentFolder = outputFile.getParentFile();
                if (parentFolder != null) {
                    parentFolder.mkdirs();
                }
                this.log.debug((CharSequence)("Adding proguard file : " + outputFile));
                this.commands.add("-G");
                this.commands.add(outputFile.getAbsolutePath());
            }
            return this;
        }

        public AaptPackageCommandBuilder renameManifestPackage(String manifestPackage) {
            if (StringUtils.isNotBlank((CharSequence)manifestPackage)) {
                this.commands.add("--rename-manifest-package");
                this.commands.add(manifestPackage);
            }
            return this;
        }

        public AaptPackageCommandBuilder renameInstrumentationTargetPackage(String instrumentationPackage) {
            if (StringUtils.isNotBlank((CharSequence)instrumentationPackage)) {
                this.commands.add("--rename-instrumentation-target-package");
                this.commands.add(instrumentationPackage);
            }
            return this;
        }

        public AaptPackageCommandBuilder setDebugMode(boolean isDebugMode) {
            if (isDebugMode) {
                this.log.info((CharSequence)"Generating debug apk.");
                this.commands.add("--debug-mode");
            } else {
                this.log.info((CharSequence)"Generating release apk.");
            }
            return this;
        }
    }
}

