/*-
 * Copyright (C) 2002, 2018, Oracle and/or its affiliates. All rights reserved.
 *
 * This file was distributed by Oracle as part of a version of Oracle Berkeley
 * DB Java Edition made available at:
 *
 * http://www.oracle.com/technetwork/database/database-technologies/berkeleydb/downloads/index.html
 *
 * Please see the LICENSE file included in the top-level directory of the
 * appropriate version of Oracle Berkeley DB Java Edition for a copy of the
 * license and additional information.
 */

package com.sleepycat.persist.impl;

import com.sleepycat.persist.raw.RawObject;

import java.util.IdentityHashMap;

/**
 * Extends RawAbstractInput to convert array (ObjectArrayFormat and
 * PrimitiveArrayteKeyFormat) RawObject instances.
 *
 * @author Mark Hayes
 */
class RawArrayInput extends RawAbstractInput {

    private Object[] array;
    private int index;
    private Format componentFormat;

    RawArrayInput(Catalog catalog,
                  boolean rawAccess,
                  IdentityHashMap converted,
                  RawObject raw,
                  Format componentFormat) {
        super(catalog, rawAccess, converted);
        array = raw.getElements();
        this.componentFormat = componentFormat;
    }

    @Override
    public int readArrayLength() {
        return array.length;
    }

    @Override
    Object readNext()
        throws RefreshException {

        Object o = array[index++];
        return checkAndConvert(o, componentFormat);
    }
}
