/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.ExtinctionFilter;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;

public abstract class SecondaryReferenceException
extends OperationFailureException {
    private static final long serialVersionUID = 1L;
    private final String secDbName;
    private final String priDbName;
    private final DatabaseEntry secKey;
    private final DatabaseEntry priKey;
    private final long priLsn;
    private final long expirationTime;

    public SecondaryReferenceException(Locker locker, String message, String secDbName, String priDbName, DatabaseEntry secKey, DatabaseEntry priKey, long priLsn, long expirationTime, ExtinctionFilter.ExtinctionStatus extinctionStatus) {
        super(locker, true, message, null);
        this.priDbName = priDbName;
        this.secDbName = secDbName;
        this.secKey = secKey;
        this.priKey = priKey;
        this.priLsn = priLsn;
        this.expirationTime = expirationTime;
        this.addErrorMessage("secDbName=" + secDbName + " priDbName=" + priDbName + " expiration=" + (expirationTime != 0L ? TTL.formatExpirationTime(expirationTime) : "none") + (extinctionStatus != null ? " " + (Object)((Object)extinctionStatus) : "") + " priLsn=" + DbLsn.getNoFormatString(priLsn));
        if (locker.getEnvironment().getExposeUserData()) {
            this.addErrorMessage("priKey=" + (priKey != null ? priKey.toString() : "unknown") + " secKey=" + (secKey != null ? secKey.toString() : "unknown"));
        }
    }

    SecondaryReferenceException(String message, SecondaryReferenceException cause) {
        super(message, cause);
        this.priDbName = cause.priDbName;
        this.secDbName = cause.secDbName;
        this.secKey = cause.secKey;
        this.priKey = cause.priKey;
        this.priLsn = cause.priLsn;
        this.expirationTime = cause.expirationTime;
    }

    public String getSecondaryDatabaseName() {
        return this.secDbName;
    }

    public String getPrimaryDatabaseName() {
        return this.priDbName;
    }

    public DatabaseEntry getSecondaryKey() {
        return this.secKey;
    }

    public DatabaseEntry getPrimaryKey() {
        return this.priKey;
    }

    public long getPrimaryLsn() {
        return this.priLsn;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }
}

