/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.utilint.VLSN;
import java.util.HashSet;
import java.util.Set;

public class ReservedFileInfo {
    public final VLSN firstVLSN;
    public final VLSN lastVLSN;
    public final Set<DatabaseId> dbIds;

    ReservedFileInfo(VLSN firstVLSN, VLSN lastVLSN, Set<DatabaseId> dbIds) {
        this.firstVLSN = firstVLSN;
        this.lastVLSN = lastVLSN;
        this.dbIds = dbIds;
    }

    public static Long entryToKey(DatabaseEntry entry) {
        return LongBinding.entryToLong(entry);
    }

    public static void keyToEntry(Long key, DatabaseEntry entry) {
        LongBinding.longToEntry(key, entry);
    }

    public static ReservedFileInfo entryToObject(DatabaseEntry entry) {
        TupleInput input = TupleBase.entryToInput(entry);
        input.readByte();
        VLSN firstVLSN = new VLSN(input.readPackedLong());
        VLSN lastVLSN = new VLSN(input.readPackedLong());
        HashSet<DatabaseId> dbIds = new HashSet<DatabaseId>();
        int nDbs = input.readPackedInt();
        for (int i = 0; i < nDbs; ++i) {
            dbIds.add(new DatabaseId(input.readPackedLong()));
        }
        return new ReservedFileInfo(firstVLSN, lastVLSN, dbIds);
    }

    public static void objectToEntry(ReservedFileInfo info, DatabaseEntry entry) {
        TupleOutput output = new TupleOutput();
        output.writeByte(0);
        output.writePackedLong(info.firstVLSN.getSequence());
        output.writePackedLong(info.lastVLSN.getSequence());
        output.writePackedInt(info.dbIds.size());
        for (DatabaseId id : info.dbIds) {
            output.writePackedLong(id.getId());
        }
        TupleBase.outputToEntry(output, entry);
    }
}

