/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.utilint.TestHook;

class Arbiter {
    private final MemoryBudget.Totals memBudgetTotals;
    private TestHook<Boolean> runnableHook;
    private final long evictBytesSetting;

    Arbiter(EnvironmentImpl envImpl) {
        DbConfigManager configManager = envImpl.getConfigManager();
        this.evictBytesSetting = configManager.getLong(EnvironmentParams.EVICTOR_EVICT_BYTES);
        this.memBudgetTotals = envImpl.getMemoryBudget().getTotals();
    }

    boolean isOverBudget() {
        return this.memBudgetTotals.getCacheUsage() > this.memBudgetTotals.getMaxMemory();
    }

    boolean needCriticalEviction() {
        long over = this.memBudgetTotals.getCacheUsage() - this.memBudgetTotals.getMaxMemory();
        return over > this.memBudgetTotals.getCriticalThreshold();
    }

    boolean stillNeedsEviction() {
        return this.memBudgetTotals.getCacheUsage() + this.evictBytesSetting > this.memBudgetTotals.getMaxMemory();
    }

    long getEvictionPledge() {
        long maxMem;
        long currentUsage = this.memBudgetTotals.getCacheUsage();
        long overBudget = currentUsage - (maxMem = this.memBudgetTotals.getMaxMemory());
        boolean doRun = overBudget > 0L;
        long requiredEvictBytes = 0L;
        if (doRun && currentUsage - (requiredEvictBytes = overBudget + this.evictBytesSetting) < maxMem / 2L) {
            requiredEvictBytes = overBudget + maxMem / 2L;
        }
        if (this.runnableHook != null) {
            doRun = this.runnableHook.getHookValue();
            requiredEvictBytes = doRun ? maxMem : 0L;
        }
        return requiredEvictBytes;
    }

    void setRunnableHook(TestHook<Boolean> hook) {
        this.runnableHook = hook;
    }
}

