/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.VersionedWriteLoggable;
import com.sleepycat.je.log.entry.BaseReplicableEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.VersionedLN;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;

public class LNLogEntry<T extends LN>
extends BaseReplicableEntry<T> {
    private static final byte ABORT_KD_MASK = 1;
    private static final byte EMBEDDED_LN_MASK = 2;
    private static final byte HAVE_ABORT_KEY_MASK = 4;
    private static final byte HAVE_ABORT_DATA_MASK = 8;
    private static final byte HAVE_ABORT_VLSN_MASK = 16;
    private static final byte HAVE_ABORT_LSN_MASK = 32;
    private static final byte HAVE_ABORT_EXPIRATION_MASK = 64;
    private static final byte HAVE_EXPIRATION_MASK = -128;
    private static final byte HAVE_PRIOR_SIZE_MASK = 1;
    private static final byte HAVE_PRIOR_FILE_MASK = 2;
    public static final int MIN_LOG_SIZE = 18;
    private static final int LAST_FORMAT_CHANGE = 16;
    private DatabaseId dbId;
    private Txn txn;
    private long abortLsn = -1L;
    private boolean abortKnownDeleted;
    private byte[] abortKey = null;
    private byte[] abortData = null;
    private long abortVLSN = -1L;
    private int abortExpiration = 0;
    private boolean abortExpirationInHours = false;
    private boolean haveAbortLSN;
    private boolean haveAbortKey;
    private boolean haveAbortData;
    private boolean haveAbortVLSN;
    private boolean haveAbortExpiration;
    private boolean haveExpiration;
    private boolean havePriorSize;
    private boolean havePriorFile;
    private boolean embeddedLN;
    private LN ln;
    private byte[] key;
    private int expiration;
    private boolean expirationInHours;
    private int priorSize;
    private long priorFile = 0xFFFFFFFFL;
    private DupStatus dupStatus;
    private final Constructor<VersionedLN> versionedLNConstructor;

    public static <T extends LN> LNLogEntry<T> create(Class<T> cls) {
        return new LNLogEntry<T>(cls);
    }

    LNLogEntry(Class<T> cls) {
        super(cls);
        this.versionedLNConstructor = cls == LN.class ? LNLogEntry.getNoArgsConstructor(VersionedLN.class) : null;
    }

    public LNLogEntry(LogEntryType entryType, DatabaseId dbId, Txn txn, long abortLsn, boolean abortKD, byte[] abortKey, byte[] abortData, long abortVLSN, int abortExpiration, boolean abortExpirationInHours, byte[] key, T ln, boolean embeddedLN, int expiration, boolean expirationInHours, int priorSize, long priorLsn) {
        this.setLogType(entryType);
        this.dbId = dbId;
        this.txn = txn;
        this.abortLsn = abortLsn;
        this.abortKnownDeleted = abortKD;
        this.abortKey = abortKey;
        this.abortData = abortData;
        this.abortVLSN = abortVLSN;
        this.abortExpiration = abortExpiration;
        this.abortExpirationInHours = abortExpirationInHours;
        this.haveAbortLSN = abortLsn != -1L;
        this.haveAbortKey = abortKey != null;
        this.haveAbortData = abortData != null;
        this.haveAbortVLSN = !VLSN.isNull(abortVLSN);
        this.haveAbortExpiration = abortExpiration != 0;
        this.haveExpiration = expiration != 0;
        this.embeddedLN = embeddedLN;
        this.key = key;
        this.ln = ln;
        this.expiration = expiration;
        this.expirationInHours = expirationInHours;
        this.priorSize = priorSize;
        this.havePriorSize = priorSize != 0;
        if (this.havePriorSize == (priorLsn == -1L)) {
            throw EnvironmentFailureException.unexpectedState("priorSize=" + priorSize + " priorLsn=" + DbLsn.getNoFormatString(priorLsn));
        }
        this.priorFile = !this.havePriorSize || priorLsn == abortLsn ? 0xFFFFFFFFL : DbLsn.getFileNumber(priorLsn);
        this.havePriorFile = this.priorFile != 0xFFFFFFFFL;
        this.versionedLNConstructor = null;
        assert (entryType.isTransactional() == (txn != null));
    }

    private void reset() {
        this.dbId = null;
        this.txn = null;
        this.abortLsn = -1L;
        this.abortKnownDeleted = false;
        this.abortKey = null;
        this.abortData = null;
        this.abortVLSN = -1L;
        this.abortExpiration = 0;
        this.abortExpirationInHours = false;
        this.haveAbortLSN = false;
        this.haveAbortKey = false;
        this.haveAbortData = false;
        this.haveAbortVLSN = false;
        this.haveAbortExpiration = false;
        this.haveExpiration = false;
        this.havePriorSize = false;
        this.havePriorFile = false;
        this.embeddedLN = false;
        this.key = null;
        this.ln = null;
        this.expiration = 0;
        this.expirationInHours = false;
        this.priorSize = 0;
        this.priorFile = 0xFFFFFFFFL;
        this.dupStatus = null;
    }

    @Override
    public void readEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer) {
        assert (this.getClass() == LNLogEntry.class);
        boolean keyIsLastSerializedField = header.getVersion() >= 8 || this.entryType.isUserLNType();
        this.readBaseLNEntry(envImpl, header, entryBuffer, keyIsLastSerializedField);
    }

    final void readBaseLNEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer, boolean keyIsLastSerializedField) {
        this.reset();
        int logVersion = header.getVersion();
        boolean unpacked = logVersion < 6;
        int recStartPosition = entryBuffer.position();
        if (logVersion >= 12) {
            byte flags = entryBuffer.get();
            byte flags2 = logVersion >= 16 ? entryBuffer.get() : (byte)0;
            this.setFlags(flags, flags2);
        }
        if (logVersion < 6) {
            this.ln = this.newLNInstance(envImpl);
            this.ln.readFromLog(entryBuffer, logVersion);
        }
        this.dbId = new DatabaseId();
        this.dbId.readFromLog(entryBuffer, logVersion);
        if (logVersion < 6) {
            this.key = LogUtils.readByteArray(entryBuffer, true);
        }
        if (this.entryType.isTransactional()) {
            if (this.haveAbortLSN || logVersion < 12) {
                this.abortLsn = LogUtils.readLong(entryBuffer, unpacked);
                if (DbLsn.getFileNumber(this.abortLsn) == DbLsn.getFileNumber(-1L)) {
                    this.abortLsn = -1L;
                }
            }
            if (logVersion < 12) {
                this.setFlags(entryBuffer.get(), (byte)0);
                this.haveAbortLSN = this.abortLsn != -1L;
            }
            this.txn = new Txn();
            this.txn.readFromLog(entryBuffer, logVersion);
        } else if (logVersion == 11) {
            this.setFlags(entryBuffer.get(), (byte)0);
        }
        if (logVersion >= 11) {
            if (this.haveAbortKey) {
                this.abortKey = LogUtils.readByteArray(entryBuffer, false);
            }
            if (this.haveAbortData) {
                this.abortData = LogUtils.readByteArray(entryBuffer, false);
            }
            if (this.haveAbortVLSN) {
                this.abortVLSN = LogUtils.readPackedLong(entryBuffer);
            }
        }
        if (logVersion >= 12) {
            if (this.haveAbortExpiration) {
                this.abortExpiration = LogUtils.readPackedInt(entryBuffer);
                if (this.abortExpiration < 0) {
                    this.abortExpiration = -this.abortExpiration;
                    this.abortExpirationInHours = true;
                }
            }
            if (this.haveExpiration) {
                this.expiration = LogUtils.readPackedInt(entryBuffer);
                if (this.expiration < 0) {
                    this.expiration = -this.expiration;
                    this.expirationInHours = true;
                }
            }
        }
        if (logVersion >= 16) {
            if (this.havePriorSize) {
                this.priorSize = LogUtils.readPackedInt(entryBuffer);
            }
            if (this.havePriorFile) {
                this.priorFile = LogUtils.readPackedLong(entryBuffer);
            }
        }
        if (logVersion >= 6) {
            int keySize;
            this.ln = this.newLNInstance(envImpl);
            this.ln.readFromLog(entryBuffer, logVersion);
            if (keyIsLastSerializedField) {
                int bytesWritten = entryBuffer.position() - recStartPosition;
                keySize = header.getItemSize() - bytesWritten;
            } else {
                keySize = LogUtils.readPackedInt(entryBuffer);
            }
            this.key = LogUtils.readBytesNoLength(entryBuffer, keySize);
        }
        if (header.getVLSN() != null) {
            this.ln.setVLSNSequence(header.getVLSN().getSequence());
        }
        this.dupStatus = logVersion < 8 ? DupStatus.NEED_CONVERSION : DupStatus.UNKNOWN;
    }

    private void setFlags(byte flags, byte flags2) {
        this.embeddedLN = (flags & 2) != 0;
        this.abortKnownDeleted = (flags & 1) != 0;
        this.haveAbortLSN = (flags & 0x20) != 0;
        this.haveAbortKey = (flags & 4) != 0;
        this.haveAbortData = (flags & 8) != 0;
        this.haveAbortVLSN = (flags & 0x10) != 0;
        this.haveAbortExpiration = (flags & 0x40) != 0;
        this.haveExpiration = (flags & 0xFFFFFF80) != 0;
        this.havePriorSize = (flags2 & 1) != 0;
        this.havePriorFile = (flags2 & 2) != 0;
    }

    @Override
    public boolean hasReplicationFormat() {
        return true;
    }

    @Override
    public boolean isReplicationFormatWorthwhile(ByteBuffer logBuffer, int srcVersion, int destVersion) {
        if (destVersion < 11) {
            return false;
        }
        if (srcVersion < 12) {
            return false;
        }
        byte flags = logBuffer.get(0);
        return (flags & 0xC) != 0;
    }

    LN newLNInstance(EnvironmentImpl envImpl) {
        if (this.versionedLNConstructor != null && envImpl.getPreserveVLSN()) {
            return LNLogEntry.newInstanceOfType(this.versionedLNConstructor);
        }
        return (LN)this.newInstanceOfType();
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        this.dbId.dumpLog(sb, verbose);
        this.ln.dumpKey(sb, this.key);
        this.ln.dumpLog(sb, verbose);
        sb.append("<embeddedLN val=\"");
        sb.append(this.embeddedLN);
        sb.append("\"/>");
        if (this.haveExpiration) {
            sb.append("<expires val=\"");
            sb.append(TTL.formatExpiration(this.expiration, this.expirationInHours));
            sb.append("\"/>");
        }
        if (this.havePriorSize || this.havePriorFile) {
            sb.append("<prior size=\"");
            sb.append(this.priorSize);
            sb.append("\" file=\"");
            sb.append(this.priorFile);
            sb.append("\"/>");
        }
        if (this.entryType.isTransactional()) {
            this.txn.dumpLog(sb, verbose);
            sb.append("<abortLSN val=\"");
            sb.append(DbLsn.getNoFormatString(this.abortLsn));
            sb.append("\"/>");
            sb.append("<abortKD val=\"");
            sb.append(this.abortKnownDeleted ? "true" : "false");
            sb.append("\"/>");
            if (this.haveAbortKey) {
                sb.append(Key.dumpString(this.abortKey, "abortKey", 0));
            }
            if (this.haveAbortData) {
                sb.append(Key.dumpString(this.abortData, "abortData", 0));
            }
            if (this.haveAbortVLSN) {
                sb.append("<abortVLSN v=\"");
                sb.append(this.abortVLSN);
                sb.append("\"/>");
            }
            if (this.haveAbortExpiration) {
                sb.append("<abortExpires val=\"");
                sb.append(TTL.formatExpiration(this.abortExpiration, this.abortExpirationInHours));
                sb.append("\"/>");
            }
        }
        return sb;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
        if (this.entryType.isTransactional()) {
            sb.append(" txn=").append(this.txn.getId());
        }
    }

    @Override
    public LN getMainItem() {
        return this.ln;
    }

    @Override
    public long getTransactionId() {
        if (this.entryType.isTransactional()) {
            return this.txn.getId();
        }
        return 0L;
    }

    @Override
    public int getLastFormatChange() {
        return 16;
    }

    @Override
    public Collection<VersionedWriteLoggable> getEmbeddedLoggables() {
        return Arrays.asList(new LN(), new DatabaseId(), new Txn());
    }

    @Override
    public int getSize(int logVersion, boolean forReplication) {
        assert (this.getClass() == LNLogEntry.class);
        return this.getBaseLNEntrySize(logVersion, true, forReplication);
    }

    final int getBaseLNEntrySize(int logVersion, boolean keyIsLastSerializedField, boolean forReplication) {
        int size = this.ln.getLogSize(logVersion, forReplication) + this.dbId.getLogSize(logVersion, forReplication) + this.key.length;
        if (!keyIsLastSerializedField) {
            size += LogUtils.getPackedIntLogSize(this.key.length);
        }
        if (this.entryType.isTransactional() || logVersion >= 11) {
            ++size;
        }
        if (logVersion >= 16) {
            ++size;
        }
        if (this.entryType.isTransactional()) {
            if (logVersion < 12 || this.haveAbortLSN && !forReplication) {
                size += LogUtils.getPackedLongLogSize(this.abortLsn);
            }
            size += this.txn.getLogSize(logVersion, forReplication);
        }
        if (!forReplication) {
            if (logVersion >= 11) {
                if (this.haveAbortKey) {
                    size += LogUtils.getByteArrayLogSize(this.abortKey);
                }
                if (this.haveAbortData) {
                    size += LogUtils.getByteArrayLogSize(this.abortData);
                }
                if (this.haveAbortVLSN) {
                    size += LogUtils.getPackedLongLogSize(this.abortVLSN);
                }
            }
            if (logVersion >= 12 && this.haveAbortExpiration) {
                size += LogUtils.getPackedIntLogSize(this.abortExpirationInHours ? -this.abortExpiration : this.abortExpiration);
            }
            if (logVersion >= 16) {
                if (this.havePriorSize) {
                    size += LogUtils.getPackedIntLogSize(this.priorSize);
                }
                if (this.havePriorFile) {
                    size += LogUtils.getPackedLongLogSize(this.priorFile);
                }
            }
        }
        if (logVersion >= 12 && this.haveExpiration) {
            size += LogUtils.getPackedIntLogSize(this.expirationInHours ? -this.expiration : this.expiration);
        }
        return size;
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer, int logVersion, boolean forReplication) {
        assert (this.getClass() == LNLogEntry.class);
        this.writeBaseLNEntry(destBuffer, logVersion, true, forReplication);
    }

    final void writeBaseLNEntry(ByteBuffer destBuffer, int logVersion, boolean keyIsLastSerializedField, boolean forReplication) {
        byte flags = 0;
        byte flags2 = 0;
        if (this.entryType.isTransactional() && (logVersion < 12 || !forReplication)) {
            if (this.abortKnownDeleted) {
                flags = (byte)(flags | 1);
            }
            if (this.haveAbortLSN) {
                flags = (byte)(flags | 0x20);
            }
        }
        if (!forReplication) {
            if (logVersion >= 11) {
                if (this.embeddedLN) {
                    flags = (byte)(flags | 2);
                }
                if (this.haveAbortKey) {
                    flags = (byte)(flags | 4);
                }
                if (this.haveAbortData) {
                    flags = (byte)(flags | 8);
                }
                if (this.haveAbortVLSN) {
                    flags = (byte)(flags | 0x10);
                }
            }
            if (logVersion >= 12 && this.haveAbortExpiration) {
                flags = (byte)(flags | 0x40);
            }
            if (logVersion >= 16) {
                if (this.havePriorSize) {
                    flags2 = (byte)(flags2 | 1);
                }
                if (this.havePriorFile) {
                    flags2 = (byte)(flags2 | 2);
                }
            }
        }
        if (logVersion >= 12) {
            if (this.haveExpiration) {
                flags = (byte)(flags | 0xFFFFFF80);
            }
            destBuffer.put(flags);
        }
        if (logVersion >= 16) {
            destBuffer.put(flags2);
        }
        this.dbId.writeToLog(destBuffer, logVersion, forReplication);
        if (this.entryType.isTransactional()) {
            if (logVersion < 12 || this.haveAbortLSN && !forReplication) {
                LogUtils.writePackedLong(destBuffer, this.abortLsn);
            }
            if (logVersion < 12) {
                destBuffer.put(flags);
            }
            this.txn.writeToLog(destBuffer, logVersion, forReplication);
        } else if (logVersion == 11) {
            destBuffer.put(flags);
        }
        if (!forReplication) {
            if (logVersion >= 11) {
                if (this.haveAbortKey) {
                    LogUtils.writeByteArray(destBuffer, this.abortKey);
                }
                if (this.haveAbortData) {
                    LogUtils.writeByteArray(destBuffer, this.abortData);
                }
                if (this.haveAbortVLSN) {
                    LogUtils.writePackedLong(destBuffer, this.abortVLSN);
                }
            }
            if (logVersion >= 12 && this.haveAbortExpiration) {
                LogUtils.writePackedInt(destBuffer, this.abortExpirationInHours ? -this.abortExpiration : this.abortExpiration);
            }
        }
        if (logVersion >= 12 && this.haveExpiration) {
            LogUtils.writePackedInt(destBuffer, this.expirationInHours ? -this.expiration : this.expiration);
        }
        if (!forReplication && logVersion >= 16) {
            if (this.havePriorSize) {
                LogUtils.writePackedInt(destBuffer, this.priorSize);
            }
            if (this.havePriorFile) {
                LogUtils.writePackedLong(destBuffer, this.priorFile);
            }
        }
        this.ln.writeToLog(destBuffer, logVersion, forReplication);
        if (!keyIsLastSerializedField) {
            LogUtils.writePackedInt(destBuffer, this.key.length);
        }
        LogUtils.writeBytesNoLength(destBuffer, this.key);
    }

    @Override
    public boolean isImmediatelyObsolete(DatabaseImpl dbImpl) {
        return this.ln.isDeleted() || this.embeddedLN || dbImpl.isLNImmediatelyObsolete();
    }

    @Override
    public boolean isDeleted() {
        return this.ln.isDeleted();
    }

    @Override
    public void postLogWork(LogEntryHeader header, long justLoggedLsn, VLSN vlsn) {
        if (this.entryType.isTransactional()) {
            this.txn.addLogInfo(justLoggedLsn);
        }
        if (vlsn != null) {
            this.ln.setVLSNSequence(vlsn.getSequence());
        }
    }

    @Override
    public void postFetchInit(DatabaseImpl dbImpl) {
        this.postFetchInit(dbImpl.getSortedDuplicates());
    }

    public void postFetchInit(boolean isDupDb) {
        boolean needConversion = this.dupStatus == DupStatus.NEED_CONVERSION;
        DupStatus dupStatus = this.dupStatus = isDupDb ? DupStatus.DUP_DB : DupStatus.NOT_DUP_DB;
        if (!needConversion) {
            return;
        }
        if (this.dupStatus == DupStatus.NOT_DUP_DB) {
            return;
        }
        this.key = this.combineDupKeyData();
    }

    byte[] combineDupKeyData() {
        assert (!this.ln.isDeleted());
        return DupKeyData.combine(this.key, this.ln.setEmpty());
    }

    public void getUserKeyData(DatabaseEntry keyParam, DatabaseEntry dataParam) {
        this.requireKnownDupStatus();
        if (this.dupStatus == DupStatus.DUP_DB) {
            DupKeyData.split(new DatabaseEntry(this.key), keyParam, dataParam);
        } else {
            if (keyParam != null) {
                keyParam.setData(this.key);
            }
            if (dataParam != null) {
                dataParam.setData(this.ln.getData());
            }
        }
    }

    public boolean isEmbeddedLN() {
        return this.embeddedLN;
    }

    public LN getLN() {
        this.requireKnownDupStatus();
        return this.ln;
    }

    public byte[] getKey() {
        this.requireKnownDupStatus();
        return this.key;
    }

    public byte[] getData() {
        return this.ln.getData();
    }

    public byte[] getEmbeddedData() {
        if (!this.isEmbeddedLN()) {
            return null;
        }
        if (this.ln.isDeleted()) {
            return Key.EMPTY_KEY;
        }
        return this.ln.getData();
    }

    public int getExpiration() {
        return this.expiration;
    }

    public boolean isExpirationInHours() {
        return this.expirationInHours;
    }

    private void requireKnownDupStatus() {
        if (this.dupStatus != DupStatus.DUP_DB && this.dupStatus != DupStatus.NOT_DUP_DB) {
            throw EnvironmentFailureException.unexpectedState("postFetchInit was not called");
        }
    }

    public int getUnconvertedDataLength() {
        return this.ln.getData().length;
    }

    public int getUnconvertedKeyLength() {
        return this.key.length;
    }

    @Override
    public DatabaseId getDbId() {
        return this.dbId;
    }

    public long getAbortLsn() {
        return this.abortLsn;
    }

    public boolean getAbortKnownDeleted() {
        return this.abortKnownDeleted;
    }

    public byte[] getAbortKey() {
        return this.abortKey;
    }

    public byte[] getAbortData() {
        return this.abortData;
    }

    public long getAbortVLSN() {
        return this.abortVLSN;
    }

    public boolean countPriorVersionObsolete() {
        return this.havePriorSize;
    }

    public int getPriorVersionSize() {
        if (!this.havePriorSize) {
            throw EnvironmentFailureException.unexpectedState();
        }
        return this.priorSize;
    }

    public long getPriorVersionLsn() {
        if (!this.havePriorSize) {
            throw EnvironmentFailureException.unexpectedState();
        }
        if (!this.havePriorFile && !this.haveAbortLSN) {
            throw EnvironmentFailureException.unexpectedState();
        }
        return this.havePriorFile ? DbLsn.makeLsn(this.priorFile, 0) : this.abortLsn;
    }

    public int getAbortExpiration() {
        return this.abortExpiration;
    }

    public boolean isAbortExpirationInHours() {
        return this.abortExpirationInHours;
    }

    public Long getTxnId() {
        if (this.entryType.isTransactional()) {
            return this.txn.getId();
        }
        return null;
    }

    public Txn getUserTxn() {
        if (this.entryType.isTransactional()) {
            return this.txn;
        }
        return null;
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        if (!(other instanceof LNLogEntry)) {
            return false;
        }
        LNLogEntry otherEntry = (LNLogEntry)other;
        if (!this.dbId.logicalEquals(otherEntry.dbId)) {
            return false;
        }
        if (this.txn != null ? !this.txn.logicalEquals(otherEntry.txn) : otherEntry.txn != null) {
            return false;
        }
        if (!Arrays.equals(this.key, otherEntry.key)) {
            return false;
        }
        return this.ln.logicalEquals(otherEntry.ln);
    }

    static enum DupStatus {
        UNKNOWN,
        NEED_CONVERSION,
        DUP_DB,
        NOT_DUP_DB;

    }
}

