/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.arbiter;

import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.rep.impl.RepParams;
import java.util.Properties;
import java.util.logging.Level;

public class ArbiterMutableConfig
implements Cloneable {
    Properties props;
    boolean validateParams = true;

    ArbiterMutableConfig() {
        this.props = new Properties();
    }

    ArbiterMutableConfig(Properties properties) {
        this.props = (Properties)properties.clone();
    }

    public ArbiterMutableConfig setHelperHosts(String helperHosts) {
        DbConfigManager.setVal(this.props, RepParams.HELPER_HOSTS, helperHosts, this.validateParams);
        return this;
    }

    public String getHelperHosts() {
        return DbConfigManager.getVal(this.props, RepParams.HELPER_HOSTS);
    }

    public ArbiterMutableConfig setFileLoggingLevel(String val) {
        Level.parse(val);
        DbConfigManager.setVal(this.props, EnvironmentParams.JE_FILE_LEVEL, val, false);
        return this;
    }

    public String getFileLoggingLevel() {
        return DbConfigManager.getVal(this.props, EnvironmentParams.JE_FILE_LEVEL);
    }

    public ArbiterMutableConfig setConsoleLoggingLevel(String val) {
        Level.parse(val);
        DbConfigManager.setVal(this.props, EnvironmentParams.JE_CONSOLE_LEVEL, val, false);
        return this;
    }

    public String getConsoleLoggingLevel() {
        return DbConfigManager.getVal(this.props, EnvironmentParams.JE_CONSOLE_LEVEL);
    }

    public ArbiterMutableConfig setConfigParam(String paramName, String value) throws IllegalArgumentException {
        boolean forReplication = false;
        ConfigParam param = EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
        if (param != null) {
            forReplication = param.isForReplication();
        }
        DbConfigManager.setConfigParam(this.props, paramName, value, true, true, forReplication, true);
        return this;
    }

    public String getConfigParam(String paramName) throws IllegalArgumentException {
        return DbConfigManager.getConfigParam(this.props, paramName);
    }

    protected ArbiterMutableConfig copy() {
        return new ArbiterMutableConfig(this.props);
    }

    public boolean isConfigParamSet(String paramName) {
        return this.props.containsKey(paramName);
    }

    public ArbiterMutableConfig clone() {
        try {
            ArbiterMutableConfig copy = (ArbiterMutableConfig)super.clone();
            copy.props = (Properties)this.props.clone();
            return copy;
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public Properties getProps() {
        return (Properties)this.props.clone();
    }

    public String toString() {
        return this.props.toString() + "\n";
    }
}

