/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.rep.AppStateMonitor;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationMutableConfig;
import com.sleepycat.je.rep.RollbackException;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.utilint.DatabaseUtil;
import java.io.File;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;

public class ReplicatedEnvironment
extends Environment {
    private RepImpl repImpl;
    private final NameIdPair nameIdPair;
    private ReplicationConfig handleRepConfig;

    public ReplicatedEnvironment(File envHome, ReplicationConfig repConfig, EnvironmentConfig envConfig, ReplicaConsistencyPolicy consistencyPolicy, QuorumPolicy initialElectionPolicy) throws EnvironmentNotFoundException, EnvironmentLockedException, InsufficientLogException, ReplicaConsistencyException, IllegalArgumentException {
        this(envHome, repConfig, envConfig, consistencyPolicy, initialElectionPolicy, true, null);
    }

    public ReplicatedEnvironment(File envHome, ReplicationConfig repConfig, EnvironmentConfig envConfig) throws EnvironmentNotFoundException, EnvironmentLockedException, ReplicaConsistencyException, InsufficientLogException, RollbackException, IllegalArgumentException {
        this(envHome, repConfig, envConfig, null, QuorumPolicy.SIMPLE_MAJORITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinGroup(ReplicaConsistencyPolicy consistencyPolicy, QuorumPolicy initialElectionPolicy) throws DatabaseException {
        if (this.dontJoinGroup()) {
            return;
        }
        State state = null;
        try {
            state = this.repImpl.joinGroup(consistencyPolicy, initialElectionPolicy);
        }
        finally {
            if (state == null) {
                this.repImpl.abnormalClose();
            }
        }
    }

    private boolean dontJoinGroup() {
        return new Boolean(this.getRepConfig().getConfigParam(RepParams.DONT_JOIN_REP_GROUP.getName()));
    }

    protected ReplicatedEnvironment(File envHome, ReplicationConfig repConfig, EnvironmentConfig envConfig, ReplicaConsistencyPolicy consistencyPolicy, QuorumPolicy initialElectionPolicy, boolean joinGroup, RepImpl envImplParam) throws EnvironmentNotFoundException, EnvironmentLockedException, ReplicaConsistencyException {
        super(envHome, envConfig, repConfig, envImplParam);
        this.repImpl = (RepImpl)this.envImpl;
        this.nameIdPair = this.repImpl.getNameIdPair();
        if (joinGroup) {
            try {
                this.joinGroup(consistencyPolicy, initialElectionPolicy);
            }
            catch (RollbackException e) {
                this.envImpl = this.makeEnvironmentImpl(envHome, envConfig, true, repConfig);
                this.repImpl = (RepImpl)this.envImpl;
                this.joinGroup(consistencyPolicy, initialElectionPolicy);
                this.repImpl.setHardRecoveryInfo(e);
            }
            if (this.repImpl.getRepNode() != null) {
                this.repImpl.getRepNode().getMonitorEventManager().notifyJoinGroup();
            }
        } else if (this.repImpl.getRepNode() != null) {
            throw EnvironmentFailureException.unexpectedState("An earlier handle creation had resulted in the nodejoining the group");
        }
    }

    protected RepConfigProxy setupRepConfig(File envHome, RepConfigProxy repConfigProxy, EnvironmentConfig envConfig) {
        if (envConfig.getReadOnly()) {
            throw new IllegalArgumentException("A replicated environment may not be opened read-only");
        }
        ReplicationConfig repConfig = (ReplicationConfig)repConfigProxy;
        ReplicationConfig baseConfig = repConfig == null ? ReplicationConfig.DEFAULT : repConfig;
        ReplicationConfig useConfig = baseConfig.clone();
        DbConfigManager.applyFileConfig(envHome, useConfig.getProps(), true);
        this.handleRepConfig = useConfig;
        return this.handleRepConfig;
    }

    public String getNodeName() {
        return this.nameIdPair.getName();
    }

    public State getState() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            return this.repImpl.getState();
        }
        catch (Error E) {
            this.repImpl.invalidate(E);
            throw E;
        }
    }

    public ReplicationGroup getGroup() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            return new ReplicationGroup(this.repImpl.getRepNode().getGroup());
        }
        catch (Error E) {
            this.repImpl.invalidate(E);
            throw E;
        }
    }

    public synchronized void close() throws DatabaseException {
        try {
            super.close();
        }
        catch (DatabaseException e) {
            e.addErrorMessage("Problem closing handle " + this.nameIdPair);
            throw e;
        }
        catch (Exception e) {
            throw new EnvironmentFailureException(this.repImpl, EnvironmentFailureReason.UNEXPECTED_EXCEPTION, "Problem closing handle " + this.nameIdPair, e);
        }
        catch (Error E) {
            this.repImpl.invalidate(E);
            throw E;
        }
        finally {
            this.repImpl = null;
        }
    }

    boolean isClosed() {
        return this.repImpl == null || this.repImpl.isInvalid();
    }

    public void setStateChangeListener(StateChangeListener listener) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            this.repImpl.setChangeListener(listener);
        }
        catch (Error E) {
            this.repImpl.invalidate(E);
            throw E;
        }
    }

    public StateChangeListener getStateChangeListener() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            return this.repImpl.getChangeListener();
        }
        catch (Error E) {
            this.repImpl.invalidate(E);
            throw E;
        }
    }

    public void setRepMutableConfig(ReplicationMutableConfig mutableConfig) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            DatabaseUtil.checkForNullParam(mutableConfig, "mutableConfig");
            this.repImpl.setRepMutableConfig(mutableConfig);
        }
        catch (Error E) {
            this.repImpl.invalidate(E);
            throw E;
        }
    }

    public ReplicationMutableConfig getRepMutableConfig() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            ReplicationMutableConfig config = this.repImpl.cloneRepMutableConfig();
            config.fillInEnvironmentGeneratedProps(this.repImpl);
            return config;
        }
        catch (Error E) {
            this.repImpl.invalidate(E);
            throw E;
        }
    }

    public ReplicationConfig getRepConfig() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        return this.handleRepConfig;
    }

    public ReplicatedEnvironmentStats getRepStats(StatsConfig config) throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        StatsConfig useConfig = config == null ? StatsConfig.DEFAULT : config;
        return this.repImpl.getStats(useConfig);
    }

    RepImpl getRepImpl() {
        return this.repImpl;
    }

    public void printStartupInfo(PrintStream out) {
        super.printStartupInfo(out);
        this.envImpl.getStartupTracker().displayStats(out, StartupTracker.Phase.TOTAL_JOIN_GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownGroup(long replicaShutdownTimeout, TimeUnit unit) throws IllegalStateException {
        this.checkHandleIsValid();
        this.checkEnv();
        RepImpl repImpl = this.repImpl;
        synchronized (repImpl) {
            this.repImpl.shutdownGroupSetup(unit.toMillis(replicaShutdownTimeout));
            this.close();
        }
    }

    public void registerAppStateMonitor(AppStateMonitor appStateMonitor) throws IllegalStateException {
        this.checkHandleIsValid();
        this.checkEnv();
        this.repImpl.getRepNode().registerAppStateMonitor(appStateMonitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        DETACHED,
        UNKNOWN,
        MASTER,
        REPLICA;


        public final boolean isMaster() {
            return this == MASTER;
        }

        public final boolean isReplica() {
            return this == REPLICA;
        }

        public final boolean isDetached() {
            return this == DETACHED;
        }

        public final boolean isUnknown() {
            return this == UNKNOWN;
        }

        public final boolean isActive() {
            return this == MASTER || this == REPLICA;
        }
    }
}

