/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.MasterTransferFailureException;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.ReplicaStateException;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepGroupProtocol;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupService
extends ServiceDispatcher.ExecutingService {
    final RepNode repNode;
    final RepGroupProtocol protocol;
    private final Collection<SocketChannel> activeChannels = new ArrayList<SocketChannel>();
    private final Logger logger;
    public static final String SERVICE_NAME = "Group";

    public GroupService(ServiceDispatcher dispatcher, RepNode repNode) {
        super(SERVICE_NAME, dispatcher);
        this.repNode = repNode;
        DbConfigManager configManager = repNode.getRepImpl().getConfigManager();
        String groupName = configManager.get(RepParams.GROUP_NAME);
        this.protocol = new RepGroupProtocol(groupName, repNode.getNameIdPair(), repNode.getRepImpl());
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void cancel() {
        ArrayList<SocketChannel> channels;
        GroupService groupService = this;
        synchronized (groupService) {
            channels = new ArrayList<SocketChannel>(this.activeChannels);
            this.activeChannels.clear();
        }
        if (!channels.isEmpty()) {
            LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "In-flight GroupService request(s) canceled: node shutdown");
        }
        for (SocketChannel channel : channels) {
            PrintWriter out = new PrintWriter(channel.socket().getOutputStream(), true);
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            RepGroupProtocol.Fail rm = new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.DEFAULT, "shutting down");
            out.println(rm.wireFormat());
            Object var7_8 = null;
            if (!channel.isOpen()) continue;
            try {
                channel.close();
            }
            catch (IOException e2) {
                LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "IO error on socket close: " + e2.getMessage());
            }
            continue;
            {
                catch (IOException e) {
                    LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "IO error on socket: " + e.getMessage());
                    var7_8 = null;
                    if (!channel.isOpen()) continue;
                    try {
                        channel.close();
                    }
                    catch (IOException e2) {
                        LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "IO error on socket close: " + e2.getMessage());
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var7_8 = null;
                if (channel.isOpen()) {
                    try {
                        channel.close();
                    }
                    catch (IOException e2) {
                        LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "IO error on socket close: " + e2.getMessage());
                    }
                }
                throw throwable;
            }
        }
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.GroupRequest groupRequest) {
        RepGroupImpl group = this.repNode.getGroup();
        if (group == null) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.DEFAULT, "no group info yet");
        }
        RepGroupProtocol repGroupProtocol = this.protocol;
        repGroupProtocol.getClass();
        return new RepGroupProtocol.GroupResponse(repGroupProtocol, group);
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.EnsureNode ensureNode) {
        RepNodeImpl node = ensureNode.getNode();
        try {
            this.ensureMaster();
            this.repNode.getRepGroupDB().ensureMember(node);
            RepNodeImpl enode = this.repNode.getGroup().getMember(node.getName());
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.EnsureOK(repGroupProtocol, enode.getNameIdPair());
        }
        catch (ReplicaStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.IS_REPLICA, e.getMessage());
        }
        catch (DatabaseException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.DEFAULT, e.getMessage());
        }
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.RemoveMember removeMember) {
        String nodeName = removeMember.getNodeName();
        try {
            this.ensureMaster();
            this.repNode.removeMember(nodeName);
            return new TextProtocol.OK(this.protocol);
        }
        catch (MemberNotFoundException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.MEMBER_NOT_FOUND, e.getMessage());
        }
        catch (MasterStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.IS_MASTER, e.getMessage());
        }
        catch (ReplicaStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.IS_REPLICA, e.getMessage());
        }
        catch (DatabaseException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.DEFAULT, e.getMessage());
        }
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.UpdateAddress updateAddress) {
        try {
            this.ensureMaster();
            this.repNode.updateAddress(updateAddress.getNodeName(), updateAddress.getNewHostName(), updateAddress.getNewPort());
            return new TextProtocol.OK(this.protocol);
        }
        catch (MemberNotFoundException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.MEMBER_NOT_FOUND, e.getMessage());
        }
        catch (MasterStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.IS_MASTER, e.getMessage());
        }
        catch (ReplicaStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.IS_REPLICA, e.getMessage());
        }
        catch (DatabaseException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.DEFAULT, e.getMessage());
        }
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.TransferMaster transferMaster) {
        try {
            this.ensureMaster();
            String nodeList = transferMaster.getNodeNameList();
            Set<String> replicas = this.parseNodeList(nodeList);
            long timeout = transferMaster.getTimeout();
            boolean force = transferMaster.getForceFlag();
            String winner = this.repNode.transferMaster(replicas, timeout, force);
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.TransferOK(repGroupProtocol, winner);
        }
        catch (ReplicaStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.IS_REPLICA, e.getMessage());
        }
        catch (MasterTransferFailureException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.TRANSFER_FAIL, e.getMessage());
        }
        catch (DatabaseException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.DEFAULT, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.DEFAULT, e.toString());
        }
        catch (IllegalStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.DEFAULT, e.toString());
        }
    }

    private Set<String> parseNodeList(String list) {
        HashSet<String> set = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreTokens()) {
            set.add(st.nextToken());
        }
        return set;
    }

    private void ensureMaster() throws ReplicaStateException {
        if (!this.repNode.isMaster()) {
            throw new ReplicaStateException("GroupService operation can only be performed at master");
        }
    }

    private synchronized void registerSocket(SocketChannel sc) {
        this.activeChannels.add(sc);
    }

    private synchronized boolean unregisterSocket(SocketChannel sc) {
        return this.activeChannels.remove(sc);
    }

    @Override
    public Runnable getRunnable(SocketChannel socketChannel) {
        return new GroupServiceRunnable(socketChannel, this.protocol);
    }

    class GroupServiceRunnable
    extends ServiceDispatcher.ExecutingRunnable {
        GroupServiceRunnable(SocketChannel socketChannel, RepGroupProtocol protocol) {
            super(socketChannel, protocol, true);
            GroupService.this.registerSocket(socketChannel);
        }

        protected TextProtocol.ResponseMessage getResponse(TextProtocol.RequestMessage request) throws IOException {
            TextProtocol.ResponseMessage rm = this.protocol.process(GroupService.this, request);
            return GroupService.this.unregisterSocket(this.channel) ? rm : null;
        }

        protected void logMessage(String message) {
            LoggerUtils.warning(GroupService.this.logger, GroupService.this.repNode.getRepImpl(), message);
        }
    }
}

