/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.types;

import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.types.ArrayType;
import com.snowflake.snowpark.types.BinaryType$;
import com.snowflake.snowpark.types.BooleanType$;
import com.snowflake.snowpark.types.ByteType$;
import com.snowflake.snowpark.types.DataType;
import com.snowflake.snowpark.types.DateType$;
import com.snowflake.snowpark.types.DecimalType;
import com.snowflake.snowpark.types.DoubleType$;
import com.snowflake.snowpark.types.FloatType$;
import com.snowflake.snowpark.types.GeographyType$;
import com.snowflake.snowpark.types.GeometryType$;
import com.snowflake.snowpark.types.IntegerType$;
import com.snowflake.snowpark.types.LongType$;
import com.snowflake.snowpark.types.MapType;
import com.snowflake.snowpark.types.ShortType$;
import com.snowflake.snowpark.types.StringType$;
import com.snowflake.snowpark.types.StructField;
import com.snowflake.snowpark.types.StructType;
import com.snowflake.snowpark.types.StructuredArrayType;
import com.snowflake.snowpark.types.StructuredMapType;
import com.snowflake.snowpark.types.TimeType$;
import com.snowflake.snowpark.types.TimestampType$;
import com.snowflake.snowpark.types.VariantType$;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    public String toJavaType(DataType datatype) {
        ArrayType arrayType;
        DataType dataType;
        DataType dataType2 = datatype;
        if (ShortType$.MODULE$.equals(dataType2)) {
            return Short.class.getCanonicalName();
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return Integer.class.getCanonicalName();
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return Long.class.getCanonicalName();
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return Double.class.getCanonicalName();
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return Float.class.getCanonicalName();
        }
        if (dataType2 instanceof DecimalType) {
            return BigDecimal.class.getCanonicalName();
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return String.class.getCanonicalName();
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return Boolean.class.getCanonicalName();
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return Date.class.getCanonicalName();
        }
        if (TimeType$.MODULE$.equals(dataType2)) {
            return Time.class.getCanonicalName();
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return Timestamp.class.getCanonicalName();
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return "byte[]";
        }
        if (dataType2 instanceof ArrayType && StringType$.MODULE$.equals(dataType = (arrayType = (ArrayType)dataType2).elementType())) {
            return "String[]";
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType dataType3 = mapType.keyType();
            DataType dataType4 = mapType.valueType();
            if (StringType$.MODULE$.equals(dataType3) && StringType$.MODULE$.equals(dataType4)) {
                return "java.util.Map<String,String>";
            }
        }
        if (GeographyType$.MODULE$.equals(dataType2)) {
            return "Geography";
        }
        if (GeometryType$.MODULE$.equals(dataType2)) {
            return "Geometry";
        }
        if (VariantType$.MODULE$.equals(dataType2)) {
            return "Variant";
        }
        throw new UnsupportedOperationException(new StringBuilder(29).append(datatype.toString()).append(" not supported for scala UDFs").toString());
    }

    public String toUDFArgumentType(DataType datatype) {
        ArrayType arrayType;
        DataType dataType;
        DataType dataType2 = datatype;
        if (GeographyType$.MODULE$.equals(dataType2)) {
            return String.class.getCanonicalName();
        }
        if (GeometryType$.MODULE$.equals(dataType2)) {
            return String.class.getCanonicalName();
        }
        if (VariantType$.MODULE$.equals(dataType2)) {
            return String.class.getCanonicalName();
        }
        if (dataType2 instanceof ArrayType && VariantType$.MODULE$.equals(dataType = (arrayType = (ArrayType)dataType2).elementType())) {
            return "String[]";
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType dataType3 = mapType.keyType();
            DataType dataType4 = mapType.valueType();
            if (StringType$.MODULE$.equals(dataType3) && VariantType$.MODULE$.equals(dataType4)) {
                return "java.util.Map<String,String>";
            }
        }
        return this.toJavaType(datatype);
    }

    public String convertToSFType(DataType dataType) {
        boolean bl = false;
        StructType structType = null;
        DataType dataType2 = dataType;
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return new StringBuilder(10).append("NUMBER(").append(decimalType.precision()).append(", ").append(decimalType.scale()).append(")").toString();
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return "INT";
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return "SMALLINT";
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return "BYTEINT";
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return "BIGINT";
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return "FLOAT";
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return "DOUBLE";
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return "STRING";
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return "BOOLEAN";
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return "DATE";
        }
        if (TimeType$.MODULE$.equals(dataType2)) {
            return "TIME";
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return "TIMESTAMP";
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return "BINARY";
        }
        if (dataType2 instanceof StructuredArrayType) {
            StructuredArrayType structuredArrayType = (StructuredArrayType)dataType2;
            String nullable = structuredArrayType.nullable() ? "" : " not null";
            return new StringBuilder(7).append("ARRAY(").append(this.convertToSFType(structuredArrayType.elementType())).append(nullable).append(")").toString();
        }
        if (dataType2 instanceof StructuredMapType) {
            StructuredMapType structuredMapType = (StructuredMapType)dataType2;
            String isValueNullable = structuredMapType.isValueNullable() ? "" : " not null";
            return new StringBuilder(7).append("MAP(").append(this.convertToSFType(structuredMapType.keyType())).append(", ").append(this.convertToSFType(structuredMapType.valueType())).append(isValueNullable).append(")").toString();
        }
        if (dataType2 instanceof StructType) {
            bl = true;
            structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            String fieldStr = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> new StringBuilder(2).append(field.name()).append(" ").append(MODULE$.convertToSFType(field.dataType())).append(" ").append((Object)(field.nullable() ? "" : "not null")).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
            return new StringBuilder(8).append("OBJECT(").append(fieldStr).append(")").toString();
        }
        if (dataType2 instanceof ArrayType) {
            return "ARRAY";
        }
        if (dataType2 instanceof MapType) {
            return "OBJECT";
        }
        if (VariantType$.MODULE$.equals(dataType2)) {
            return "VARIANT";
        }
        if (GeographyType$.MODULE$.equals(dataType2)) {
            return "GEOGRAPHY";
        }
        if (GeometryType$.MODULE$.equals(dataType2)) {
            return "GEOMETRY";
        }
        if (bl) {
            return "OBJECT";
        }
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dataType.typeName()).toString());
    }

    public DataType javaTypeToDataType(Class<?> cls) {
        String className = cls.getCanonicalName();
        String string = className;
        if ("short".equals(string) ? true : "java.lang.Short".equals(string)) {
            return ShortType$.MODULE$;
        }
        if ("int".equals(string) ? true : "java.lang.Integer".equals(string)) {
            return IntegerType$.MODULE$;
        }
        if ("long".equals(string) ? true : "java.lang.Long".equals(string)) {
            return LongType$.MODULE$;
        }
        if ("float".equals(string) ? true : "java.lang.Float".equals(string)) {
            return FloatType$.MODULE$;
        }
        if ("double".equals(string) ? true : "java.lang.Double".equals(string)) {
            return DoubleType$.MODULE$;
        }
        if ("java.math.BigDecimal".equals(string)) {
            return new DecimalType(38, 18);
        }
        if ("boolean".equals(string) ? true : "java.lang.Boolean".equals(string)) {
            return BooleanType$.MODULE$;
        }
        if ("java.lang.String".equals(string)) {
            return StringType$.MODULE$;
        }
        if ("byte[]".equals(string)) {
            return BinaryType$.MODULE$;
        }
        if ("java.sql.Date".equals(string)) {
            return DateType$.MODULE$;
        }
        if ("java.sql.Time".equals(string)) {
            return TimeType$.MODULE$;
        }
        if ("java.sql.Timestamp".equals(string)) {
            return TimestampType$.MODULE$;
        }
        if ("com.snowflake.snowpark_java.types.Variant".equals(string)) {
            return VariantType$.MODULE$;
        }
        if ("java.lang.String[]".equals(string)) {
            return new ArrayType(StringType$.MODULE$);
        }
        if ("com.snowflake.snowpark_java.types.Variant[]".equals(string)) {
            return new ArrayType(VariantType$.MODULE$);
        }
        if ("java.util.Map".equals(string)) {
            throw ErrorMessage$.MODULE$.UDF_CANNOT_INFER_MAP_TYPES();
        }
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(className).toString());
    }

    private package$() {
        MODULE$ = this;
    }
}

